/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.RouterService;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;

public class ConnectionWatchdog
implements Runnable {
    private static final int EVALUATE_TIME = 10000;
    private static final int REEVALUATE_TIME = 8000;
    private ConnectionManager manager;
    private MessageRouter router;

    public ConnectionWatchdog(ConnectionManager connectionManager, MessageRouter messageRouter) {
        this.manager = connectionManager;
        this.router = messageRouter;
    }

    private List findDuds() {
        Object object;
        HashMap hashMap = new HashMap();
        Iterator iterator = this.allConnections();
        while (iterator.hasNext()) {
            object = (ManagedConnection)iterator.next();
            if (!((ManagedConnection)object).isKillable()) continue;
            hashMap.put(object, new ConnectionState((ManagedConnection)object));
        }
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        object = new ArrayList();
        Iterator iterator2 = this.allConnections();
        while (iterator2.hasNext()) {
            ConnectionState connectionState;
            ConnectionState connectionState2;
            Object object2;
            ManagedConnection managedConnection = (ManagedConnection)iterator2.next();
            if (!managedConnection.isKillable() || (object2 = hashMap.get(managedConnection)) == null || !(connectionState2 = new ConnectionState(managedConnection)).notProgressedSince(connectionState = (ConnectionState)object2)) continue;
            object.add(managedConnection);
        }
        return object;
    }

    private void killIfStillDud(List list) {
        Object object;
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (ManagedConnection)iterator.next();
            if (!((ManagedConnection)object).isKillable()) continue;
            hashMap.put(object, new ConnectionState((ManagedConnection)object));
            ((ManagedConnection)object).setHorizonEnabled(false);
            this.router.sendPingRequest(new PingRequest(1), (ManagedConnection)object);
        }
        try {
            Thread.currentThread();
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        object = list.iterator();
        while (object.hasNext()) {
            ConnectionState connectionState;
            ConnectionState connectionState2;
            ManagedConnection managedConnection = (ManagedConnection)object.next();
            if (!managedConnection.isKillable()) continue;
            managedConnection.setHorizonEnabled(true);
            Object object2 = hashMap.get(managedConnection);
            if (object2 == null || !(connectionState2 = new ConnectionState(managedConnection)).notProgressedSince(connectionState = (ConnectionState)object2)) continue;
            this.manager.remove(managedConnection);
        }
    }

    public void run() {
        try {
            while (true) {
                List list;
                if ((list = this.findDuds()).size() <= 0) {
                    continue;
                }
                this.killIfStillDud(list);
            }
        }
        catch (Throwable throwable) {
            RouterService.error(throwable);
            return;
        }
    }

    private Iterator allConnections() {
        List list = this.manager.getInitializedConnections();
        List list2 = this.manager.getInitializedClientConnections();
        ArrayList arrayList = new ArrayList(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList.iterator();
    }

    private static class ConnectionState {
        long sentDropped;
        long sent;
        long received;

        ConnectionState(ManagedConnection managedConnection) {
            this.sentDropped = managedConnection.getNumSentMessagesDropped();
            this.sent = managedConnection.getNumMessagesSent();
            this.received = managedConnection.getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState connectionState) {
            long l = this.sent - connectionState.sent;
            long l2 = this.sentDropped - connectionState.sentDropped;
            long l3 = this.received - connectionState.received;
            if (l == l2 && l != 0L) {
                return true;
            }
            return l3 == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

