/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.AutoDownloadDetails;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RequeryDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.util.URLDecoder;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;

public class DownloadManager
implements BandwidthTracker {
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private ActivityCallback callback;
    private MessageRouter router;
    private Acceptor acceptor;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
    private List active = new LinkedList();
    private List waiting = new LinkedList();
    public static long TIME_BETWEEN_REQUERIES = 2700000L;
    private long lastRequeryTime = 0L;
    private List querySentMDs = new ArrayList();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private final boolean debugOn = false;

    public void initialize() {
        this.callback = RouterService.getCallback();
        this.router = RouterService.getMessageRouter();
        this.acceptor = RouterService.getAcceptor();
        this.fileManager = RouterService.getFileManager();
    }

    public void postGuiInit() {
        this.readSnapshot(SettingsManager.instance().getDownloadSnapshotFile());
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (DownloadManager.this.downloadsInProgress() > 0) {
                        DownloadManager.this.writeSnapshot();
                    }
                }
                catch (Throwable throwable) {
                    RouterService.error(throwable);
                }
            }
        };
        RouterService.schedule(runnable, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME);
    }

    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    synchronized boolean writeSnapshot() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.active);
        arrayList.addAll(this.waiting);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(SettingsManager.instance().getDownloadSnapshotFile()));
            objectOutputStream.writeObject(arrayList);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                objectOutputStream.writeObject(this.incompleteFileManager);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized boolean readSnapshot(File file) {
        Object object;
        List list = null;
        try {
            object = new ObjectInputStream(new FileInputStream(file));
            list = (List)((ObjectInputStream)object).readObject();
            this.incompleteFileManager = (IncompleteFileManager)((ObjectInputStream)object).readObject();
        }
        catch (IOException iOException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (this.incompleteFileManager.purge(true)) {
            this.writeSnapshot();
        }
        try {
            object = list.iterator();
            while (object.hasNext()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)object.next();
                this.waiting.add(managedDownloader);
                managedDownloader.initialize(this, this.fileManager, this.callback);
                this.callback.addDownload(managedDownloader);
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public synchronized Downloader download(RemoteFileDesc[] remoteFileDescArray, boolean bl) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        Serializable serializable;
        String string = this.conflicts(remoteFileDescArray, null);
        if (string != null) {
            throw new AlreadyDownloadingException(string);
        }
        if (!bl) {
            serializable = SettingsManager.instance().getSaveDirectory();
            int n = 0;
            while (n < remoteFileDescArray.length) {
                String string2 = remoteFileDescArray[n].getFileName();
                File file = new File((File)serializable, string2);
                if (file.exists()) {
                    throw new FileExistsException(string2);
                }
                ++n;
            }
        }
        this.incompleteFileManager.purge(false);
        serializable = new ManagedDownloader(remoteFileDescArray, this.incompleteFileManager);
        ((ManagedDownloader)serializable).initialize(this, this.fileManager, this.callback);
        this.waiting.add(serializable);
        this.callback.addDownload((Downloader)((Object)serializable));
        this.writeSnapshot();
        return serializable;
    }

    public synchronized Downloader download(File file) throws AlreadyDownloadingException, CantResumeException {
        ManagedDownloader managedDownloader;
        Object object;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            object = (ManagedDownloader)iterator.next();
            if (!((ManagedDownloader)object).conflicts(file)) continue;
            throw new AlreadyDownloadingException(((ManagedDownloader)object).getFileName());
        }
        object = this.waiting.iterator();
        while (object.hasNext()) {
            managedDownloader = (ManagedDownloader)object.next();
            if (!managedDownloader.conflicts(file)) continue;
            throw new AlreadyDownloadingException(managedDownloader.getFileName());
        }
        this.incompleteFileManager.purge(false);
        managedDownloader = null;
        try {
            String string = IncompleteFileManager.getCompletedName(file);
            int n = ByteOrder.long2int(IncompleteFileManager.getCompletedSize(file));
            managedDownloader = new ResumeDownloader(this.incompleteFileManager, file, string, n);
            ((ResumeDownloader)managedDownloader).initialize(this, this.fileManager, this.callback);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CantResumeException(file.getName());
        }
        this.waiting.add(managedDownloader);
        this.callback.addDownload(managedDownloader);
        this.writeSnapshot();
        this.router.broadcastQueryRequest(((ResumeDownloader)managedDownloader).newRequery());
        return managedDownloader;
    }

    public synchronized Downloader download(String string, String string2, byte[] byArray, MediaType mediaType) throws AlreadyDownloadingException {
        AutoDownloadDetails autoDownloadDetails = new AutoDownloadDetails(string, string2, byArray, mediaType);
        if (this.requeryConflicts(autoDownloadDetails)) {
            throw new AlreadyDownloadingException(string);
        }
        this.incompleteFileManager.purge(false);
        RequeryDownloader requeryDownloader = new RequeryDownloader(this.incompleteFileManager, autoDownloadDetails);
        requeryDownloader.initialize(this, this.fileManager, this.callback);
        this.waiting.add(requeryDownloader);
        this.callback.addDownload(requeryDownloader);
        this.writeSnapshot();
        return requeryDownloader;
    }

    public synchronized String conflicts(RemoteFileDesc[] remoteFileDescArray, ManagedDownloader managedDownloader) {
        int n = 0;
        while (n < remoteFileDescArray.length) {
            Object object;
            Iterator iterator = this.active.iterator();
            while (iterator.hasNext()) {
                object = (ManagedDownloader)iterator.next();
                if (managedDownloader != null && object == managedDownloader || !((ManagedDownloader)object).conflicts(remoteFileDescArray[n])) continue;
                return remoteFileDescArray[n].getFileName();
            }
            object = this.waiting.iterator();
            while (object.hasNext()) {
                ManagedDownloader managedDownloader2 = (ManagedDownloader)object.next();
                if (managedDownloader != null && managedDownloader2 == managedDownloader || !managedDownloader2.conflicts(remoteFileDescArray[n])) continue;
                return remoteFileDescArray[n].getFileName();
            }
            ++n;
        }
        return null;
    }

    private synchronized boolean requeryConflicts(AutoDownloadDetails autoDownloadDetails) {
        ManagedDownloader managedDownloader;
        Object object;
        boolean bl = false;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext() && !bl) {
            object = (ManagedDownloader)iterator.next();
            if (!(object instanceof RequeryDownloader)) continue;
            managedDownloader = (RequeryDownloader)object;
            bl = ((RequeryDownloader)managedDownloader).conflicts(autoDownloadDetails);
        }
        object = this.waiting.iterator();
        while (object.hasNext() && !bl) {
            managedDownloader = (ManagedDownloader)object.next();
            if (!(managedDownloader instanceof RequeryDownloader)) continue;
            ManagedDownloader managedDownloader2 = managedDownloader;
            bl = ((RequeryDownloader)managedDownloader2).conflicts(autoDownloadDetails);
        }
        return bl;
    }

    public void handleQueryReply(QueryReply queryReply) {
        if (queryReply.calculateQualityOfService(!this.acceptor.acceptedIncoming()) < 1) {
            return;
        }
        RemoteFileDesc[] remoteFileDescArray = null;
        try {
            remoteFileDescArray = queryReply.toRemoteFileDescArray(this.acceptor.acceptedIncoming());
        }
        catch (BadPacketException badPacketException) {
            this.debug(badPacketException);
            remoteFileDescArray = new RemoteFileDesc[]{};
        }
        this.handleManagedDownloaderAdditions(remoteFileDescArray);
    }

    private void handleManagedDownloaderAdditions(RemoteFileDesc[] remoteFileDescArray) {
        if (remoteFileDescArray.length == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            arrayList.addAll(this.active);
            arrayList.addAll(this.waiting);
        }
        int n = 0;
        while (n < remoteFileDescArray.length) {
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)arrayList.get(n2);
                if (managedDownloader.addDownload(remoteFileDescArray[n])) break;
                ++n2;
            }
            ++n;
        }
    }

    public void acceptDownload(Socket socket) {
        try {
            GIVLine gIVLine = DownloadManager.parseGIV(socket);
            String string = gIVLine.file;
            int n = gIVLine.index;
            byte[] byArray = gIVLine.clientGUID;
            DownloadManager downloadManager = this;
            synchronized (downloadManager) {
                Object object;
                BrowseHostHandler.handlePush(n, new GUID(byArray), socket);
                Iterator iterator = this.active.iterator();
                while (iterator.hasNext()) {
                    object = (ManagedDownloader)iterator.next();
                    if (!((ManagedDownloader)object).acceptDownload(string, socket, n, byArray)) continue;
                    return;
                }
                object = this.waiting.iterator();
                while (object.hasNext()) {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object.next();
                    if (!managedDownloader.acceptDownload(string, socket, n, byArray)) continue;
                    return;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean hasFreeSlot() {
        SettingsManager settingsManager = SettingsManager.instance();
        return this.active.size() < settingsManager.getMaxSimDownload();
    }

    public synchronized void waitForSlot(ManagedDownloader managedDownloader) throws InterruptedException {
        while (!this.hasFreeSlot()) {
            this.wait();
        }
        this.waiting.remove(managedDownloader);
        this.active.add(managedDownloader);
    }

    public synchronized void yieldSlot(ManagedDownloader managedDownloader) {
        Assert.that(managedDownloader != null, "Null downloader");
        Assert.that(this.active != null, "Null active");
        Assert.that(this.waiting != null, "Null waiting");
        this.active.remove(managedDownloader);
        this.waiting.add(managedDownloader);
        this.notify();
    }

    public synchronized void remove(ManagedDownloader managedDownloader, boolean bl) {
        this.active.remove(managedDownloader);
        this.waiting.remove(managedDownloader);
        this.notify();
        this.callback.removeDownload(managedDownloader);
        this.writeSnapshot();
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback.downloadsComplete();
        }
    }

    public synchronized boolean sendQuery(ManagedDownloader managedDownloader, QueryRequest queryRequest) {
        this.debug("DM.sendQuery(): entered.");
        Assert.that(this.waiting.contains(managedDownloader), "Unknown or non-waiting MD trying to send requery.");
        if (System.currentTimeMillis() - this.lastRequeryTime <= TIME_BETWEEN_REQUERIES) {
            return false;
        }
        if (this.querySentMDs.size() >= this.waiting.size()) {
            this.querySentMDs.clear();
        }
        if (this.querySentMDs.contains(managedDownloader)) {
            this.debug("DM.sendQuery(): sorry, wait your turn...");
            return false;
        }
        this.debug("DM.sendQuery(): requery allowed!!");
        this.querySentMDs.add(managedDownloader);
        this.lastRequeryTime = System.currentTimeMillis();
        this.router.broadcastQueryRequest(queryRequest);
        return true;
    }

    public boolean sendPush(RemoteFileDesc remoteFileDesc) {
        PushRequest pushRequest = new PushRequest(GUID.makeGuid(), SettingsManager.instance().getTTL(), remoteFileDesc.getClientGUID(), remoteFileDesc.getIndex(), this.acceptor.getAddress(), this.acceptor.getPort());
        try {
            this.router.sendPushRequest(pushRequest);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static GIVLine parseGIV(Socket socket) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = socket.getInputStream();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        ByteReader byteReader = new ByteReader(inputStream);
        String string = byteReader.readLine();
        if (string == null) {
            throw new IOException();
        }
        String string2 = byteReader.readLine();
        if (string2 == null || !string2.equals("")) {
            throw new IOException();
        }
        try {
            int n = string.indexOf(":");
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = string.indexOf("/", n);
            byte[] byArray = GUID.fromHexString(string.substring(n + 1, n3));
            String string3 = URLDecoder.decode(string.substring(n3 + 1));
            return new GIVLine(string3, n2, byArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException();
        }
    }

    public synchronized void measureBandwidth() {
        float f = 0.0f;
        boolean bl = false;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            bl = true;
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            bandwidthTracker.measureBandwidth();
            f += bandwidthTracker.getAverageBandwidth();
        }
        if (bl) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    public void internalError(Throwable throwable) {
        this.callback.error(13, throwable);
    }

    private final void debug(String string) {
    }

    private final void debug(Exception exception) {
    }

    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    private static class GIVLine {
        String file;
        int index;
        byte[] clientGUID;

        GIVLine(String string, int n, byte[] byArray) {
            this.clientGUID = byArray;
            this.file = string;
            this.index = n;
            this.clientGUID = byArray;
        }
    }
}

