/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Comparable;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Endpoint
implements Cloneable,
Serializable,
Comparable {
    static final long serialVersionUID = 4686711693494625070L;
    private String hostname = null;
    int port = 0;
    private long files = -1L;
    private long kbytes = -1L;
    private byte[] hostBytes = null;
    public transient boolean processed = false;
    private int connectivity = 0;
    private transient int weight = 0;

    public void setConnectivity(int n) {
        this.connectivity = n;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getConnectivity() {
        return this.connectivity;
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException();
        }
        Endpoint endpoint = (Endpoint)object;
        if (this.weight > endpoint.weight) {
            return 1;
        }
        if (this.weight < endpoint.weight) {
            return -1;
        }
        return 0;
    }

    public Endpoint(String string) throws IllegalArgumentException {
        this(string, false);
    }

    public Endpoint(String string, boolean bl) throws IllegalArgumentException {
        int n = string.indexOf(":");
        if (n < 0) {
            this.hostname = string;
            this.port = 6346;
        } else {
            if (n == 0) {
                throw new IllegalArgumentException();
            }
            if (n == string.length() - 1) {
                this.hostname = string.substring(0, n);
                this.port = 6346;
            } else {
                this.hostname = string.substring(0, n);
                try {
                    this.port = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (bl) {
            String[] stringArray = StringUtils.split(this.hostname, '.');
            if (stringArray.length != 4) {
                throw new IllegalArgumentException();
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    int n3 = Integer.parseInt(stringArray[n2]);
                    if (n3 < 0 || n3 > 255) {
                        throw new IllegalArgumentException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
                ++n2;
            }
        }
    }

    public Endpoint(String string, int n) {
        this.hostname = string;
        this.port = n;
    }

    public Endpoint(byte[] byArray, int n) {
        this.hostBytes = byArray;
        this.port = n;
        this.hostname = Message.ip2string(byArray);
    }

    public Endpoint(String string, int n, long l, long l2) {
        this(string, n);
        this.files = l;
        this.kbytes = l2;
    }

    public Endpoint(byte[] byArray, int n, long l, long l2) {
        this(byArray, n);
        this.files = l;
        this.kbytes = l2;
    }

    public Endpoint(Endpoint endpoint) {
        this.connectivity = endpoint.connectivity;
        this.files = endpoint.files;
        this.hostname = endpoint.hostname;
        this.hostBytes = endpoint.hostBytes;
        this.kbytes = endpoint.kbytes;
        this.port = endpoint.port;
        this.processed = endpoint.processed;
        this.weight = endpoint.weight;
    }

    public String toString() {
        return this.hostname + ":" + this.port + " connectivity=" + this.connectivity + " files=" + this.files + " kbytes=" + this.kbytes;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public int getPort() {
        return this.port;
    }

    public long getFiles() {
        return this.files;
    }

    public void setFiles(long l) {
        this.files = l;
    }

    public long getKbytes() {
        return this.kbytes;
    }

    public void normalizeFilesAndSize() {
        try {
            if (this.kbytes > 20000000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
            if (this.files > 5000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
            if (this.kbytes / this.files > 250000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
        }
        catch (ArithmeticException arithmeticException) {
            this.kbytes = 0L;
            this.files = 0L;
            return;
        }
    }

    public void setKbytes(long l) {
        this.kbytes = l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)object;
        return this.hostname.equals(endpoint.hostname) && this.port == endpoint.port;
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    protected Object clone() {
        return new Endpoint(new String(this.hostname), this.port, this.files, this.kbytes);
    }

    public byte[] getHostBytes() throws UnknownHostException {
        if (this.hostBytes == null) {
            this.hostBytes = InetAddress.getByName(this.hostname).getAddress();
        }
        return this.hostBytes;
    }

    public boolean isPrivateAddress() {
        try {
            return Endpoint.isPrivateAddress(this.getHostBytes());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isPrivateAddress(byte[] byArray) {
        if (byArray[0] == 10) {
            return true;
        }
        if (byArray[0] == 127 && SettingsManager.instance().getLocalIsPrivate()) {
            return true;
        }
        if (byArray[0] == -84 && byArray[1] >= 16 && byArray[1] <= 31) {
            return true;
        }
        if (byArray[0] == -64 && byArray[1] == -88) {
            return true;
        }
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0;
    }

    public boolean isSameSubnet(Endpoint endpoint) {
        byte[] byArray;
        int n;
        byte[] byArray2;
        try {
            byArray2 = this.getHostBytes();
            n = ByteOrder.ubyte2int(byArray2[0]);
            byArray = endpoint.getHostBytes();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (n <= 127) {
            return byArray2[0] == byArray[0];
        }
        if (n <= 191) {
            return byArray2[0] == byArray[0] && byArray2[1] == byArray[1];
        }
        return byArray2[0] == byArray[0] && byArray2[1] == byArray[1] && byArray2[2] == byArray[2];
    }
}

