/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;

public class ExtendedEndpoint
extends Endpoint {
    static final long DEFAULT_TIME_RECORDED = 0L;
    private long timeRecorded = -1L;
    static final int DEFAULT_DAILY_UPTIME = 345;
    private int dailyUptime = -1;
    static final int HISTORY_SIZE = 3;
    static final long WINDOW_TIME = 86400000L;
    private Buffer connectSuccesses = new Buffer(3);
    private Buffer connectFailures = new Buffer(3);
    private static final String LIST_SEPARATOR = ";";
    private static final String FIELD_SEPARATOR = ",";
    static final String EOL = "\n";

    public ExtendedEndpoint(String string, int n, int n2) {
        super(string, n);
        this.dailyUptime = n2;
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String string, int n) {
        super(string, n);
        this.timeRecorded = this.now();
    }

    public long getTimeRecorded() {
        if (this.timeRecorded < 0L) {
            return 0L;
        }
        return this.timeRecorded;
    }

    public int getDailyUptime() {
        if (this.dailyUptime < 0) {
            return 345;
        }
        return this.dailyUptime;
    }

    public void recordConnectionSuccess() {
        this.recordConnectionAttempt(this.connectSuccesses, this.now());
    }

    public void recordConnectionFailure() {
        this.recordConnectionAttempt(this.connectFailures, this.now());
    }

    public Iterator getConnectionSuccesses() {
        return this.connectSuccesses.iterator();
    }

    public Iterator getConnectionFailures() {
        return this.connectFailures.iterator();
    }

    private void recordConnectionAttempt(Buffer buffer, long l) {
        if (buffer.isEmpty()) {
            buffer.addFirst(new Long(l));
        } else if (l - (Long)buffer.first() >= 86400000L) {
            buffer.addFirst(new Long(l));
        } else {
            buffer.removeFirst();
            buffer.addFirst(new Long(l));
        }
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.getHostname());
        writer.write(":");
        writer.write(Integer.toString(this.getPort()));
        writer.write(FIELD_SEPARATOR);
        if (this.dailyUptime >= 0) {
            writer.write(Integer.toString(this.dailyUptime));
        }
        writer.write(FIELD_SEPARATOR);
        if (this.timeRecorded >= 0L) {
            writer.write(Long.toString(this.timeRecorded));
        }
        writer.write(FIELD_SEPARATOR);
        this.write(writer, this.getConnectionSuccesses());
        writer.write(FIELD_SEPARATOR);
        this.write(writer, this.getConnectionFailures());
        writer.write(EOL);
    }

    private void write(Writer writer, Iterator iterator) throws IOException {
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            writer.write(Long.toString(l));
            if (!iterator.hasNext()) continue;
            writer.write(LIST_SEPARATOR);
        }
    }

    public static ExtendedEndpoint read(String string) throws ParseException {
        int n;
        String[] stringArray;
        int n2;
        String string2;
        Endpoint endpoint;
        String[] stringArray2 = StringUtils.splitNoCoalesce(string, FIELD_SEPARATOR);
        if (stringArray2.length == 0) {
            throw new ParseException("Empty line", 0);
        }
        try {
            endpoint = new Endpoint(stringArray2[0], true);
            string2 = endpoint.getHostname();
            n2 = endpoint.getPort();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Couldn't extract address and port", 0);
        }
        endpoint = new ExtendedEndpoint(string2, n2);
        if (stringArray2.length >= 2) {
            try {
                ((ExtendedEndpoint)endpoint).dailyUptime = Integer.parseInt(stringArray2[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ((ExtendedEndpoint)endpoint).timeRecorded = 0L;
        if (stringArray2.length >= 3) {
            try {
                ((ExtendedEndpoint)endpoint).timeRecorded = Long.parseLong(stringArray2[2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (stringArray2.length >= 4) {
            try {
                stringArray = StringUtils.split(stringArray2[3], LIST_SEPARATOR);
                n = stringArray.length - 1;
                while (n >= 0) {
                    super.recordConnectionAttempt(((ExtendedEndpoint)endpoint).connectSuccesses, Long.parseLong(stringArray[n].trim()));
                    --n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (stringArray2.length >= 5) {
            try {
                stringArray = StringUtils.split(stringArray2[4], LIST_SEPARATOR);
                n = stringArray.length - 1;
                while (n >= 0) {
                    super.recordConnectionAttempt(((ExtendedEndpoint)endpoint).connectFailures, Long.parseLong(stringArray[n].trim()));
                    --n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return endpoint;
    }

    public static Comparator priorityComparator() {
        return new PriorityComparator();
    }

    private int connectScore() {
        long l;
        if (this.connectSuccesses.isEmpty() && this.connectFailures.isEmpty()) {
            return 0;
        }
        if (this.connectSuccesses.isEmpty()) {
            return -1;
        }
        if (this.connectFailures.isEmpty()) {
            return 1;
        }
        long l2 = (Long)this.connectSuccesses.last();
        if (l2 > (l = ((Long)this.connectFailures.last()).longValue())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    static class PriorityComparator
    implements Comparator {
        PriorityComparator() {
        }

        public int compare(Object object, Object object2) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)object;
            ExtendedEndpoint extendedEndpoint2 = (ExtendedEndpoint)object2;
            int n = extendedEndpoint.connectScore() - extendedEndpoint2.connectScore();
            if (n != 0) {
                return n;
            }
            return extendedEndpoint.getDailyUptime() - extendedEndpoint2.getDailyUptime();
        }
    }
}

