/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileDesc
implements AlternateLocationCollector {
    private final int _index;
    private final String _path;
    private final String _name;
    private final int _size;
    private long _modTime;
    private final Set URNS;
    private final File FILE;
    private AlternateLocationCollection _altLocs;
    private int _hits;
    private int _attemptedUploads;
    private int _completedUploads;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public FileDesc(File file, Set set, int n) {
        if (file == null) {
            throw new NullPointerException("cannot create a FileDesc with a null File");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative values not permitted in FileDesc: " + n);
        }
        if (set == null) {
            throw new NullPointerException("cannot create a FileDesc with a null URN Set");
        }
        this.FILE = new File(file.getAbsolutePath());
        this._index = n;
        this._name = this.FILE.getName();
        this._path = this.FILE.getAbsolutePath();
        this._size = (int)this.FILE.length();
        this._modTime = this.FILE.lastModified();
        this.URNS = Collections.unmodifiableSet(set);
        this._hits = 0;
    }

    public static Set calculateAndCacheURN(File file) {
        if (file == null) {
            throw new NullPointerException("cannot accept null file argument");
        }
        Set set = UrnCache.instance().getUrns(file);
        if (set.size() == 0) {
            set = Collections.unmodifiableSet(FileDesc.calculateUrns(file));
            UrnCache.instance().addUrns(file, set);
        }
        return set;
    }

    public boolean hasUrns() {
        return !this.URNS.isEmpty();
    }

    public int getIndex() {
        return this._index;
    }

    public long getSize() {
        return this._size;
    }

    public String getName() {
        return this._name;
    }

    public long lastModified() {
        return this._modTime;
    }

    public URN getSHA1Urn() {
        Iterator iterator = this.URNS.iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (!uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public File getFile() {
        return new File(this.FILE.getAbsolutePath());
    }

    public Set getUrns() {
        return this.URNS;
    }

    public String getPath() {
        return this.FILE.getAbsolutePath();
    }

    public AlternateLocationCollection getAlternateLocationCollection() {
        return this._altLocs;
    }

    public void addAlternateLocation(AlternateLocation alternateLocation) {
        if (alternateLocation == null) {
            throw new NullPointerException("cannot accept null alt locs");
        }
        this.createAlternateLocations();
        this._altLocs.addAlternateLocation(alternateLocation);
    }

    public void addAlternateLocationCollection(AlternateLocationCollection alternateLocationCollection) {
        if (alternateLocationCollection == null) {
            throw new NullPointerException("cannot accept null alt loc coll");
        }
        this.createAlternateLocations();
        this._altLocs.addAlternateLocationCollection(alternateLocationCollection);
    }

    public boolean hasAlternateLocations() {
        if (this._altLocs == null) {
            return false;
        }
        return this._altLocs.hasAlternateLocations();
    }

    public int numberOfAlternateLocations() {
        if (this._altLocs == null) {
            return 0;
        }
        return this._altLocs.numberOfAlternateLocations();
    }

    private void createAlternateLocations() {
        if (this._altLocs == null) {
            this._altLocs = new AlternateLocationCollection();
        }
    }

    private static Set calculateUrns(File file) {
        try {
            HashSet hashSet = new HashSet();
            hashSet.add(URN.createSHA1Urn(file));
            return hashSet;
        }
        catch (InterruptedException interruptedException) {
            return EMPTY_SET;
        }
        catch (IOException iOException) {
            return EMPTY_SET;
        }
    }

    public boolean containsUrn(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null URNS not allowed in containsUrn");
        }
        Iterator iterator = this.URNS.iterator();
        while (iterator.hasNext()) {
            if (!uRN.equals((URN)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public int incrementHitCount() {
        return ++this._hits;
    }

    public int getHitCount() {
        return this._hits;
    }

    public int incrementAttemptedUploads() {
        return ++this._attemptedUploads;
    }

    public int getAttemptedUploads() {
        return this._attemptedUploads;
    }

    public int incrementCompletedUploads() {
        return ++this._completedUploads;
    }

    public int getCompletedUploads() {
        return this._completedUploads;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        return new FileInputStream(this.FILE);
    }

    public String toString() {
        return "FileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this._index + "\r\n" + "path:     " + this._path + "\r\n" + "size:     " + this._size + "\r\n" + "modTime:  " + this._modTime + "\r\n" + "File:     " + this.FILE + "\r\n" + "urns:     " + this.URNS + "\r\n" + "alt locs: " + this._altLocs + "\r\n";
    }
}

