/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.util.FileComparator;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.IntSet;
import com.limegroup.gnutella.util.StringComparator;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class FileManager {
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    private long _size = 0L;
    private int _numFiles = 0;
    private int _numPendingFiles = 0;
    private List _files;
    private Trie _index;
    private Map _urnIndex;
    private static Set _extensions;
    private Map _sharedDirectories;
    private Thread _loadThread;
    private boolean _loadThreadInterrupted = false;
    private Object _loadThreadLock = new Object();
    protected static ActivityCallback _callback;
    public static final String DELIMETERS = " -._+/*()\\";
    private static boolean debugOn;
    private boolean DEBUG = false;

    private static final boolean isDelimeter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public FileManager() {
        this._files = new ArrayList();
        this._index = new Trie(true);
        this._urnIndex = new HashMap();
        _extensions = new TreeSet(new StringComparator());
        this._sharedDirectories = new TreeMap(new FileComparator());
    }

    public void initialize() {
        _callback = RouterService.getCallback();
        this.loadSettings(false);
    }

    public int getSize() {
        return ByteOrder.long2int(this._size);
    }

    public int getNumFiles() {
        return this._numFiles;
    }

    public int getNumPendingFiles() {
        return this._numPendingFiles;
    }

    public synchronized FileDesc get(int n) throws IndexOutOfBoundsException {
        FileDesc fileDesc = (FileDesc)this._files.get(n);
        if (fileDesc == null) {
            throw new IndexOutOfBoundsException();
        }
        return fileDesc;
    }

    public synchronized FileDesc getFileDescForUrn(URN uRN) {
        IntSet intSet = (IntSet)this._urnIndex.get(uRN);
        if (intSet == null) {
            return null;
        }
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        if (intSetIterator.hasNext()) {
            int n = intSetIterator.next();
            return (FileDesc)this._files.get(n);
        }
        return null;
    }

    public synchronized FileDesc getFileDescMatching(File file) {
        Iterator iterator = this._files.iterator();
        while (iterator.hasNext()) {
            FileDesc fileDesc = (FileDesc)iterator.next();
            if (fileDesc == null || !file.equals(fileDesc.getFile())) continue;
            return fileDesc;
        }
        return null;
    }

    public File[] getSharedFiles(File file) {
        FileDesc[] fileDescArray = this.getSharedFileDescriptors(file);
        if (fileDescArray == null) {
            return null;
        }
        File[] fileArray = new File[fileDescArray.length];
        int n = 0;
        while (n < fileDescArray.length) {
            fileArray[n] = fileDescArray[n].getFile();
            ++n;
        }
        return fileArray;
    }

    public synchronized FileDesc[] getSharedFileDescriptors(File file) {
        Object object;
        if (file != null) {
            try {
                file = FileManager.getCanonicalFile(file);
            }
            catch (IOException iOException) {
                return null;
            }
            IntSet intSet = (IntSet)this._sharedDirectories.get(file);
            if (intSet == null) {
                return null;
            }
            FileDesc[] fileDescArray = new FileDesc[intSet.size()];
            IntSet.IntSetIterator intSetIterator = intSet.iterator();
            int n = 0;
            while (intSetIterator.hasNext()) {
                FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
                Assert.that(fileDesc != null, "Directory has null entry");
                fileDescArray[n] = fileDesc;
                ++n;
            }
            return fileDescArray;
        }
        ArrayList arrayList = new ArrayList(this._files.size());
        int n = 0;
        while (n < this._files.size()) {
            object = (FileDesc)this._files.get(n);
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        object = new FileDesc[arrayList.size()];
        Object[] objectArray = arrayList.toArray((Object[])object);
        Assert.that(objectArray == object, "Couldn't fit list in returned value");
        return object;
    }

    public static File[] getFilesRecursive(File file, String[] stringArray) {
        FileManager.debug("FileManager.getFilesRecursive(): entered.");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        File[] fileArray = null;
        if (file.exists() && file.isDirectory()) {
            arrayList.add(file);
        }
        while (arrayList.size() > 0) {
            File file2 = (File)arrayList.remove(0);
            FileManager.debug("FileManager.getFilesRecursive(): currDir = " + file2);
            String[] stringArray2 = file2.list();
            int n = 0;
            while (n < stringArray2.length) {
                File file3 = new File(file2, stringArray2[n]);
                if (file3.isDirectory()) {
                    arrayList.add(file3);
                } else if (file3.isFile()) {
                    boolean bl = false;
                    if (stringArray == null) {
                        bl = true;
                    } else {
                        String string = FileManager.getFileExtension(file3);
                        int n2 = 0;
                        while (n2 < stringArray.length && string != null) {
                            if (string.equalsIgnoreCase(stringArray[n2])) {
                                bl = true;
                            }
                            ++n2;
                        }
                    }
                    if (bl) {
                        arrayList2.add(file3);
                    }
                }
                ++n;
            }
        }
        if (!arrayList2.isEmpty()) {
            fileArray = new File[arrayList2.size()];
            int n = 0;
            while (n < fileArray.length) {
                fileArray[n] = (File)arrayList2.get(n);
                ++n;
            }
        }
        FileManager.debug("FileManager.getFilesRecursive(): returning.");
        return fileArray;
    }

    private static String getFileExtension(File file) {
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
        if (stringTokenizer.countTokens() > 1) {
            stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
        }
        return string;
    }

    public static void debug(String string) {
        if (debugOn) {
            System.out.println(string);
        }
    }

    public void loadSettings(boolean bl) {
        Object object = this._loadThreadLock;
        synchronized (object) {
            if (this._loadThread != null) {
                this._loadThreadInterrupted = true;
                this._loadThread.interrupt();
                try {
                    this._loadThread.join();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            final boolean bl2 = bl;
            this._loadThreadInterrupted = false;
            this._loadThread = new Thread("FileManager.loadSettingsBlocking"){

                public void run() {
                    try {
                        FileManager.this.loadSettingsBlocking(bl2);
                    }
                    catch (Throwable throwable) {
                        _callback.error(throwable);
                    }
                }
            };
            this._loadThread.start();
        }
    }

    protected boolean loadThreadInterrupted() {
        return this._loadThreadInterrupted;
    }

    protected void loadSettingsBlocking(boolean bl) {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        FileManager fileManager = this;
        synchronized (fileManager) {
            this._size = 0L;
            this._numFiles = 0;
            this._numPendingFiles = 0;
            this._files = new ArrayList();
            this._index = new Trie(true);
            this._urnIndex = new HashMap();
            _extensions = new TreeSet(new StringComparator());
            this._sharedDirectories = new TreeMap(new FileComparator());
            objectArray2 = StringUtils.split(SettingsManager.instance().getExtensions().trim(), ';');
            n = 0;
            while (n < objectArray2.length && !this.loadThreadInterrupted()) {
                _extensions.add(objectArray2[n].toLowerCase());
                ++n;
            }
            Object[] objectArray3 = SettingsManager.instance().getDirectories();
            Arrays.sort(objectArray3, new Comparator(){

                public int compare(Object object, Object object2) {
                    return object.toString().length() - object2.toString().length();
                }
            });
            objectArray = objectArray3;
        }
        objectArray2 = objectArray;
        if (bl) {
            _callback.clearSharedFiles();
        }
        n = 0;
        while (n < objectArray2.length && !this.loadThreadInterrupted()) {
            this.addDirectory((File)objectArray2[n], null);
            ++n;
        }
        if (!this.loadThreadInterrupted()) {
            this.trim();
        }
        UrnCache.instance().persistCache();
    }

    private void addDirectory(File file, File file2) {
        Object object;
        try {
            file = FileManager.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        File[] fileArray = FileManager.listFiles(file);
        if (fileArray == null) {
            return;
        }
        int n = fileArray.length;
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._sharedDirectories.get(file) != null) {
                return;
            }
            this._sharedDirectories.put(file, new IntSet());
            if (_callback != null) {
                _callback.addSharedDirectory(file, file2);
            }
            this._numPendingFiles += n;
        }
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n && !this.loadThreadInterrupted()) {
            if (fileArray[n2].isDirectory()) {
                arrayList.add(fileArray[n2]);
            } else {
                this.addFile(fileArray[n2]);
            }
            object = this;
            synchronized (object) {
                --this._numPendingFiles;
            }
            ++n2;
        }
        object = arrayList.iterator();
        while (object.hasNext() && !this.loadThreadInterrupted()) {
            this.addDirectory((File)object.next(), file);
        }
    }

    public boolean addFileIfShared(File file) {
        boolean bl;
        File file2 = null;
        try {
            file2 = FileManager.getCanonicalFile(file);
            if (!file2.exists()) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        File file3 = FileManager.getParentFile(file);
        if (file3 == null) {
            return false;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            bl = this._sharedDirectories.containsKey(file3);
            ++this._numPendingFiles;
        }
        boolean bl2 = bl ? this.addFile(file) : false;
        FileManager fileManager2 = this;
        synchronized (fileManager2) {
            --this._numPendingFiles;
        }
        return bl2;
    }

    public boolean addFileIfShared(File file, LimeXMLDocument[] limeXMLDocumentArray) {
        return this.addFileIfShared(file);
    }

    private boolean addFile(File file) {
        this.repOk();
        long l = file.length();
        if (!FileManager.isFileShareable(file, l)) {
            return false;
        }
        Set set = FileDesc.calculateAndCacheURN(file);
        if (this.loadThreadInterrupted()) {
            return false;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            this._size += l;
            int n = this._files.size();
            FileDesc fileDesc = new FileDesc(file, set, n);
            this._files.add(fileDesc);
            ++this._numFiles;
            File file2 = FileManager.getParentFile(file);
            Assert.that(file2 != null, "Null parent to \"" + file + "\"");
            IntSet intSet = (IntSet)this._sharedDirectories.get(file2);
            Assert.that(intSet != null, "Add directory \"" + file2 + "\" not in " + this._sharedDirectories);
            boolean bl = intSet.add(n);
            Assert.that(bl, "File " + n + " already found in " + intSet);
            if (_callback != null) {
                _callback.addSharedFile(fileDesc, file2);
            }
            String[] stringArray = StringUtils.split(fileDesc.getPath(), DELIMETERS);
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                IntSet intSet2 = (IntSet)this._index.get(string);
                if (intSet2 == null) {
                    intSet2 = new IntSet();
                    this._index.add(string, intSet2);
                }
                intSet2.add(n);
                ++n2;
            }
            this.updateUrnIndex(fileDesc);
            this.repOk();
            boolean bl2 = true;
            return bl2;
        }
    }

    private synchronized void updateUrnIndex(FileDesc fileDesc) {
        Iterator iterator = fileDesc.getUrns().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet = (IntSet)this._urnIndex.get(uRN);
            if (intSet == null) {
                intSet = new IntSet();
                this._urnIndex.put(uRN, intSet);
            }
            intSet.add(fileDesc.getIndex());
        }
    }

    public synchronized boolean removeFileIfShared(File file) {
        this.repOk();
        try {
            file = FileManager.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            this.repOk();
            return false;
        }
        int n = 0;
        while (n < this._files.size()) {
            File file2;
            FileDesc fileDesc = (FileDesc)this._files.get(n);
            if (fileDesc != null && file.equals(file2 = fileDesc.getFile())) {
                this._files.set(n, null);
                --this._numFiles;
                this._size -= fileDesc.getSize();
                File file3 = FileManager.getParentFile(file);
                IntSet intSet = (IntSet)this._sharedDirectories.get(file3);
                Assert.that(intSet != null, "Rem directory \"" + file3 + "\" not in " + this._sharedDirectories);
                boolean bl = intSet.remove(n);
                Assert.that(bl, "File " + n + " not found in " + intSet);
                String[] stringArray = StringUtils.split(fileDesc.getPath(), DELIMETERS);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = stringArray[n2];
                    IntSet intSet2 = (IntSet)this._index.get(string);
                    if (intSet2 != null) {
                        intSet2.remove(n);
                    }
                    ++n2;
                }
                this.removeUrnIndex(fileDesc);
                this.repOk();
                return true;
            }
            ++n;
        }
        this.repOk();
        return false;
    }

    private synchronized void removeUrnIndex(FileDesc fileDesc) {
        Iterator iterator = fileDesc.getUrns().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet = (IntSet)this._urnIndex.get(uRN);
            Assert.that(intSet != null, "Invariant broken");
            intSet.remove(fileDesc.getIndex());
            if (intSet.size() != 0) continue;
            this._urnIndex.remove(uRN);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean renameFileIfShared(File file, File file2) {
        boolean bl;
        ActivityCallback activityCallback;
        block5: {
            boolean bl2;
            block4: {
                activityCallback = _callback;
                _callback = null;
                try {
                    boolean bl3 = this.removeFileIfShared(file);
                    if (!bl3) {
                        boolean bl4 = false;
                        Object var10_6 = null;
                        _callback = activityCallback;
                        return bl4;
                    }
                    boolean bl5 = this.addFileIfShared(file2);
                    if (!bl5) {
                        bl2 = false;
                        break block4;
                    }
                    bl = true;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    _callback = activityCallback;
                    throw throwable;
                }
            }
            Object var10_7 = null;
            _callback = activityCallback;
            return bl2;
        }
        Object var10_8 = null;
        _callback = activityCallback;
        return bl;
    }

    private synchronized void trim() {
        this._index.trim(new Function(){

            public Object apply(Object object) {
                ((IntSet)object).trim();
                return object;
            }
        });
    }

    private static boolean hasExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return _extensions.contains(string2);
    }

    public static boolean isFileShareable(File file, long l) {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.getName().toUpperCase().startsWith("LIMEWIRE") && !FileManager.hasExtension(file.getName())) {
            return false;
        }
        return l <= Integer.MAX_VALUE && l >= 0L;
    }

    public static File getParentFile(File file) {
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        try {
            return FileManager.getCanonicalFile(new File(string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File[] listFiles(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public List getKeyWords() {
        File[] fileArray = this.getSharedFiles(null);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < fileArray.length) {
            arrayList.add(fileArray[n].getAbsolutePath());
            ++n;
        }
        return arrayList;
    }

    public List getIndivisibleKeyWords() {
        return new ArrayList();
    }

    public static File getCanonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public synchronized Response[] query(QueryRequest queryRequest) {
        String string = queryRequest.getQuery();
        if (string.equals(INDEXING_QUERY) || string.equals(BROWSE_QUERY)) {
            if (this._numFiles == 0) {
                return null;
            }
            Response[] responseArray = new Response[this._numFiles];
            int n = 0;
            int n2 = 0;
            while (n2 < this._files.size()) {
                FileDesc fileDesc = (FileDesc)this._files.get(n2);
                if (fileDesc != null) {
                    Assert.that(n < responseArray.length, "_numFiles is too small");
                    responseArray[n] = new Response(fileDesc);
                    ++n;
                }
                ++n2;
            }
            Assert.that(n == responseArray.length, "_numFiles is too large");
            return responseArray;
        }
        IntSet intSet = null;
        intSet = this.search(string, intSet);
        if (queryRequest.getQueryUrns().size() > 0) {
            intSet = this.urnSearch(queryRequest.getQueryUrns().iterator(), intSet);
        }
        if (intSet == null) {
            return null;
        }
        Response[] responseArray = new Response[intSet.size()];
        int n = 0;
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext()) {
            int n3 = intSetIterator.next();
            FileDesc fileDesc = (FileDesc)this._files.get(n3);
            if (fileDesc != null) {
                fileDesc.incrementHitCount();
                if (_callback != null) {
                    _callback.handleSharedFileUpdate(fileDesc.getFile());
                }
                responseArray[n] = new Response(fileDesc);
            } else {
                Assert.that(false, "unexpected null in FileManager for query:\n" + queryRequest);
            }
            ++n;
        }
        return responseArray;
    }

    public synchronized FileDesc file2index(String string) {
        int n = 0;
        while (n < this._files.size()) {
            FileDesc fileDesc = (FileDesc)this._files.get(n);
            if (fileDesc != null && fileDesc.getPath().equals(string)) {
                return fileDesc;
            }
            ++n;
        }
        return null;
    }

    protected IntSet search(String string, IntSet intSet) {
        IntSet intSet2 = intSet;
        int n = 0;
        while (n < string.length()) {
            if (FileManager.isDelimeter(string.charAt(n))) {
                ++n;
                continue;
            }
            int n2 = n + 1;
            while (n2 < string.length()) {
                if (FileManager.isDelimeter(string.charAt(n2))) break;
                ++n2;
            }
            Iterator iterator = this._index.getPrefixedBy(string, n, n2);
            if (iterator.hasNext()) {
                IntSet intSet3 = null;
                while (iterator.hasNext()) {
                    IntSet intSet4 = (IntSet)iterator.next();
                    if (intSet3 == null) {
                        if (n == 0 && n2 == string.length() && !iterator.hasNext()) {
                            return intSet4;
                        }
                        intSet3 = new IntSet();
                    }
                    intSet3.addAll(intSet4);
                }
                if (intSet2 == null) {
                    intSet2 = intSet3;
                } else {
                    intSet2.retainAll(intSet3);
                }
            } else {
                return null;
            }
            if (intSet2.size() == 0) {
                return null;
            }
            n = n2;
        }
        if (intSet2 == null || intSet2.size() == 0) {
            return null;
        }
        return intSet2;
    }

    private synchronized IntSet urnSearch(Iterator iterator, IntSet intSet) {
        IntSet intSet2 = intSet;
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet3 = (IntSet)this._urnIndex.get(uRN);
            if (intSet3 == null) continue;
            IntSet.IntSetIterator intSetIterator = intSet3.iterator();
            while (intSetIterator.hasNext()) {
                FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
                if (fileDesc == null || !fileDesc.containsUrn(uRN)) continue;
                if (intSet2 == null) {
                    intSet2 = new IntSet();
                }
                intSet2.add(fileDesc.getIndex());
            }
        }
        return intSet2;
    }

    protected synchronized void repOk() {
        Object object;
        FileDesc fileDesc;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (!this.DEBUG) {
            return;
        }
        System.err.println("WARNING: running repOk()");
        IntSet intSet = new IntSet();
        Iterator iterator = this._index.getPrefixedBy("");
        while (iterator.hasNext()) {
            object5 = (IntSet)iterator.next();
            intSet.addAll((IntSet)object5);
        }
        object5 = intSet.iterator();
        while (((IntSet.IntSetIterator)object5).hasNext()) {
            int n2 = ((IntSet.IntSetIterator)object5).next();
            object4 = (FileDesc)this._files.get(n2);
            Assert.that(object4 != null, "Null entry for index value " + n2);
        }
        Iterator iterator2 = this._urnIndex.keySet().iterator();
        while (iterator2.hasNext()) {
            object4 = (URN)iterator2.next();
            object3 = (IntSet)this._urnIndex.get(object4);
            object2 = ((IntSet)object3).iterator();
            while (((IntSet.IntSetIterator)object2).hasNext()) {
                n = ((IntSet.IntSetIterator)object2).next();
                fileDesc = (FileDesc)this._files.get(n);
                Assert.that(fileDesc != null, "Missing file for urn");
                Assert.that(fileDesc.containsUrn((URN)object4), "URN mismatch");
            }
        }
        object4 = this._sharedDirectories.keySet().iterator();
        while (object4.hasNext()) {
            object3 = (File)object4.next();
            object2 = (IntSet)this._sharedDirectories.get(object3);
            IntSet.IntSetIterator intSetIterator = ((IntSet)object2).iterator();
            while (intSetIterator.hasNext()) {
                int n3 = intSetIterator.next();
                Assert.that(n3 >= 0 && n3 < this._files.size(), "Bad index " + n3 + " in directory");
                object = (FileDesc)this._files.get(n3);
                Assert.that(object != null, "Directory listing points to empty file");
            }
        }
        int n4 = 0;
        int n5 = 0;
        n = 0;
        while (n < this._files.size()) {
            if (this._files.get(n) != null) {
                fileDesc = (FileDesc)this._files.get(n);
                ++n4;
                n5 = (int)((long)n5 + fileDesc.getSize());
                Assert.that(fileDesc.getIndex() == n, "Bad index value.  Got " + fileDesc.getIndex() + " not " + n);
                Assert.that(intSet.contains(n), "Index does not contain entry for " + n);
                try {
                    object = (IntSet)this._sharedDirectories.get(FileManager.getCanonicalFile(FileManager.getParentFile(fileDesc.getFile())));
                    Assert.that(object != null, "Directory for " + fileDesc.getPath() + " isn't shared");
                    Assert.that(((IntSet)object).contains(n), "Index " + n + " not in directory");
                }
                catch (IOException iOException) {
                    Assert.that(false);
                }
                object4 = fileDesc.getUrns().iterator();
                while (object4.hasNext()) {
                    object = (URN)object4.next();
                    IntSet intSet2 = (IntSet)this._urnIndex.get(object);
                    Assert.that(intSet2 != null, "Urn not found");
                    Assert.that(intSet2.contains(fileDesc.getIndex()));
                }
            }
            ++n;
        }
        Assert.that(this._numFiles == n4, this._numFiles + " should be " + n4);
        Assert.that(this._size == (long)n5, this._size + " should be " + n5);
    }

    static {
        debugOn = false;
    }
}

