/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;

public final class ForMeReplyHandler
implements ReplyHandler {
    private final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        SettingsManager settingsManager = SettingsManager.instance();
        if (pingReply.getHops() <= 1 && replyHandler.getNumMessagesReceived() <= 2 && !replyHandler.isOutgoing() && replyHandler.isKillable() && pingReply.getFiles() < (long)settingsManager.getFreeloaderFiles() && (int)(Math.random() * 100.0) > settingsManager.getFreeloaderAllowed() && replyHandler instanceof ManagedConnection) {
            ConnectionManager connectionManager = RouterService.getConnectionManager();
            connectionManager.remove((ManagedConnection)replyHandler);
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        if (replyHandler.isPersonalSpam(queryReply)) {
            return;
        }
        ActivityCallback activityCallback = RouterService.getCallback();
        activityCallback.handleQueryReply(queryReply);
        DownloadManager downloadManager = RouterService.getDownloadManager();
        downloadManager.handleQueryReply(queryReply);
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        FileDesc fileDesc;
        Object object;
        if (replyHandler.isPersonalSpam(pushRequest)) {
            return;
        }
        byte[] byArray = pushRequest.getIP();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ByteOrder.ubyte2int(byArray[0]) + ".");
        stringBuffer.append(ByteOrder.ubyte2int(byArray[1]) + ".");
        stringBuffer.append(ByteOrder.ubyte2int(byArray[2]) + ".");
        stringBuffer.append(ByteOrder.ubyte2int(byArray[3]) + "");
        String string = stringBuffer.toString();
        int n = pushRequest.getPort();
        int n2 = (int)pushRequest.getIndex();
        String string2 = new GUID(pushRequest.getClientGUID()).toString();
        try {
            object = RouterService.getFileManager();
            fileDesc = ((FileManager)object).get(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        object = fileDesc.getName();
        if (!RouterService.getAcceptor().isBannedIP(string)) {
            RouterService.getUploadManager().acceptPushUpload((String)object, string, n, n2, string2);
        }
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public void countDroppedMessage() {
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public Set getDomains() {
        return this.EMPTY_SET;
    }

    public boolean isPersonalSpam(Message message) {
        return false;
    }

    public void updateHorizonStats(PingReply pingReply) {
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }
}

