/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Random;

public class GUID
implements Comparable {
    private static final int SZ = 16;
    private static Random rand = new Random();
    private byte[] bytes;

    public GUID(byte[] byArray) {
        Assert.that(byArray.length == 16);
        this.bytes = byArray;
    }

    private static void tagGuid(byte[] byArray, int n, int n2, int n3) {
        short s = ByteOrder.leb2short(byArray, n);
        short s2 = ByteOrder.leb2short(byArray, n2);
        short s3 = GUID.tag(s, s2);
        ByteOrder.short2leb(s3, byArray, n3);
    }

    public static byte[] makeGuid() {
        byte[] byArray = new byte[16];
        rand.nextBytes(byArray);
        byArray[8] = -1;
        byArray[15] = 0;
        GUID.tagGuid(byArray, 4, 6, 9);
        return byArray;
    }

    public static byte[] makeGuidRequery() {
        byte[] byArray = GUID.makeGuid();
        GUID.tagGuid(byArray, 0, 11, 13);
        return byArray;
    }

    static short tag(short s, short s2) {
        int n = (s + 2) * (s2 + 3);
        short s3 = (short)(n >> 8);
        return s3;
    }

    public boolean isLimeGUID() {
        return GUID.isLimeGUID(this.bytes);
    }

    public boolean isLimeRequeryGUID(int n) {
        return GUID.isLimeRequeryGUID(this.bytes, n);
    }

    public boolean isLimeRequeryGUID() {
        return GUID.isLimeRequeryGUID(this.bytes);
    }

    private static boolean checkMatching(byte[] byArray, int n, int n2, int n3) {
        short s;
        short s2 = ByteOrder.leb2short(byArray, n);
        short s3 = ByteOrder.leb2short(byArray, n2);
        short s4 = ByteOrder.leb2short(byArray, n3);
        return s4 == (s = GUID.tag(s2, s3));
    }

    public static boolean isLimeGUID(byte[] byArray) {
        return GUID.checkMatching(byArray, 4, 6, 9);
    }

    public static boolean isLimeRequeryGUID(byte[] byArray) {
        return GUID.isLimeRequeryGUID(byArray, 0) || GUID.isLimeRequeryGUID(byArray, 1) || GUID.isLimeRequeryGUID(byArray, 2);
    }

    public static boolean isLimeRequeryGUID(byte[] byArray, int n) {
        if (n == 0) {
            return GUID.checkMatching(byArray, 0, 9, 13);
        }
        if (n == 1) {
            return GUID.checkMatching(byArray, 0, 2, 13);
        }
        return GUID.checkMatching(byArray, 0, 11, 13);
    }

    public final boolean isWindowsGUID() {
        return GUID.isWindowsGUID(this.bytes);
    }

    public static boolean isWindowsGUID(byte[] byArray) {
        return (byArray[8] & 0xC0) == 128;
    }

    public final boolean isNewGUID() {
        return GUID.isNewGUID(this.bytes);
    }

    public static boolean isNewGUID(byte[] byArray) {
        return byArray[8] == -1;
    }

    public int compareTo(Object object) {
        return GUID.compare(this.bytes, ((GUID)object).bytes);
    }

    private static final int compare(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < 16) {
            int n2 = byArray[n] - byArray2[n];
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GUID)) {
            return false;
        }
        Assert.that(object != null, "Null o in GUID.equals");
        byte[] byArray = ((GUID)object).bytes();
        Assert.that(this.bytes != null, "Null bytes in GUID.equals");
        Assert.that(byArray != null, "Null bytes2 in GUID.equals");
        int n = 0;
        while (n < 16) {
            if (this.bytes[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        byte[] byArray = this.bytes;
        int n = 0xFF & byArray[0] | 0xFF00 & byArray[1] << 8 | 0xFF0000 & byArray[2] << 16 | byArray[3] << 24;
        int n2 = 0xFF & byArray[4] | 0xFF00 & byArray[5] << 8 | 0xFF0000 & byArray[6] << 16 | byArray[7] << 24;
        int n3 = 0xFF & byArray[8] | 0xFF00 & byArray[9] << 8 | 0xFF0000 & byArray[10] << 16 | byArray[11] << 24;
        int n4 = 0xFF & byArray[12] | 0xFF00 & byArray[13] << 8 | 0xFF0000 & byArray[14] << 16 | byArray[15] << 24;
        return n ^ n2 ^ n3 ^ n4;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 16) {
            int n2 = ByteOrder.ubyte2int(this.bytes[n]);
            String string = Integer.toHexString(n2);
            while (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static byte[] fromHexString(String string) throws IllegalArgumentException {
        byte[] byArray = new byte[16];
        try {
            int n = 0;
            while (n < 16) {
                byArray[n] = (byte)Integer.parseInt(string.substring(n * 2, n * 2 + 2), 16);
                ++n;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static class GUIDByteComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return GUID.compare((byte[])object, (byte[])object2);
        }
    }

    public static class GUIDComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return GUID.compare(((GUID)object).bytes, ((GUID)object2).bytes);
        }
    }
}

