/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class GroupPingRequest
extends PingRequest
implements Serializable {
    private byte[] payload;

    public GroupPingRequest(byte by, int n, byte[] byArray, long l, long l2, String string) {
        super(by, (byte)(14 + string.length() + 1));
        this.payload = new byte[14 + string.length() + 1];
        ByteOrder.short2leb((short)n, this.payload, 0);
        this.payload[2] = byArray[0];
        this.payload[3] = byArray[1];
        this.payload[4] = byArray[2];
        this.payload[5] = byArray[3];
        ByteOrder.int2leb((int)l, this.payload, 6);
        ByteOrder.int2leb((int)l2, this.payload, 10);
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, this.payload, 14, byArray2.length);
        this.payload[this.payload.length - 1] = 0;
    }

    public GroupPingRequest(byte[] byArray, byte by, byte by2, byte[] byArray2) {
        super(byArray, by, by2, (byte)byArray2.length);
        Assert.that(byArray2.length >= 15);
        this.payload = byArray2;
    }

    public void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 0));
    }

    public String getIP() {
        byte[] byArray = this.getAddress();
        String string = Message.ip2string(byArray);
        return string;
    }

    public byte[] getAddress() {
        byte[] byArray = new byte[]{this.payload[2], this.payload[3], this.payload[4], this.payload[5]};
        return byArray;
    }

    public long getFiles() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 6));
    }

    public long getKbytes() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 10));
    }

    public String getGroup() {
        return new String(this.payload, 14, this.payload.length - 15);
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (!(object instanceof GroupPingRequest)) {
            return false;
        }
        GroupPingRequest groupPingRequest = (GroupPingRequest)object;
        byte[] byArray2 = this.getAddress();
        return byArray2[0] == (byArray = groupPingRequest.getAddress())[0] && byArray2[1] == byArray[1] && byArray2[2] == byArray[2] && byArray2[3] == byArray[3] && this.getPort() == groupPingRequest.getPort();
    }

    public String toString() {
        return "GroupPingRequest(" + this.getIP() + ":" + this.getPort() + "," + this.getGroup() + ", " + super.toString() + ")";
    }
}

