/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.util.BucketQueue;
import com.limegroup.gnutella.util.FixedsizePriorityQueue;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;

public class HostCatcher {
    public static final int GWEBCACHE_DELAY = 6000;
    static final int GOOD_SIZE = 400;
    static final int NORMAL_SIZE = 1000;
    static final int BAD_SIZE = 15;
    static final int SIZE = 1415;
    static final int PERMANENT_SIZE = 1000;
    static final int GOOD_PRIORITY = 2;
    static final int NORMAL_PRIORITY = 1;
    static final int BAD_PRIORITY = 0;
    private final BucketQueue ENDPOINT_QUEUE = new BucketQueue(new int[]{15, 1000, 400});
    private final Set ENDPOINT_SET = new HashSet();
    private FixedsizePriorityQueue permanentHosts = new FixedsizePriorityQueue(ExtendedEndpoint.priorityComparator(), 1000);
    private Set permanentHostsSet = new HashSet();
    private BootstrapServerManager gWebCache = new BootstrapServerManager(this);
    private long nextAllowedFetchTime = Long.MAX_VALUE;
    private Acceptor acceptor;
    private ConnectionManager manager;
    private ActivityCallback callback;
    private SettingsManager settings = SettingsManager.instance();
    private boolean alwaysNotifyKnownHost = false;
    private final QueryUnicaster UNICASTER = QueryUnicaster.instance();
    static boolean DEBUG = false;

    public void initialize() {
        String string = this.settings.getHostList();
        try {
            if (string != null) {
                this.read(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Endpoint endpoint;
                    if (RouterService.acceptedIncomingConnection() && RouterService.isSupernode() && !(endpoint = new Endpoint(RouterService.getAddress(), RouterService.getPort())).isPrivateAddress()) {
                        HostCatcher.this.gWebCache.sendUpdatesAsync(endpoint);
                    }
                }
                catch (Throwable throwable) {
                    RouterService.error(throwable);
                }
            }
        };
        RouterService.schedule(runnable, BootstrapServerManager.UPDATE_DELAY_MSEC, BootstrapServerManager.UPDATE_DELAY_MSEC);
    }

    synchronized void read(String string) throws FileNotFoundException, IOException {
        String string2;
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            Object object;
            try {
                object = new BootstrapServer(string2);
                this.gWebCache.addBootstrapServer((BootstrapServer)object);
            }
            catch (ParseException parseException) {
                try {
                    object = ExtendedEndpoint.read(string2);
                    this.add((ExtendedEndpoint)object, HostCatcher.priority((Endpoint)object));
                }
                catch (ParseException parseException2) {}
            }
        }
    }

    synchronized void write(String string) throws IOException {
        Object object;
        Iterator iterator;
        this.repOk();
        FileWriter fileWriter = new FileWriter(string);
        BootstrapServerManager bootstrapServerManager = this.gWebCache;
        synchronized (bootstrapServerManager) {
            iterator = this.gWebCache.getBootstrapServers();
            while (iterator.hasNext()) {
                object = (BootstrapServer)iterator.next();
                fileWriter.write(((BootstrapServer)object).toString());
                fileWriter.write("\n");
            }
        }
        iterator = this.permanentHosts.iterator();
        while (iterator.hasNext()) {
            object = (ExtendedEndpoint)iterator.next();
            ((ExtendedEndpoint)object).write(fileWriter);
        }
        fileWriter.close();
    }

    public boolean add(PingReply pingReply, ReplyHandler replyHandler) {
        ExtendedEndpoint extendedEndpoint;
        boolean bl = false;
        try {
            bl = pingReply.supportsUnicast();
            extendedEndpoint = new ExtendedEndpoint(pingReply.getIP(), pingReply.getPort(), pingReply.getDailyUptime());
        }
        catch (BadPacketException badPacketException) {
            extendedEndpoint = new ExtendedEndpoint(pingReply.getIP(), pingReply.getPort());
        }
        if (bl) {
            try {
                this.UNICASTER.addUnicastEndpoint(InetAddress.getByName(pingReply.getIP()), pingReply.getPort());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (pingReply.isMarked()) {
            return this.add(extendedEndpoint, 2);
        }
        return this.add(extendedEndpoint, HostCatcher.priority(extendedEndpoint));
    }

    public boolean add(Endpoint endpoint, boolean bl) {
        ExtendedEndpoint extendedEndpoint = new ExtendedEndpoint(endpoint.getHostname(), endpoint.getPort());
        if (bl) {
            return this.add(extendedEndpoint, 2);
        }
        return this.add(extendedEndpoint, HostCatcher.priority(extendedEndpoint));
    }

    private boolean add(ExtendedEndpoint extendedEndpoint, int n) {
        this.repOk();
        if (this.isMe(extendedEndpoint.getHostname(), extendedEndpoint.getPort())) {
            return false;
        }
        if (RouterService.getAcceptor().isBannedIP(extendedEndpoint.getHostname())) {
            return false;
        }
        if (ManagedConnection.isRouter(extendedEndpoint.getHostname())) {
            return false;
        }
        this.addPermanent(extendedEndpoint);
        boolean bl = false;
        boolean bl2 = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (!this.ENDPOINT_SET.contains(extendedEndpoint)) {
                bl = true;
                this.ENDPOINT_SET.add(extendedEndpoint);
                Object object = this.ENDPOINT_QUEUE.insert(extendedEndpoint, n);
                if (object != null) {
                    this.ENDPOINT_SET.remove(object);
                }
                if (object == null) {
                    bl2 = true;
                }
                this.notify();
            }
        }
        if (this.alwaysNotifyKnownHost || bl2) {
            RouterService.getCallback().knownHost(extendedEndpoint);
        }
        this.repOk();
        return bl;
    }

    private synchronized boolean addPermanent(ExtendedEndpoint extendedEndpoint) {
        if (extendedEndpoint.isPrivateAddress()) {
            return false;
        }
        if (this.permanentHostsSet.contains(extendedEndpoint)) {
            return false;
        }
        Object object = this.permanentHosts.insert(extendedEndpoint);
        if (object != extendedEndpoint) {
            this.permanentHostsSet.add(extendedEndpoint);
            if (object != null) {
                this.permanentHostsSet.remove(object);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean removePermanent(ExtendedEndpoint extendedEndpoint) {
        boolean bl;
        boolean bl2 = this.permanentHosts.remove(extendedEndpoint);
        Assert.that(bl2 == (bl = this.permanentHostsSet.remove(extendedEndpoint)), "Queue " + bl2 + " but set " + bl);
        return bl2;
    }

    private static int priority(Endpoint endpoint) {
        return endpoint.isPrivateAddress() ? 0 : 1;
    }

    public synchronized Endpoint getAnEndpoint() throws InterruptedException {
        while (true) {
            if (this.getNumHosts() == 0) {
                this.gWebCache.fetchEndpointsAsync();
            } else if (this.getNumUltrapeerHosts() == 0) {
                long l = System.currentTimeMillis();
                if (l < this.nextAllowedFetchTime) {
                    this.nextAllowedFetchTime = Math.min(this.nextAllowedFetchTime, l + 6000L);
                } else {
                    this.gWebCache.fetchEndpointsAsync();
                    this.nextAllowedFetchTime = Long.MAX_VALUE;
                }
            }
            try {
                return this.getAnEndpointInternal();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.wait();
                continue;
            }
            break;
        }
    }

    public synchronized void doneWithConnect(Endpoint endpoint, boolean bl) {
        if (!(endpoint instanceof ExtendedEndpoint)) {
            return;
        }
        ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)endpoint;
        this.removePermanent(extendedEndpoint);
        if (bl) {
            extendedEndpoint.recordConnectionSuccess();
        } else {
            extendedEndpoint.recordConnectionFailure();
        }
        this.addPermanent(extendedEndpoint);
    }

    private ExtendedEndpoint getAnEndpointInternal() throws NoSuchElementException {
        if (!this.ENDPOINT_QUEUE.isEmpty()) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)this.ENDPOINT_QUEUE.extractMax();
            boolean bl = this.ENDPOINT_SET.remove(extendedEndpoint);
            Assert.that(bl, "Rep. invariant for HostCatcher broken.");
            return extendedEndpoint;
        }
        throw new NoSuchElementException();
    }

    public int getNumHosts() {
        return this.ENDPOINT_QUEUE.size();
    }

    public int getNumUltrapeerHosts() {
        return this.ENDPOINT_QUEUE.size(2);
    }

    int getNumNormalHosts() {
        return this.ENDPOINT_QUEUE.size(1);
    }

    int getNumPrivateHosts() {
        return this.ENDPOINT_QUEUE.size(0);
    }

    public synchronized Iterator getHosts() {
        return new BucketQueue(this.ENDPOINT_QUEUE).iterator();
    }

    Iterator getPermanentHosts() {
        return this.permanentHosts.iterator();
    }

    public synchronized Iterator getUltrapeerHosts(int n) {
        n = Math.min(n, this.ENDPOINT_QUEUE.size(2));
        ArrayList arrayList = new ArrayList(n);
        Iterator iterator = this.ENDPOINT_QUEUE.iterator(2, n);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.iterator();
    }

    public synchronized Iterator getNormalHosts(int n) {
        ArrayList arrayList = new ArrayList(n);
        Iterator iterator = this.ENDPOINT_QUEUE.iterator(1, n);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.iterator();
    }

    public synchronized void removeHost(String string, int n) {
        boolean bl;
        Endpoint endpoint = new Endpoint(string, n);
        boolean bl2 = this.ENDPOINT_SET.remove(endpoint);
        Assert.that(bl2 == (bl = this.ENDPOINT_QUEUE.removeAll(endpoint)), "Rep. invariant for HostCatcher broken.");
    }

    public synchronized void expire() {
        this.gWebCache.fetchBootstrapServersAsync();
    }

    public synchronized void clear() {
        this.ENDPOINT_QUEUE.clear();
        this.ENDPOINT_SET.clear();
    }

    private boolean isMe(String string, int n) {
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray[0] == 127) {
            return n == RouterService.getPort();
        }
        byte[] byArray2 = RouterService.getAddress();
        return Arrays.equals(byArray, byArray2) && n == RouterService.getPort();
    }

    public String toString() {
        return "[volatile:" + this.ENDPOINT_QUEUE.toString() + ", permanent:" + this.permanentHosts.toString() + "]";
    }

    public void setAlwaysNotifyKnownHost(boolean bl) {
        this.alwaysNotifyKnownHost = bl;
    }

    protected void repOk() {
        Object object;
        Object object2;
        Object object3;
        if (!DEBUG) {
            return;
        }
        Iterator iterator = this.ENDPOINT_SET.iterator();
        block0: while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = this.ENDPOINT_QUEUE.iterator();
            while (object2.hasNext()) {
                if (object3.equals(object2.next())) continue block0;
            }
            Assert.that(false, "Couldn't find " + object3 + " in queue");
        }
        object3 = this.ENDPOINT_QUEUE.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            Assert.that(object2 instanceof ExtendedEndpoint);
            Assert.that(this.ENDPOINT_SET.contains(object2));
        }
        object2 = this.permanentHosts.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            Assert.that(object instanceof ExtendedEndpoint);
            Assert.that(this.permanentHostsSet.contains(object));
        }
        object = this.permanentHostsSet.iterator();
        while (object.hasNext()) {
            Object object4 = object.next();
            Assert.that(object4 instanceof ExtendedEndpoint);
            Assert.that(this.permanentHosts.contains(object4), "Couldn't find " + object4 + " from " + this.permanentHostsSet + " in " + this.permanentHosts);
        }
    }
}

