/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.SpamFilter;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.PriorityMessageQueue;
import com.limegroup.gnutella.connection.SimpleMessageQueue;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.ClientHandshakeResponder;
import com.limegroup.gnutella.handshaking.ClientProperties;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.handshaking.SupernodeHandshakeResponder;
import com.limegroup.gnutella.handshaking.SupernodeProperties;
import com.limegroup.gnutella.routing.ManagedConnectionQueryInfo;
import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;

public class ManagedConnection
extends Connection
implements ReplyHandler {
    private static final int CONNECT_TIMEOUT = 4000;
    private static final int TOTAL_OUTGOING_MESSAGING_BANDWIDTH = 15000;
    private final MessageRouter _router;
    private final ConnectionManager _manager;
    private volatile SpamFilter _routeFilter = SpamFilter.newRouteFilter();
    private volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();
    private Object _outputQueueLock = new Object();
    private MessageQueue[] _outputQueue = new MessageQueue[7];
    private int _queued = 0;
    private boolean _runnerDied = false;
    int _lastPriority = 0;
    private static final int QUEUE_SIZE = 100;
    private static int BIG_QUEUE_TIME = 10000;
    static int QUEUE_TIME = 5000;
    private static final int PRIORITIES = 7;
    private static final int PRIORITY_WATCHDOG = 0;
    private static final int PRIORITY_PUSH = 1;
    private static final int PRIORITY_QUERY_REPLY = 2;
    private static final int PRIORITY_QUERY = 3;
    private static final int PRIORITY_PING_REPLY = 4;
    private static final int PRIORITY_PING = 5;
    private static final int PRIORITY_OTHER = 6;
    private static final BandwidthThrottle _throttle = new BandwidthThrottle(15000.0f);
    private static final int REJECT_TIMEOUT = 500;
    private int _numMessagesSent;
    private int _numMessagesReceived;
    private int _numReceivedMessagesDropped;
    private int _numSentMessagesDropped;
    private int _lastReceived;
    private int _lastRecvDropped;
    private int _lastSent;
    private int _lastSentDropped;
    private boolean _horizonEnabled = true;
    static long HORIZON_UPDATE_TIME = 600000L;
    private long _lastRefreshHorizonTime = System.currentTimeMillis();
    private boolean _refreshedHorizonStats = false;
    private static final int MAX_PING_REPLIES = 4000;
    private Set _pingReplies = new HashSet();
    private long _totalHorizonFileSize = 0L;
    private long _numHorizonFiles = 0L;
    private long _numHorizonHosts = 0L;
    private long _nextTotalHorizonFileSize = 0L;
    private long _nextNumHorizonFiles = 0L;
    private long _nextNumHorizonHosts = 0L;
    private volatile ManagedConnectionQueryInfo queryInfo = null;
    private long _nextQRPForwardTime;
    private volatile long _bytesSent;
    private BandwidthTrackerImpl _upBandwidthTracker = new BandwidthTrackerImpl();
    private volatile long _bytesReceived;
    private BandwidthTrackerImpl _downBandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isRouter = false;
    private boolean _isKillable = true;
    private Boolean _isSupernodeClientConnection = null;
    private Boolean _isClientSupernodeConnection = null;
    private Boolean _supportsGGEP = null;
    private Set _domains = null;
    private final SettingsManager SETTINGS = SettingsManager.instance();

    ManagedConnection(String string, int n, MessageRouter messageRouter, ConnectionManager connectionManager) {
        this(ManagedConnection.translateHost(string), n, messageRouter, connectionManager, ManagedConnection.isRouter(string));
    }

    private ManagedConnection(String string, int n, MessageRouter messageRouter, ConnectionManager connectionManager, boolean bl) {
        super(string, n, bl ? null : (connectionManager.isSupernode() ? new SupernodeProperties(string) : new ClientProperties(string)), bl ? null : (connectionManager.isSupernode() ? new SupernodeHandshakeResponder(connectionManager, string) : new ClientHandshakeResponder(connectionManager, string)), !bl);
        this._router = messageRouter;
        this._manager = connectionManager;
        this._isRouter = bl;
    }

    ManagedConnection(Socket socket, MessageRouter messageRouter, ConnectionManager connectionManager) {
        super(socket, connectionManager.isSupernode() ? new SupernodeHandshakeResponder(connectionManager, socket.getInetAddress().getHostAddress()) : new ClientHandshakeResponder(connectionManager, socket.getInetAddress().getHostAddress()));
        this._router = messageRouter;
        this._manager = connectionManager;
    }

    public void initialize() throws IOException, NoGnutellaOkException, BadHandshakeException {
        if (this._isRouter) {
            super.initialize();
        } else {
            super.initialize(4000);
        }
        this._outputQueue[0] = new SimpleMessageQueue(1, Integer.MAX_VALUE, 100, true);
        this._outputQueue[1] = new PriorityMessageQueue(3, BIG_QUEUE_TIME, 100);
        this._outputQueue[2] = new PriorityMessageQueue(2, BIG_QUEUE_TIME, 100);
        this._outputQueue[3] = new PriorityMessageQueue(1, QUEUE_TIME, 100);
        this._outputQueue[4] = new PriorityMessageQueue(1, QUEUE_TIME, 100);
        this._outputQueue[5] = new PriorityMessageQueue(1, QUEUE_TIME, 100);
        this._outputQueue[6] = new SimpleMessageQueue(1, Integer.MAX_VALUE, 100, false);
        new OutputRunner();
        UpdateManager updateManager = UpdateManager.instance();
        updateManager.checkAndUpdate(this);
    }

    protected OutputStream getOutputStream(Socket socket) throws IOException {
        return new ThrottledOutputStream(super.getOutputStream(socket), _throttle);
    }

    protected InputStream getInputStream(Socket socket) throws IOException {
        return super.getInputStream(socket);
    }

    public Message receive() throws IOException, BadPacketException {
        Message message = null;
        try {
            message = super.receive();
            this._bytesReceived += (long)message.getTotalLength();
        }
        catch (IOException iOException) {
            if (this._manager != null) {
                this._manager.remove(this);
            }
            throw iOException;
        }
        ++this._numMessagesReceived;
        return message;
    }

    public Message receive(int n) throws IOException, BadPacketException, InterruptedIOException {
        Message message = null;
        try {
            message = super.receive(n);
            this._bytesReceived += (long)message.getTotalLength();
        }
        catch (IOException iOException) {
            if (this._manager != null) {
                this._manager.remove(this);
            }
            throw iOException;
        }
        ++this._numMessagesReceived;
        return message;
    }

    public void send(Message message) {
        if (!this.supportsGGEP()) {
            message = message.stripExtendedPayload();
        }
        this.repOk();
        Assert.that(this._outputQueue != null, "Connection not initialized");
        int n = this.calculatePriority(message);
        Object object = this._outputQueueLock;
        synchronized (object) {
            ++this._numMessagesSent;
            this._outputQueue[n].add(message);
            int n2 = this._outputQueue[n].resetDropped();
            this.addDropped(n2);
            this._queued += 1 - n2;
            this._lastPriority = n;
            this._outputQueueLock.notify();
        }
        this.repOk();
    }

    private void addDropped(int n) {
        this._numSentMessagesDropped += n;
    }

    private int calculatePriority(Message message) {
        byte by = message.getFunc();
        boolean bl = message.getHops() == 0 && message.getTTL() <= 2;
        switch (by) {
            case -128: {
                return 3;
            }
            case -127: {
                return 2;
            }
            case 1: {
                return bl ? 0 : 4;
            }
            case 0: {
                return bl ? 0 : 5;
            }
            case 64: {
                return 1;
            }
        }
        return 6;
    }

    public void flush() throws IOException {
    }

    private void dumpQueueStats() {
        Object object = this._outputQueueLock;
        synchronized (object) {
            int n = 0;
            while (n < 7) {
                System.out.println(n + " " + this._outputQueue[n].size());
                ++n;
            }
            System.out.println("* " + this._queued + "\n");
        }
    }

    public void close() {
        Object object = this._outputQueueLock;
        synchronized (object) {
            super.close();
            this._outputQueueLock.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loopToReject(HostCatcher hostCatcher) {
        block14: {
            block13: {
                try {
                    try {
                        int n = 0;
                        while (n < 10) {
                            Message message = null;
                            try {
                                message = super.receive(500);
                                if (message == null) {
                                    Object var8_5 = null;
                                    this.close();
                                    return;
                                }
                            }
                            catch (BadPacketException badPacketException) {
                                Object var8_6 = null;
                                this.close();
                                return;
                            }
                            if (message instanceof PingRequest && message.getHops() == 0) {
                                if (message.getTTL() == 2) {
                                    this.handleCrawlerPing((PingRequest)message);
                                    break block13;
                                } else {
                                    Iterator iterator = hostCatcher.getNormalHosts(10);
                                    while (true) {
                                        if (!iterator.hasNext()) break;
                                        Endpoint endpoint = (Endpoint)iterator.next();
                                        PingReply pingReply = new PingReply(message.getGUID(), 1, endpoint.getPort(), endpoint.getHostBytes(), 0L, 0L);
                                        super.send(pingReply);
                                    }
                                    super.flush();
                                    Object var8_8 = null;
                                    this.close();
                                    return;
                                }
                            }
                            ++n;
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        Object var8_10 = null;
                        this.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    this.close();
                    throw throwable;
                }
            }
            Object var8_7 = null;
            this.close();
            return;
        }
        Object var8_9 = null;
        this.close();
    }

    private void handleCrawlerPing(PingRequest pingRequest) throws IOException {
        List list = this._manager.getInitializedConnections2();
        this.supersendNeighborPongs(pingRequest, list);
        List list2 = this._manager.getInitializedClientConnections2();
        this.supersendNeighborPongs(pingRequest, list2);
    }

    private void supersendNeighborPongs(PingRequest pingRequest, List list) throws IOException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            PingReply pingReply = managedConnection.isSupernodeConnection() ? new PingReply(pingRequest.getGUID(), 2, managedConnection.getOrigPort(), managedConnection.getInetAddress().getAddress(), 0L, 0L, true) : (managedConnection.isClientConnection() || managedConnection.isOutgoing() ? new PingReply(pingRequest.getGUID(), 2, managedConnection.getOrigPort(), managedConnection.getInetAddress().getAddress(), 0L, 0L) : new PingReply(pingRequest.getGUID(), 2, 0, managedConnection.getInetAddress().getAddress(), 0L, 0L));
            pingReply.hop();
            super.send(pingReply);
        }
        super.flush();
    }

    void loopForMessages() throws IOException {
        while (true) {
            Message message = null;
            try {
                message = this.receive();
                if (message == null) {
                }
            }
            catch (BadPacketException badPacketException) {}
            continue;
            if (!this._routeFilter.allow(message)) {
                if (!CommonUtils.isJava118()) {
                    ReceivedMessageStatHandler.TCP_FILTERED_MESSAGES.addMessage(message);
                }
                ++this._numReceivedMessagesDropped;
                continue;
            }
            this._router.handleMessage(message, this);
        }
    }

    public void countDroppedMessage() {
        ++this._numReceivedMessagesDropped;
    }

    public boolean isPersonalSpam(Message message) {
        return !this._personalFilter.allow(message);
    }

    public void setRouteFilter(SpamFilter spamFilter) {
        this._routeFilter = spamFilter;
    }

    public void setPersonalFilter(SpamFilter spamFilter) {
        this._personalFilter = spamFilter;
    }

    public Set getDomains() {
        if (this._domains == null) {
            this._domains = this.createDomainSet();
        }
        return this._domains;
    }

    private Set createDomainSet() {
        String string = this.isOutgoing() ? this.getProperty("X-Domains-Authenticated") : this.getPropertyWritten("X-Domains-Authenticated");
        Set set = string == null ? User.createDefaultDomainSet() : StringUtils.getSetofValues(string);
        return set;
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        this.send(pingReply);
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        this.send(queryReply);
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        this.send(pushRequest);
    }

    public long getBytesSent() {
        return this._bytesSent;
    }

    public long getBytesReceived() {
        return this._bytesReceived;
    }

    public int getNumMessagesSent() {
        return this._numMessagesSent;
    }

    public int getNumMessagesReceived() {
        return this._numMessagesReceived;
    }

    public int getNumSentMessagesDropped() {
        return this._numSentMessagesDropped;
    }

    public long getNumReceivedMessagesDropped() {
        return this._numReceivedMessagesDropped;
    }

    public synchronized float getPercentReceivedDropped() {
        int n = this._numMessagesReceived - this._lastReceived;
        int n2 = this._numReceivedMessagesDropped - this._lastRecvDropped;
        float f = n == 0 ? 0.0f : (float)n2 / (float)n * 100.0f;
        this._lastReceived = this._numMessagesReceived;
        this._lastRecvDropped = this._numReceivedMessagesDropped;
        return f;
    }

    public synchronized float getPercentSentDropped() {
        int n = this._numMessagesSent - this._lastSent;
        int n2 = this._numSentMessagesDropped - this._lastSentDropped;
        float f = n == 0 ? 0.0f : (float)n2 / (float)n * 100.0f;
        this._lastSent = this._numMessagesSent;
        this._lastSentDropped = this._numSentMessagesDropped;
        return f;
    }

    public void measureBandwidth() {
        this._upBandwidthTracker.measureBandwidth(ByteOrder.long2int(this._bytesSent));
        this._downBandwidthTracker.measureBandwidth(ByteOrder.long2int(this._bytesReceived));
    }

    public float getMeasuredUpstreamBandwidth() {
        float f = 0.0f;
        try {
            f = this._upBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
        return f;
    }

    public float getMeasuredDownstreamBandwidth() {
        float f = 0.0f;
        try {
            f = this._downBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
        return f;
    }

    public synchronized void setHorizonEnabled(boolean bl) {
        this._horizonEnabled = bl;
    }

    public synchronized void updateHorizonStats(PingReply pingReply) {
        if (!this._horizonEnabled) {
            return;
        }
        Endpoint endpoint = new Endpoint(pingReply.getIP(), pingReply.getPort());
        if (this._pingReplies.size() < 4000 && this._pingReplies.add(endpoint)) {
            this._nextTotalHorizonFileSize += pingReply.getKbytes();
            this._nextNumHorizonFiles += pingReply.getFiles();
            ++this._nextNumHorizonHosts;
        }
    }

    public synchronized void refreshHorizonStats() {
        long l = System.currentTimeMillis();
        long l2 = l - this._lastRefreshHorizonTime;
        if (l2 < HORIZON_UPDATE_TIME) {
            return;
        }
        this._lastRefreshHorizonTime = l;
        this._numHorizonHosts = this._nextNumHorizonHosts;
        this._numHorizonFiles = this._nextNumHorizonFiles;
        this._totalHorizonFileSize = this._nextTotalHorizonFileSize;
        this._nextNumHorizonHosts = 0L;
        this._nextNumHorizonFiles = 0L;
        this._nextTotalHorizonFileSize = 0L;
        this._pingReplies.clear();
        this._refreshedHorizonStats = true;
    }

    public synchronized long getNumHosts() {
        if (this._refreshedHorizonStats) {
            return this._numHorizonHosts;
        }
        return this._nextNumHorizonHosts;
    }

    public synchronized long getNumFiles() {
        if (this._refreshedHorizonStats) {
            return this._numHorizonFiles;
        }
        return this._nextNumHorizonFiles;
    }

    public synchronized long getTotalFileSize() {
        if (this._refreshedHorizonStats) {
            return this._totalHorizonFileSize;
        }
        return this._nextTotalHorizonFileSize;
    }

    public String getUserAgent() {
        return this.getProperty("User-Agent");
    }

    public boolean isRouterConnection() {
        return this._isRouter;
    }

    public boolean isClientConnection() {
        String string = this.getProperty("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string) == false;
    }

    public boolean isSupernodeConnection() {
        String string = this.getProperty("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isClientSupernodeConnection() {
        if (this._isClientSupernodeConnection == null) {
            this._isClientSupernodeConnection = new Boolean(this.isClientSupernodeConnection2());
        }
        return this._isClientSupernodeConnection;
    }

    private boolean isClientSupernodeConnection2() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string) == false;
    }

    public boolean isGUESSUltrapeer() {
        int n = this.getGUESSVersion();
        if (n == -1) {
            return false;
        }
        return n < 20 && n > 0;
    }

    public int getGUESSVersion() {
        String string = super.getProperty("X-Guess");
        if (string == null) {
            return -1;
        }
        float f = Float.valueOf(string).floatValue();
        return (int)(f *= 10.0f);
    }

    public boolean isTempConnection() {
        String string = this.getProperty("X-Temp-Connection");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isSupernodeClientConnection() {
        if (this._isSupernodeClientConnection == null) {
            this._isSupernodeClientConnection = new Boolean(this.isSupernodeClientConnection2());
        }
        return this._isSupernodeClientConnection;
    }

    private boolean isSupernodeClientConnection2() {
        if (!this.isClientConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        if (!Boolean.valueOf(string).booleanValue()) {
            return false;
        }
        return this.isQueryRoutingEnabled();
    }

    public boolean supportsGGEP() {
        if (this._supportsGGEP == null) {
            this._supportsGGEP = new Boolean(this.supportsGGEP2());
        }
        return this._supportsGGEP;
    }

    private boolean supportsGGEP2() {
        String string = this.getProperty("GGEP");
        return string != null;
    }

    boolean isQueryRoutingEnabled() {
        String string = this.getProperty("X-Query-Routing");
        if (string == null) {
            return false;
        }
        try {
            Float f = new Float(string);
            return f.floatValue() >= 0.1f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public long getNextQRPForwardTime() {
        return this._nextQRPForwardTime;
    }

    public void setNextQRPForwardTime(long l) {
        this._nextQRPForwardTime = l;
    }

    public void setKillable(boolean bl) {
        this._isKillable = bl;
    }

    public boolean isKillable() {
        return this._isKillable;
    }

    public ManagedConnectionQueryInfo getQueryRouteState() {
        return this.queryInfo;
    }

    void setQueryRouteState(ManagedConnectionQueryInfo managedConnectionQueryInfo) {
        this.queryInfo = managedConnectionQueryInfo;
    }

    static String translateHost(String string) {
        if (string.equals("router.limewire.com")) {
            return SettingsManager.DEDICATED_LIMEWIRE_ROUTER;
        }
        return string;
    }

    public static boolean isRouter(String string) {
        if (string.startsWith("router") && string.endsWith("limewire.com")) {
            return true;
        }
        return string.startsWith("64.61.25") && (string.endsWith("171") || string.endsWith("139") || string.endsWith("140") || string.endsWith("141") || string.endsWith("142") || string.endsWith("143"));
    }

    private final void repOk() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void stopOutputRunner() {
        Object object = this._outputQueueLock;
        synchronized (object) {
            this._closed = true;
            this._outputQueueLock.notify();
        }
        while (!this._runnerDied) {
            Thread.yield();
        }
        this._runnerDied = false;
        this._closed = false;
    }

    void startOutputRunner() {
        new OutputRunner();
    }

    boolean runnerDied() {
        return this._runnerDied;
    }

    private class OutputRunner
    extends Thread {
        public OutputRunner() {
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                while (true) {
                    ManagedConnection.this.repOk();
                    try {
                        this.waitForQueued();
                        this.sendQueued();
                    }
                    catch (IOException iOException) {
                        if (ManagedConnection.this._manager != null) {
                            ManagedConnection.this._manager.remove(ManagedConnection.this);
                        }
                        ManagedConnection.this._runnerDied = true;
                        return;
                    }
                    ManagedConnection.this.repOk();
                }
            }
            catch (Throwable throwable) {
                RouterService.error(throwable);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private final void waitForQueued() throws IOException {
            Object object = ManagedConnection.this._outputQueueLock;
            // MONITORENTER : object
            while (ManagedConnection.this.isOpen() && ManagedConnection.this._queued == 0) {
                try {
                    ManagedConnection.this._outputQueueLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Assert.that(false, "OutputRunner Interrupted");
                }
            }
            // MONITOREXIT : object
            if (ManagedConnection.this.isOpen()) return;
            throw new IOException();
        }

        private final void sendQueued() throws IOException {
            boolean bl;
            int n;
            int n2 = n = ManagedConnection.this._lastPriority;
            block3: do {
                MessageQueue messageQueue = ManagedConnection.this._outputQueue[n2];
                messageQueue.resetCycle();
                bl = false;
                while (true) {
                    Message message = null;
                    Object object = ManagedConnection.this._outputQueueLock;
                    synchronized (object) {
                        message = messageQueue.removeNext();
                        int n3 = messageQueue.resetDropped();
                        ManagedConnection.this.addDropped(n3);
                        ManagedConnection.this._queued -= (message == null ? 0 : 1) + n3;
                        if (ManagedConnection.this._queued == 0) {
                            bl = true;
                        }
                        if (message == null) {
                            continue block3;
                        }
                    }
                    ManagedConnection.super.send(message);
                    ManagedConnection.this._bytesSent += message.getTotalLength();
                }
            } while (!bl && (n2 = (n2 + 1) % 7) != n);
            ManagedConnection.super.flush();
        }
    }
}

