/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.Serializable;

public class MediaType
implements Serializable {
    static final long serialVersionUID = 3999062781289258389L;
    private String schema;
    private String description;
    private String[] extensions;
    private static final String SCHEMA_ANY_TYPE = "*";
    private static final String SCHEMA_DOCUMENTS = "text";
    private static final String SCHEMA_PROGRAMS = "application";
    private static final String SCHEMA_AUDIO = "audio";
    private static final String SCHEMA_VIDEO = "video";
    private static final String SCHEMA_IMAGES = "image";
    private static final String ANY_TYPE = "MEDIA_ANY_TYPE";
    private static final String DOCUMENTS = "MEDIA_DOCUMENTS";
    private static final String PROGRAMS = "MEDIA_PROGRAMS";
    private static final String AUDIO = "MEDIA_AUDIO";
    private static final String VIDEO = "MEDIA_VIDEO";
    private static final String IMAGES = "MEDIA_IMAGES";
    private static MediaType[] allMediaTypes = null;

    public MediaType(String string, String string2, String[] stringArray) {
        this.schema = string;
        this.description = string2;
        this.extensions = stringArray;
    }

    public boolean matches(String string) {
        if (this.extensions == null) {
            return true;
        }
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length()) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        int n2 = 0;
        while (n2 < this.extensions.length) {
            if (string2.equals(this.extensions[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return this.schema;
    }

    public String getDescription() {
        return this.description;
    }

    public static final MediaType[] getDefaultMediaTypes() {
        if (allMediaTypes == null) {
            allMediaTypes = MediaType.getTypes();
        }
        return allMediaTypes;
    }

    public static boolean isDefaultType(String string) {
        MediaType[] mediaTypeArray = MediaType.getDefaultMediaTypes();
        int n = mediaTypeArray.length;
        while (--n >= 0) {
            if (!string.equals(mediaTypeArray[n].schema)) continue;
            return true;
        }
        return false;
    }

    public static MediaType getAudioMediaType() {
        return MediaType.getDefaultMediaTypes()[3];
    }

    public static MediaType getVideoMediaType() {
        return MediaType.getDefaultMediaTypes()[4];
    }

    private static MediaType[] getTypes() {
        MediaType mediaType = new MediaType(SCHEMA_ANY_TYPE, ANY_TYPE, null);
        MediaType mediaType2 = new MediaType(SCHEMA_DOCUMENTS, DOCUMENTS, new String[]{"html", "htm", "xhtml", "mht", "mhtml", "xml", "txt", "ans", "asc", "diz", "eml", "pdf", "ps", "eps", "epsf", "rtf", "wri", "doc", "mcw", "wps", "xls", "wk1", "dif", "csv", "ppt", "hlp", "chm", "tex", "texi", "latex", "info", "man"});
        MediaType mediaType3 = new MediaType(SCHEMA_PROGRAMS, PROGRAMS, new String[]{"exe", "bin", "mdb", "sh", "csh", "awk", "pl", "zip", "jar", "arj", "rar", "ace", "lzh", "lha", "cab", "rpm", "deb", "msi", "msp", "gz", "gzip", "z", "bz2", "zoo", "tar", "tgz", "taz", "shar", "hqx", "sit", "dmg", "7z"});
        MediaType mediaType4 = new MediaType(SCHEMA_AUDIO, AUDIO, new String[]{"mp3", "mpa", "mp1", "mpga", "ra", "rm", "ram", "rmj", "wma", "wav", "lqt", "ogg", "med", "aif", "aiff", "aifc", "au", "snd", "iso", "mid", "midi", "rmi", "mod"});
        MediaType mediaType5 = new MediaType(SCHEMA_VIDEO, VIDEO, new String[]{"mpg", "mpeg", "mpe", "mng", "mpv", "m1v", "vob", "mp2", "mpv2", "mp2v", "m2p", "m2v", "vcd", "mp4", "dv", "dvd", "div", "divx", "dvx", "smi", "smil", "rm", "ram", "rv", "avi", "asf", "wmv", "qt", "mov", "fli", "flc", "flx", "wml", "vrml", "swf", "dcr", "jve", "nsv"});
        MediaType mediaType6 = new MediaType(SCHEMA_IMAGES, IMAGES, new String[]{"gif", "png", "jpg", "jpeg", "jpe", "jif", "jiff", "jfif", "tif", "tiff", "iff", "lbm", "ilbm", "mac", "drw", "pct", "img", "bmp", "dib", "rle", "ico", "ani", "icl", "cur", "emf", "wmf", "pcx", "pcd", "tga", "pic", "psd", "wpg", "dcx", "cpt", "mic", "pbm", "pnm", "ppm", "xbm", "xpm", "xwd", "sgi", "fax", "rgb", "ras"});
        return new MediaType[]{mediaType, mediaType2, mediaType3, mediaType4, mediaType5, mediaType6};
    }
}

