/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.routing.ManagedConnectionQueryInfo;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.statistics.RouteErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Utilities;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class MessageRouter {
    protected ConnectionManager _manager;
    protected byte[] _clientGUID;
    private ReplyHandler _forMeReplyHandler;
    private Object queryUpdateLock = new Object();
    private long nextQueryUpdateTime = 0L;
    private long QUERY_ROUTE_UPDATE_TIME = 300000L;
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    public static final int MAX_REPLY_ROUTE_BYTES = 50000;
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    protected final QueryUnicaster UNICASTER = QueryUnicaster.instance();
    private final boolean RECORD_STATS = !CommonUtils.isJava118();

    protected MessageRouter() {
        try {
            this._clientGUID = new GUID(GUID.fromHexString(SettingsManager.instance().getClientID())).bytes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._clientGUID = Message.makeGuid();
        }
    }

    public void initialize() {
        this._manager = RouterService.getConnectionManager();
        this._forMeReplyHandler = new ForMeReplyHandler();
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ManagedConnection managedConnection) {
        this._pingRouteTable.removeReplyHandler(managedConnection);
        this._queryRouteTable.removeReplyHandler(managedConnection);
        this._pushRouteTable.removeReplyHandler(managedConnection);
    }

    public void handleMessage(Message message, ManagedConnection managedConnection) {
        message.hop();
        if (message instanceof PingRequest) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PING_REQUESTS.addMessage(message);
            }
            this.handlePingRequestPossibleDuplicate((PingRequest)message, managedConnection);
        } else if (message instanceof PingReply) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PING_REPLIES.addMessage(message);
            }
            this.handlePingReply((PingReply)message, managedConnection);
        } else if (message instanceof QueryRequest) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(message);
            }
            this.handleQueryRequestPossibleDuplicate((QueryRequest)message, managedConnection);
        } else if (message instanceof QueryReply) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_QUERY_REPLIES.addMessage(message);
            }
            this.handleQueryReply((QueryReply)message, managedConnection);
        } else if (message instanceof PushRequest) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(message);
            }
            this.handlePushRequest((PushRequest)message, managedConnection);
        } else if (message instanceof RouteTableMessage) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_ROUTE_TABLE_MESSAGES.addMessage(message);
            }
            this.handleRouteTableMessage((RouteTableMessage)message, managedConnection);
        }
        this.forwardQueryRouteTables();
    }

    public void handleUDPMessage(Message message, DatagramPacket datagramPacket) {
        message.hop();
        InetAddress inetAddress = datagramPacket.getAddress();
        int n = datagramPacket.getPort();
        UDPReplyHandler uDPReplyHandler = new UDPReplyHandler(inetAddress, n);
        if (message instanceof QueryRequest) {
            this.sendAcknowledgement(datagramPacket, message.getGUID());
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(message);
            }
            this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, uDPReplyHandler);
        } else if (message instanceof QueryReply) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(message);
            }
            this.handleQueryReply((QueryReply)message, uDPReplyHandler);
        } else if (message instanceof PingRequest) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PING_REQUESTS.addMessage(message);
            }
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, uDPReplyHandler);
        } else if (message instanceof PingReply) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(message);
            }
            this.handleUDPPingReply((PingReply)message, uDPReplyHandler, inetAddress, n);
        } else if (message instanceof PushRequest) {
            if (this.RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(message);
            }
            this.handlePushRequest((PushRequest)message, uDPReplyHandler);
        }
    }

    private void sendAcknowledgement(DatagramPacket datagramPacket, byte[] byArray) {
        PingReply pingReply;
        ConnectionManager connectionManager = RouterService.getConnectionManager();
        Endpoint endpoint = connectionManager.getConnectedGUESSUltrapeer();
        if (endpoint != null) {
            try {
                pingReply = new PingReply(byArray, 1, endpoint.getPort(), endpoint.getHostBytes(), 0L, 0L, true);
            }
            catch (UnknownHostException unknownHostException) {
                pingReply = this.createPingReply(byArray);
            }
        } else {
            pingReply = this.createPingReply(byArray);
        }
        UDPService.instance().send(pingReply, datagramPacket.getAddress(), datagramPacket.getPort());
        if (this.RECORD_STATS) {
            SentMessageStatHandler.UDP_PING_REPLIES.addMessage(pingReply);
        }
    }

    private PingReply createPingReply(byte[] byArray) {
        GUESSEndpoint gUESSEndpoint = this.UNICASTER.getUnicastEndpoint();
        if (gUESSEndpoint == null) {
            return new PingReply(byArray, 1, RouterService.getPort(), RouterService.getAddress(), (long)RouterService.getNumSharedFiles(), (long)(RouterService.getSharedFileSize() / 1024), RouterService.isSupernode(), Statistics.instance().calculateDailyUptime());
        }
        return new PingReply(byArray, 1, gUESSEndpoint.getPort(), gUESSEndpoint.getAddress().getAddress(), 0L, 0L, true, 0);
    }

    final void handlePingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler)) {
            this.handlePingRequest(pingRequest, replyHandler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler)) {
            this.handleUDPPingRequest(pingRequest, replyHandler);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), managedConnection)) {
            if (managedConnection.getNumMessagesReceived() <= 2 && queryRequest.getHops() <= 1 && queryRequest.getQuery().equals("    ")) {
                managedConnection.setKillable(false);
            }
            this.handleQueryRequest(queryRequest, managedConnection);
        } else if (this.RECORD_STATS) {
            ReceivedMessageStatHandler.TCP_DUPLICATE_QUERIES.addMessage(queryRequest);
        }
    }

    final void handleUDPQueryRequestPossibleDuplicate(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), replyHandler)) {
            this.handleQueryRequest(queryRequest, replyHandler);
        } else if (this.RECORD_STATS) {
            ReceivedMessageStatHandler.UDP_DUPLICATE_QUERIES.addMessage(queryRequest);
        }
    }

    protected void handlePingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (pingRequest.getTTL() > 0) {
            this.broadcastPingRequest(pingRequest, replyHandler, this._manager);
        }
        this.respondToPingRequest(pingRequest);
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        this.respondToUDPPingRequest(pingRequest);
    }

    protected void handleUDPPingReply(PingReply pingReply, ReplyHandler replyHandler, InetAddress inetAddress, int n) {
        if (pingReply.getPort() != n || !pingReply.getIP().equals(inetAddress.getHostAddress())) {
            this.UNICASTER.addUnicastEndpoint(inetAddress, n);
        }
        Iterator iterator = this._manager.getConnectedGUESSUltrapeers().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.handlePingReply(pingReply, replyHandler);
        }
        this.handlePingReply(pingReply, replyHandler);
    }

    protected void handleQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (queryRequest.getTTL() > 0) {
            this.broadcastQueryRequest(queryRequest, replyHandler);
        }
        this.forwardQueryRequestToLeaves(queryRequest, replyHandler);
        this.respondToQueryRequest(queryRequest, this._clientGUID);
    }

    public void sendPingRequest(PingRequest pingRequest, ManagedConnection managedConnection) {
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this._forMeReplyHandler);
        managedConnection.send(pingRequest);
    }

    public void sendQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection) {
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this._forMeReplyHandler);
        managedConnection.send(queryRequest);
    }

    public void broadcastPingRequest(PingRequest pingRequest) {
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this._forMeReplyHandler);
        this.broadcastPingRequest(pingRequest, null, this._manager);
    }

    public void broadcastQueryRequest(QueryRequest queryRequest) {
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this._forMeReplyHandler);
        this.broadcastQueryRequest(queryRequest, null);
    }

    protected void broadcastPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, ConnectionManager connectionManager) {
        List list = connectionManager.getInitializedConnections2();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (replyHandler == null || managedConnection != replyHandler && !managedConnection.isClientSupernodeConnection()) {
                managedConnection.send(pingRequest);
            }
            ++n;
        }
    }

    protected void forwardQueryRequestToLeaves(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (!RouterService.isSupernode()) {
            return;
        }
        List list = this._manager.getInitializedClientConnections2();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (managedConnection != replyHandler) {
                ManagedConnectionQueryInfo managedConnectionQueryInfo = managedConnection.getQueryRouteState();
                if (managedConnectionQueryInfo == null || managedConnectionQueryInfo.lastReceived == null) {
                    return;
                }
                if (managedConnectionQueryInfo.lastReceived.contains(queryRequest)) {
                    this.sendQueryRequest(queryRequest, managedConnection, replyHandler);
                }
            }
            ++n;
        }
    }

    protected void broadcastQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List list = this._manager.getInitializedConnections2();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (replyHandler == null || managedConnection != replyHandler && !managedConnection.isClientSupernodeConnection()) {
                this.sendQueryRequest(queryRequest, managedConnection, replyHandler);
            }
            ++n;
        }
    }

    protected void sendQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection, ReplyHandler replyHandler) {
        if (replyHandler == null || MessageRouter.containsDefaultUnauthenticatedDomainOnly(managedConnection.getDomains()) || Utilities.hasIntersection(replyHandler.getDomains(), managedConnection.getDomains())) {
            managedConnection.send(queryRequest);
        }
    }

    private static boolean containsDefaultUnauthenticatedDomainOnly(Set set) {
        return set.size() == 1 && set.contains("__DEFAULT_UNAUTHENTICATED_DOMAIN__");
    }

    protected abstract void respondToPingRequest(PingRequest var1);

    protected abstract void respondToUDPPingRequest(PingRequest var1);

    protected abstract void respondToQueryRequest(QueryRequest var1, byte[] var2);

    protected void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        boolean bl = RouterService.getHostCatcher().add(pingReply, replyHandler);
        ReplyHandler replyHandler2 = this._pingRouteTable.getReplyHandler(pingReply.getGUID());
        if (replyHandler2 != null) {
            replyHandler2.handlePingReply(pingReply, replyHandler);
        } else {
            if (this.RECORD_STATS) {
                RouteErrorStat.PING_REPLY_ROUTE_ERRORS.incrementStat();
            }
            replyHandler.countDroppedMessage();
        }
        boolean bl2 = false;
        try {
            bl2 = pingReply.supportsUnicast();
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        if (bl && pingReply.isMarked() || bl2) {
            List list = this._manager.getInitializedClientConnections2();
            int n = 0;
            while (n < list.size()) {
                ManagedConnection managedConnection = (ManagedConnection)list.get(n);
                if (managedConnection != replyHandler && managedConnection != replyHandler2) {
                    managedConnection.handlePingReply(pingReply, replyHandler);
                }
                ++n;
            }
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength());
        if (replyRoutePair != null) {
            queryReply.setPriority(replyRoutePair.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), replyHandler);
            if (!MessageRouter.shouldDropReply(replyRoutePair.getBytesRouted(), queryReply.getTTL()) || replyRoutePair.getReplyHandler() == this._forMeReplyHandler) {
                replyRoutePair.getReplyHandler().handleQueryReply(queryReply, replyHandler);
                this.UNICASTER.handleQueryReply(queryReply);
            } else {
                if (this.RECORD_STATS) {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
                }
                replyHandler.countDroppedMessage();
            }
        } else {
            if (this.RECORD_STATS) {
                RouteErrorStat.NO_ROUTE_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
            }
            replyHandler.countDroppedMessage();
        }
    }

    private static boolean shouldDropReply(int n, int n2) {
        if (n2 > 3 && n < 51200) {
            return false;
        }
        if (n2 == 0 && n < 51200) {
            return false;
        }
        if (n2 == 1 && n < 1024000) {
            return false;
        }
        if (n2 == 2 && n < 340992) {
            return false;
        }
        return n2 != 3 || n >= 113664;
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        ReplyHandler replyHandler2 = this._pushRouteTable.getReplyHandler(pushRequest.getClientGUID());
        if (replyHandler2 != null) {
            replyHandler2.handlePushRequest(pushRequest, replyHandler);
        } else {
            if (this.RECORD_STATS) {
                RouteErrorStat.PUSH_REQUEST_ROUTE_ERRORS.incrementStat();
            }
            replyHandler.countDroppedMessage();
        }
    }

    public void sendPingReply(PingReply pingReply) throws IOException {
        ReplyHandler replyHandler = this._pingRouteTable.getReplyHandler(pingReply.getGUID());
        if (replyHandler == null) {
            throw new IOException();
        }
        replyHandler.handlePingReply(pingReply, null);
    }

    public void sendQueryReply(QueryReply queryReply) throws IOException {
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength());
        if (replyRoutePair == null) {
            throw new IOException();
        }
        queryReply.setPriority(replyRoutePair.getBytesRouted());
        this._pushRouteTable.routeReply(queryReply.getClientGUID(), this._forMeReplyHandler);
        replyRoutePair.getReplyHandler().handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest pushRequest) throws IOException {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(pushRequest.getClientGUID());
        if (replyHandler == null) {
            throw new IOException();
        }
        replyHandler.handlePushRequest(pushRequest, null);
    }

    public abstract GroupPingRequest createGroupPingRequest(String var1);

    private void handleRouteTableMessage(RouteTableMessage routeTableMessage, ManagedConnection managedConnection) {
        if (!managedConnection.isSupernodeClientConnection()) {
            return;
        }
        Object object = this.queryUpdateLock;
        synchronized (object) {
            ManagedConnectionQueryInfo managedConnectionQueryInfo = managedConnection.getQueryRouteState();
            if (managedConnectionQueryInfo == null) {
                managedConnectionQueryInfo = new ManagedConnectionQueryInfo();
                managedConnection.setQueryRouteState(managedConnectionQueryInfo);
            }
            if (managedConnectionQueryInfo.lastReceived == null) {
                managedConnectionQueryInfo.lastReceived = new QueryRouteTable(16384, 7);
            }
            try {
                managedConnectionQueryInfo.lastReceived.update(routeTableMessage);
            }
            catch (BadPacketException badPacketException) {
                // empty catch block
            }
        }
    }

    public void forwardQueryRouteTables() {
        if (!this._manager.hasClientSupernodeConnection()) {
            return;
        }
        Object object = this.queryUpdateLock;
        synchronized (object) {
            List list = this._manager.getInitializedConnections();
            int n = 0;
            while (n < list.size()) {
                long l;
                ManagedConnection managedConnection = (ManagedConnection)list.get(n);
                if (managedConnection.isClientSupernodeConnection() && managedConnection.isQueryRoutingEnabled() && (l = System.currentTimeMillis()) >= managedConnection.getNextQRPForwardTime()) {
                    managedConnection.setNextQRPForwardTime(l + this.QUERY_ROUTE_UPDATE_TIME);
                    ManagedConnectionQueryInfo managedConnectionQueryInfo = managedConnection.getQueryRouteState();
                    if (managedConnectionQueryInfo == null) {
                        managedConnectionQueryInfo = new ManagedConnectionQueryInfo();
                        managedConnection.setQueryRouteState(managedConnectionQueryInfo);
                    }
                    QueryRouteTable queryRouteTable = this.createRouteTable(managedConnection);
                    Iterator iterator = queryRouteTable.encode(managedConnectionQueryInfo.lastSent);
                    while (iterator.hasNext()) {
                        RouteTableMessage routeTableMessage = (RouteTableMessage)iterator.next();
                        managedConnection.send(routeTableMessage);
                    }
                    managedConnectionQueryInfo.lastSent = queryRouteTable;
                }
                ++n;
            }
        }
    }

    private QueryRouteTable createRouteTable(ReplyHandler replyHandler) {
        QueryRouteTable queryRouteTable = new QueryRouteTable(16384, 7);
        this.addQueryRoutingEntries(queryRouteTable);
        return queryRouteTable;
    }

    public Iterator responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest) {
        LinkedList linkedList = new LinkedList();
        byte[] byArray = queryRequest.getGUID();
        byte by = (byte)(queryRequest.getHops() + 1);
        int n = RouterService.getPort();
        byte[] byArray2 = RouterService.getAddress();
        UploadManager uploadManager = RouterService.getUploadManager();
        long l = uploadManager.measuredUploadSpeed();
        boolean bl = true;
        if (l == -1L) {
            l = SettingsManager.instance().getConnectionSpeed();
            bl = false;
        }
        boolean bl2 = responseArray.length;
        int n2 = 0;
        byte by2 = queryRequest.getHops();
        while (bl2 > false) {
            boolean bl3;
            Response[] responseArray2;
            boolean bl4 = bl2 < 10 != 0 ? bl2 : 10 != 0;
            if (n2 == 0 && bl4 < 10 != 0) {
                responseArray2 = responseArray;
            } else {
                responseArray2 = new Response[bl4];
                bl3 = false;
                while (bl3 < bl4) {
                    responseArray2[bl3] = responseArray[n2];
                    ++n2;
                    bl3 += 1;
                }
            }
            bl2 -= bl4;
            bl3 = uploadManager.isBusy();
            boolean bl5 = uploadManager.hadSuccesfulUpload();
            boolean bl6 = RouterService.acceptedIncomingConnection();
            boolean bl7 = SettingsManager.instance().getChatEnabled();
            List list = this.createQueryReply(byArray, by, n, byArray2, l, responseArray2, this._clientGUID, !bl6, bl3, bl5, bl, bl7);
            if (list != null) {
                linkedList.addAll(list);
            }
            if (by2 > 2) break;
        }
        return linkedList.iterator();
    }

    protected List createQueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new QueryReply(byArray, by, n, byArray2, l, responseArray, this._clientGUID, bl, bl2, bl3, bl4, bl5));
        return arrayList;
    }

    protected abstract void addQueryRoutingEntries(QueryRouteTable var1);
}

