/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PingReply
extends Message
implements Serializable {
    private static final int STANDARD_PAYLOAD_SIZE = 14;
    private byte[] payload;
    private volatile String ip;
    private volatile GGEP ggep;

    public PingReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2) {
        this(byArray, by, n, byArray2, l, l2, false);
    }

    public PingReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl) {
        this(byArray, by, n, byArray2, l, l2, bl, -1);
    }

    public PingReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, int n2) {
        this(byArray, by, n, byArray2, l, l2, bl, PingReply.newGGEP(n2, bl));
    }

    public PingReply(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, (byte)1, by, by2, byArray2.length);
        if (byArray2.length < 14) {
            throw new BadPacketException();
        }
        this.payload = byArray2;
    }

    private PingReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, byte[] byArray3) {
        super(byArray, (byte)1, by, (byte)0, 14 + (byArray3 == null ? 0 : byArray3.length));
        this.payload = new byte[this.getLength()];
        ByteOrder.short2leb((short)n, this.payload, 0);
        this.payload[2] = byArray2[0];
        this.payload[3] = byArray2[1];
        this.payload[4] = byArray2[2];
        this.payload[5] = byArray2[3];
        ByteOrder.int2leb((int)l, this.payload, 6);
        ByteOrder.int2leb(bl ? (int)PingReply.mark(l2) : (int)l2, this.payload, 10);
        if (byArray3 != null) {
            System.arraycopy(byArray3, 0, this.payload, 14, byArray3.length);
        }
    }

    private static byte[] newGGEP(int n, boolean bl) {
        try {
            Object object;
            GGEP gGEP = new GGEP(true);
            if (n >= 0) {
                gGEP.put("DU", n);
            }
            if (bl) {
                object = new byte[]{PingReply.convertToGUESSFormat(CommonUtils.getGUESSMajorVersionNumber(), CommonUtils.getGUESSMinorVersionNumber())};
                gGEP.put("GUE", (byte[])object);
                PingReply.addUltrapeerExtension(gGEP);
            }
            PingReply.addVendorExtension(gGEP);
            object = new ByteArrayOutputStream();
            gGEP.write((OutputStream)object);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            Assert.that(false, "Couldn't encode uptime or udp");
            return null;
        }
    }

    private static void addUltrapeerExtension(GGEP gGEP) {
        byte[] byArray = new byte[]{PingReply.convertToGUESSFormat(CommonUtils.getUPMajorVersionNumber(), CommonUtils.getUPMinorVersionNumber()), (byte)RouterService.getNumFreeLeafSlots(), (byte)RouterService.getNumFreeNonLeafSlots()};
        gGEP.put("UP", byArray);
    }

    private static void addVendorExtension(GGEP gGEP) {
        byte[] byArray = new byte[5];
        System.arraycopy("LIME".getBytes(), 0, byArray, 0, "LIME".getBytes().length);
        byArray[4] = PingReply.convertToGUESSFormat(CommonUtils.getMajorVersionNumber(), CommonUtils.getMinorVersionNumber());
        gGEP.put("VC", byArray);
    }

    private static byte convertToGUESSFormat(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n2 < 0 || n > 15 || n2 > 15) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        n3 <<= 4;
        return (byte)(n3 |= n2);
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
        if (this.RECORD_STATS) {
            SentMessageStatHandler.TCP_PING_REPLIES.addMessage(this);
        }
    }

    public String toString() {
        return "PingReply(" + this.getIP() + ":" + this.getPort() + ", " + super.toString() + ")";
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 0));
    }

    public synchronized String getIP() {
        if (this.ip == null) {
            this.ip = Message.ip2string(this.payload, 2);
        }
        return this.ip;
    }

    public byte[] getIPBytes() {
        byte[] byArray = new byte[]{this.payload[2], this.payload[3], this.payload[4], this.payload[5]};
        return byArray;
    }

    public long getFiles() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 6));
    }

    public long getKbytes() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 10));
    }

    public synchronized int getDailyUptime() throws BadPacketException {
        this.parseGGEP();
        if (this.ggep == null) {
            throw new BadPacketException("Missing GGEP block");
        }
        try {
            return this.ggep.getInt("DU");
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new BadPacketException("Couldn't find uptime extension.");
        }
    }

    public synchronized boolean supportsUnicast() throws BadPacketException {
        this.parseGGEP();
        if (this.ggep == null) {
            throw new BadPacketException("Missing GGEP block");
        }
        return this.ggep.hasKey("GUE");
    }

    public synchronized String getVendor() throws BadPacketException {
        this.parseGGEP();
        if (this.ggep == null) {
            throw new BadPacketException("Missing GGEP block");
        }
        try {
            return new String(this.ggep.getBytes("VC"), 0, 4);
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new BadPacketException("Corrupt GGEP block");
        }
    }

    public synchronized int getVendorMajorVersion() throws BadPacketException {
        this.parseGGEP();
        if (this.ggep == null) {
            throw new BadPacketException("Missing GGEP block");
        }
        try {
            byte[] byArray = this.ggep.getBytes("VC");
            return byArray[4] >> 4;
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new BadPacketException("Corrupt GGEP block");
        }
    }

    public synchronized int getVendorMinorVersion() throws BadPacketException {
        this.parseGGEP();
        if (this.ggep == null) {
            throw new BadPacketException("Missing GGEP block");
        }
        try {
            byte[] byArray = this.ggep.getBytes("VC");
            return byArray[4] & 0xF;
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new BadPacketException("Corrupt GGEP block");
        }
    }

    public synchronized boolean hasGGEPExtension() {
        this.parseGGEP();
        return this.ggep != null;
    }

    private synchronized void parseGGEP() {
        if (this.ggep != null || this.getLength() <= 14) {
            return;
        }
        try {
            this.ggep = new GGEP(this.payload, 14, null);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            // empty catch block
        }
    }

    public Message stripExtendedPayload() {
        byte[] byArray = new byte[14];
        System.arraycopy(this.payload, 0, byArray, 0, 14);
        try {
            return new PingReply(this.getGUID(), this.getTTL(), this.getHops(), byArray);
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false, "Couldn't strip payload! " + badPacketException);
            return null;
        }
    }

    public boolean isMarked() {
        long l = this.getKbytes();
        if (l < 8L) {
            return false;
        }
        return PingReply.isPowerOf2(ByteOrder.long2int(l));
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    public void recordDrop() {
        if (this.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_PING_REPLIES.addMessage(this);
        }
    }

    private static long mark(long l) {
        int n = ByteOrder.long2int(l);
        if (n < 12) {
            return 8L;
        }
        if (n < 24) {
            return 16L;
        }
        if (n < 48) {
            return 32L;
        }
        if (n < 96) {
            return 64L;
        }
        if (n < 192) {
            return 128L;
        }
        if (n < 384) {
            return 256L;
        }
        if (n < 768) {
            return 512L;
        }
        if (n < 1536) {
            return 1024L;
        }
        if (n < 3072) {
            return 2048L;
        }
        if (n < 6144) {
            return 4096L;
        }
        if (n < 12288) {
            return 8192L;
        }
        if (n < 24576) {
            return 16384L;
        }
        if (n < 49152) {
            return 32768L;
        }
        if (n < 98304) {
            return 65536L;
        }
        if (n < 196608) {
            return 131072L;
        }
        if (n < 393216) {
            return 262144L;
        }
        if (n < 786432) {
            return 524288L;
        }
        if (n < 0x180000) {
            return 0x100000L;
        }
        if (n < 0x300000) {
            return 0x200000L;
        }
        if (n < 0x600000) {
            return 0x400000L;
        }
        if (n < 0xC00000) {
            return 0x800000L;
        }
        if (n < 0x1800000) {
            return 0x1000000L;
        }
        if (n < 0x3000000) {
            return 0x2000000L;
        }
        if (n < 0x6000000) {
            return 0x4000000L;
        }
        if (n < 0xC000000) {
            return 0x8000000L;
        }
        if (n < 0x18000000) {
            return 0x10000000L;
        }
        if (n < 0x30000000) {
            return 0x20000000L;
        }
        return 0x40000000L;
    }
}

