/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.GGEPUtil;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class QueryReply
extends Message
implements Serializable {
    public static final int XML_MAX_SIZE = 32768;
    public static final int COMMON_PAYLOAD_LEN = 4;
    private byte[] payload;
    private volatile boolean parsed = false;
    private volatile Response[] responses = null;
    private volatile String vendor = null;
    private volatile int pushFlag = -1;
    private volatile int busyFlag = -1;
    private volatile int uploadedFlag = -1;
    private volatile int measuredSpeedFlag = -1;
    private volatile int supportsChat = -1;
    private volatile int supportsBrowseHost = 0;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNDEFINED = -1;
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_MASK = 1;
    private byte[] _xmlBytes = new byte[0];
    private byte[] _address = new byte[4];
    public static final boolean debugOn = false;

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, new byte[0], false, false, false, false, false, false, true);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, new byte[0], true, bl, bl2, bl3, bl4, bl5, true);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true);
        if (byArray4.length > 32768) {
            throw new IllegalArgumentException();
        }
        this._xmlBytes = byArray4;
    }

    public QueryReply(byte[] byArray, byte by, byte by2, byte[] byArray2) {
        super(byArray, (byte)-127, by, by2, byArray2.length);
        this.payload = byArray2;
        this.setAddress();
    }

    public QueryReply(byte[] byArray, QueryReply queryReply) {
        super(byArray, (byte)-127, queryReply.getTTL(), queryReply.getHops(), queryReply.getLength());
        this.payload = queryReply.payload;
        this.setAddress();
    }

    private QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        super(byArray, (byte)-127, by, (byte)0, 11 + QueryReply.rLength(responseArray) + QueryReply.qhdLength(bl, byArray4, bl7) + 16);
        if (byArray4.length > 32768) {
            return;
        }
        int n2 = responseArray.length;
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (byArray2.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + byArray2.length);
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + l);
        }
        if (n2 >= 256) {
            throw new IllegalArgumentException("invalid num responses: " + n2);
        }
        this.payload = new byte[this.getLength()];
        this.payload[0] = (byte)n2;
        ByteOrder.short2leb((short)n, this.payload, 1);
        this.payload[3] = byArray2[0];
        this.payload[4] = byArray2[1];
        this.payload[5] = byArray2[2];
        this.payload[6] = byArray2[3];
        ByteOrder.int2leb((int)l, this.payload, 7);
        int n3 = 11;
        int n4 = n2;
        while (n4 > 0) {
            Response response = responseArray[n2 - n4];
            n3 = response.writeToArray(this.payload, n3);
            --n4;
        }
        if (bl) {
            this.payload[n3++] = 76;
            this.payload[n3++] = 73;
            this.payload[n3++] = 77;
            this.payload[n3++] = 69;
            this.payload[n3++] = 4;
            int n5 = GGEPUtil.getQRGGEP(false).length;
            this.payload[n3++] = (byte)((bl2 ? 1 : 0) | 4 | 8 | 0x10 | 0x20);
            this.payload[n3++] = (byte)(1 | (bl3 ? 4 : 0) | (bl4 ? 8 : 0) | (bl5 ? 16 : 0) | (bl7 ? 32 : (n5 > 0 ? 32 : 0)));
            int n6 = byArray4.length + 1;
            if (n6 > 32768) {
                n6 = 32768;
            }
            ByteOrder.short2leb((short)n6, this.payload, n3);
            n3 += 2;
            this.payload[n3++] = bl6 ? (byte)1 : 0;
            byte[] byArray5 = GGEPUtil.getQRGGEP(bl7);
            System.arraycopy(byArray5, 0, this.payload, n3, byArray5.length);
            System.arraycopy(byArray4, 0, this.payload, n3 += byArray5.length, n6 - 1);
            n3 += n6 - 1;
            this.payload[n3++] = 0;
        }
        int n7 = 0;
        while (n7 < 16) {
            this.payload[n3 + n7] = byArray3[n7];
            ++n7;
        }
        this.setAddress();
    }

    private void setAddress() {
        this._address[0] = this.payload[3];
        this._address[1] = this.payload[4];
        this._address[2] = this.payload[5];
        this._address[3] = this.payload[6];
    }

    public void setGUID(GUID gUID) {
        super.setGUID(gUID);
    }

    private static int rLength(Response[] responseArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < responseArray.length) {
            n += responseArray[n2].getLength();
            ++n2;
        }
        return n;
    }

    private static int qhdLength(boolean bl, byte[] byArray, boolean bl2) {
        int n = 0;
        if (bl) {
            n += 4;
            ++n;
            n += 4;
            n += GGEPUtil.getQRGGEP(bl2).length;
            ++n;
            int n2 = byArray.length;
            n = n2 + 1 > 32768 ? (n += 32768) : (n += n2 + 1);
        }
        return n;
    }

    public void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
        if (this.RECORD_STATS) {
            SentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
        }
    }

    public byte[] getXMLBytes() {
        return this._xmlBytes;
    }

    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this.payload[0]);
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 1));
    }

    public String getIP() {
        return Message.ip2string(this._address);
    }

    public long getSpeed() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 7));
    }

    public Iterator getResults() throws BadPacketException {
        this.parseResults();
        if (this.responses == null) {
            throw new BadPacketException();
        }
        List list = Arrays.asList(this.responses);
        return list.iterator();
    }

    public List getResultsAsList() throws BadPacketException {
        this.parseResults();
        if (this.responses == null) {
            throw new BadPacketException();
        }
        List list = Arrays.asList(this.responses);
        return list;
    }

    public String getVendor() throws BadPacketException {
        this.parseResults();
        if (this.vendor == null) {
            throw new BadPacketException();
        }
        return this.vendor;
    }

    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this.pushFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for push flag: " + this.pushFlag);
        return false;
    }

    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this.busyFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for busy flag: " + this.pushFlag);
        return false;
    }

    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this.uploadedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for uploaded flag: " + this.pushFlag);
        return false;
    }

    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this.measuredSpeedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for measured speed flag: " + this.pushFlag);
        return false;
    }

    public boolean getSupportsChat() throws BadPacketException {
        this.parseResults();
        switch (this.supportsChat) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for supportsChat: " + this.supportsChat);
        return false;
    }

    public boolean getSupportsBrowseHost() throws BadPacketException {
        this.parseResults();
        switch (this.supportsBrowseHost) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for supportsBrowseHost: " + this.supportsBrowseHost);
        return false;
    }

    private void parseResults() {
        if (this.parsed) {
            return;
        }
        this.parseResults2();
        this.parsed = true;
    }

    private void parseResults2() {
        Object object;
        int n = 11;
        int n2 = this.getResultCount();
        Response[] responseArray = new Response[n2];
        try {
            object = new ByteArrayInputStream(this.payload, n, this.payload.length - n);
            while (n2 > 0) {
                Response response;
                responseArray[responseArray.length - n2] = response = Response.createFromStream((InputStream)object);
                n += response.getLength();
                --n2;
            }
            this.responses = responseArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        try {
            int n3;
            int n4;
            int n5;
            if (n >= this.payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            object = null;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            int n11 = -1;
            try {
                object = new String(this.payload, n, 4, "ISO-8859-1");
                Assert.that(((String)object).length() == 4, "Vendor length wrong.  Wrong character encoding?");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.that(false, "No support for ISO-8859-1 encoding");
            }
            int n12 = ByteOrder.ubyte2int(this.payload[n += 4]);
            if (n12 <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++n + n12 > this.payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            int n13 = n6 = (this.payload[n] & 1) == 1 ? 1 : 0;
            if (n12 > 1) {
                n5 = this.payload[n];
                n4 = this.payload[n + 1];
                if ((n5 & 4) != 0) {
                    int n14 = n7 = (n4 & 4) != 0 ? 1 : 0;
                }
                if ((n5 & 8) != 0) {
                    int n15 = n8 = (n4 & 8) != 0 ? 1 : 0;
                }
                if ((n5 & 0x10) != 0) {
                    int n16 = n9 = (n4 & 0x10) != 0 ? 1 : 0;
                }
                if ((n5 & 0x20) != 0 && (n4 & 0x20) != 0) {
                    n3 = n + 2;
                    while (this.payload[n3] != -61 && n3 < this.payload.length) {
                        ++n3;
                    }
                    GGEP[] gGEPArray = null;
                    try {
                        gGEPArray = GGEP.read(this.payload, n3);
                        if (GGEPUtil.allowsBrowseHost(gGEPArray)) {
                            n11 = 1;
                        }
                    }
                    catch (BadGGEPBlockException badGGEPBlockException) {
                        // empty catch block
                    }
                }
                n += 2;
            }
            if (n12 > 2) {
                int n17;
                if ((n17 = (n5 = (n3 = ByteOrder.ubyte2int(this.payload[n++]))) | (n4 = (n3 = ByteOrder.ubyte2int(this.payload[n++])) << 8)) > 1) {
                    int n18 = this.payload.length - 16 - n17;
                    this._xmlBytes = new byte[n17 - 1];
                    System.arraycopy(this.payload, n18, this._xmlBytes, 0, n17 - 1);
                } else {
                    this._xmlBytes = new byte[0];
                }
            }
            if ((n5 = this.payload.length - n) > 0 && (((String)object).equals("LIME") || ((String)object).equals("RAZA"))) {
                n4 = this.payload[n];
                int n19 = n10 = (n4 & 1) != 0 ? 1 : 0;
            }
            if (n > this.payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            Assert.that(object != null);
            this.vendor = ((String)object).toUpperCase();
            this.pushFlag = n6;
            this.busyFlag = n7;
            this.uploadedFlag = n8;
            this.measuredSpeedFlag = n9;
            this.supportsChat = n10;
            this.supportsBrowseHost = n11;
            QueryReply.debug("QR.parseResults2(): returning w/o exception.");
        }
        catch (BadPacketException badPacketException) {
            QueryReply.debug("QR.parseResults2(): bpe = " + badPacketException);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            QueryReply.debug("QR.parseResults2(): index exception = " + indexOutOfBoundsException);
            return;
        }
    }

    public byte[] getClientGUID() {
        byte[] byArray = new byte[16];
        int n = super.getLength();
        System.arraycopy(this.payload, n - 16, byArray, 0, 16);
        return byArray;
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public String toString() {
        return "QueryReply::\r\n" + this.getResultCount() + " hits\r\n" + super.toString() + "\r\n" + "ip: " + this.getIP() + "\r\n";
    }

    public RemoteFileDesc[] toRemoteFileDescArray(boolean bl) throws BadPacketException {
        List list = null;
        try {
            list = this.getResultsAsList();
        }
        catch (BadPacketException badPacketException) {
            QueryReply.debug(badPacketException);
            throw badPacketException;
        }
        RemoteFileDesc[] remoteFileDescArray = new RemoteFileDesc[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        String string = this.getIP();
        int n2 = this.getPort();
        int n3 = this.calculateQualityOfService(!RouterService.acceptedIncomingConnection());
        long l = this.getSpeed();
        byte[] byArray = this.getClientGUID();
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.getSupportsChat();
            bl3 = this.getSupportsBrowseHost();
        }
        catch (BadPacketException badPacketException) {}
        while (iterator.hasNext()) {
            Response response = (Response)iterator.next();
            remoteFileDescArray[n++] = new RemoteFileDesc(string, n2, response.getIndex(), response.getName(), (int)response.getSize(), byArray, (int)l, bl2, n3, bl3, response.getDocument(), response.getUrns());
        }
        return remoteFileDescArray;
    }

    public int calculateQualityOfService(boolean bl) {
        int n;
        int n2;
        try {
            n2 = this.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException badPacketException) {
            n2 = 0;
        }
        if (new Endpoint(this.getIP(), this.getPort()).isPrivateAddress()) {
            n = 1;
        } else {
            try {
                n = this.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException badPacketException) {
                n = 0;
            }
        }
        if (Arrays.equals(this._address, RouterService.getAddress())) {
            return 3;
        }
        if (bl && n == 1) {
            return -1;
        }
        if (n2 == 0 || n == 0) {
            return 0;
        }
        if (n2 == 1) {
            Assert.that(n == -1 || !bl);
            if (n == 1) {
                return 0;
            }
            return 1;
        }
        if (n2 == -1) {
            Assert.that(n == -1 || !bl);
            if (n == 1) {
                return 2;
            }
            return 3;
        }
        Assert.that(false, "Unexpected case!");
        return -1;
    }

    public static boolean isFirewalledQuality(int n) {
        return n == 0 || n == 2;
    }

    public void recordDrop() {
        if (this.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
        }
    }

    public static void debug(String string) {
    }

    public static void debug(Exception exception) {
    }
}

