/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;

public class QueryRequest
extends Message
implements Serializable {
    private final byte[] payload;
    private final int minSpeed;
    private final String query;
    private final String richQuery;
    private final Set requestedUrnTypes;
    private final Set queryUrns;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public QueryRequest(byte[] byArray, byte by, int n, String string, String string2) {
        this(byArray, by, n, string, string2, false, null, null);
    }

    public QueryRequest(byte[] byArray, byte by, int n, String string) {
        this(byArray, by, n, string, "");
    }

    public QueryRequest(byte by, int n, String string) {
        this(QueryRequest.newQueryGUID(false), by, n, string, "", false, null, null);
    }

    public QueryRequest(byte by, int n, String string, boolean bl) {
        this(QueryRequest.newQueryGUID(bl), by, n, string, "", bl, null, null);
    }

    public QueryRequest(byte by, int n, String string, String string2, boolean bl) {
        this(QueryRequest.newQueryGUID(bl), by, n, string, string2, bl, null, null);
    }

    public QueryRequest(byte[] byArray, byte by, int n, String string, String string2, boolean bl, Set set, Set set2) {
        super(byArray, (byte)-128, by, (byte)0, 0);
        this.minSpeed = n;
        this.query = string == null ? "" : string;
        this.richQuery = string2 == null ? "" : string2;
        HashSet hashSet = null;
        HashSet hashSet2 = null;
        hashSet = set != null ? new HashSet(set) : new HashSet();
        hashSet2 = set2 != null ? new HashSet(set2) : new HashSet();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ByteOrder.short2leb((short)n, byteArrayOutputStream);
            byteArrayOutputStream.write(string.getBytes());
            byteArrayOutputStream.write(0);
            boolean bl2 = false;
            bl2 = this.writeGemExtension(byteArrayOutputStream, bl2, string2);
            bl2 = this.writeGemExtensions(byteArrayOutputStream, bl2, hashSet2 == null ? null : hashSet2.iterator());
            bl2 = this.writeGemExtensions(byteArrayOutputStream, bl2, hashSet == null ? null : hashSet.iterator());
            byteArrayOutputStream.write(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.payload = byteArrayOutputStream.toByteArray();
        this.updateLength(this.payload.length);
        this.queryUrns = Collections.unmodifiableSet(hashSet2);
        this.requestedUrnTypes = Collections.unmodifiableSet(hashSet);
    }

    public QueryRequest(byte[] byArray, byte by, byte by2, byte[] byArray2) {
        super(byArray, (byte)-128, by, by2, byArray2.length);
        this.payload = byArray2 == null ? EMPTY_BYTE_ARRAY : byArray2;
        String string = "";
        String string2 = "";
        int n = 0;
        Set set = null;
        HashSet hashSet = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.payload);
            short s = ByteOrder.leb2short(byteArrayInputStream);
            n = ByteOrder.ubytes2int(s);
            string = super.readNullTerminatedString(byteArrayInputStream);
            String string3 = super.readNullTerminatedString(byteArrayInputStream);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\u001c");
            while (stringTokenizer.hasMoreElements()) {
                String string4 = stringTokenizer.nextToken();
                if (URN.isUrn(string4)) {
                    URN uRN = null;
                    try {
                        uRN = URN.createSHA1Urn(string4);
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    if (set == null) {
                        set = new HashSet();
                    }
                    set.add(uRN);
                    continue;
                }
                if (UrnType.isSupportedUrnType(string4)) {
                    if (hashSet == null) {
                        hashSet = new HashSet();
                    }
                    if (!UrnType.isSupportedUrnType(string4)) continue;
                    hashSet.add(UrnType.createUrnType(string4));
                    continue;
                }
                if (!string4.startsWith("<?xml")) continue;
                string2 = string4;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.query = string;
        this.richQuery = string2;
        this.minSpeed = n;
        this.queryUrns = set == null ? EMPTY_SET : Collections.unmodifiableSet(set);
        this.requestedUrnTypes = hashSet == null ? EMPTY_SET : Collections.unmodifiableSet(hashSet);
    }

    public static byte[] newQueryGUID(boolean bl) {
        return bl ? GUID.makeGuidRequery() : GUID.makeGuid();
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
        if (this.RECORD_STATS) {
            SentMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(this);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getRichQuery() {
        return this.richQuery;
    }

    public Set getRequestedUrnTypes() {
        return this.requestedUrnTypes;
    }

    public Set getQueryUrns() {
        return this.queryUrns;
    }

    public int getMinSpeed() {
        return this.minSpeed;
    }

    public void recordDrop() {
        if (this.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(this);
        }
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public String toString() {
        return "QueryRequest:\r\nquery:             " + this.getQuery() + "\r\n" + "rich query:        " + this.getRichQuery() + "\r\n" + "requestedUrnTypes: " + this.getRequestedUrnTypes() + "\r\n" + "query urns:        " + this.getQueryUrns().size() + "\r\n" + "min speed:         " + this.getMinSpeed();
    }
}

