/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import java.net.InetAddress;

public final class QueryUnicaster {
    public static final int ITERATION_TIME = 100;
    public static final int MIN_ENDPOINTS = 25;
    public static final int MAX_ENDPOINTS = 2000;
    private static QueryUnicaster _instance = null;
    private Thread _querier = null;
    private boolean _shouldRun = true;
    private Map _queries;
    private Map _querySets;
    private LinkedList _queryHosts;
    private Buffer _pingList;
    private List _qGuidsToRemove;
    private long _lastPingTime = 0L;
    private int _testUDPPingsSent = 0;
    private final boolean RECORD_STATS = !CommonUtils.isJava118();
    private static final boolean debugOn = false;

    public static QueryUnicaster instance() {
        return _instance;
    }

    int getQueryNumber() {
        return this._queries.size();
    }

    public List getUnicastEndpoints() {
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            QueryUnicaster.debug("QueryUnicaster.getUnicastEndpoints(): obtained lock.");
            int n = this._queryHosts.size();
            if (n > 0) {
                int n2 = n > 10 ? 10 : n;
                int n3 = 0;
                while (n3 < n2) {
                    arrayList.add(this._queryHosts.get(n3));
                    ++n3;
                }
            }
            QueryUnicaster.debug("QueryUnicaster.getUnicastEndpoints(): releasing lock.");
        }
        return arrayList;
    }

    public GUESSEndpoint getUnicastEndpoint() {
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            if (this._queryHosts.isEmpty()) {
                GUESSEndpoint gUESSEndpoint = null;
                return gUESSEndpoint;
            }
            GUESSEndpoint gUESSEndpoint = (GUESSEndpoint)this._queryHosts.getFirst();
            return gUESSEndpoint;
        }
    }

    private QueryUnicaster() {
        this._queries = new Hashtable();
        this._queryHosts = new LinkedList();
        this._pingList = new Buffer(25);
        this._querySets = new Hashtable();
        this._qGuidsToRemove = new Vector();
        this._querier = new Thread(){

            public void run() {
                try {
                    QueryUnicaster.this.queryLoop();
                }
                catch (Throwable throwable) {
                    RouterService.error(throwable);
                }
            }
        };
        if (SettingsManager.instance().getGuessEnabled()) {
            this._querier.start();
        }
    }

    private void queryLoop() {
        UDPService uDPService = UDPService.instance();
        while (this._shouldRun) {
            try {
                Object object;
                this.waitForQueries();
                GUESSEndpoint gUESSEndpoint = this.getUnicastHost();
                this.purgeGuidsInternal();
                boolean bl = false;
                Map map = this._queries;
                synchronized (map) {
                    object = this._queries.values().iterator();
                    while (object.hasNext()) {
                        QueryBundle queryBundle = (QueryBundle)object.next();
                        if (queryBundle._numResults > 250 || queryBundle._hostsQueried.size() > 1000) {
                            this._qGuidsToRemove.add(new GUID(queryBundle._qr.getGUID()));
                            continue;
                        }
                        if (queryBundle._hostsQueried.contains(gUESSEndpoint)) continue;
                        InetAddress inetAddress = gUESSEndpoint.getAddress();
                        QueryUnicaster.debug("QueryUnicaster.queryLoop(): sending query " + queryBundle._qr.getQuery());
                        uDPService.send(queryBundle._qr, inetAddress, gUESSEndpoint.getPort());
                        bl = true;
                        if (this.RECORD_STATS) {
                            SentMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(queryBundle._qr);
                        }
                        queryBundle._hostsQueried.add(gUESSEndpoint);
                    }
                }
                if (!bl) {
                    this.addUnicastEndpoint(gUESSEndpoint);
                }
                object = this._qGuidsToRemove;
                synchronized (object) {
                    this.purgeGuidsInternal();
                    this._qGuidsToRemove.clear();
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void purgeGuidsInternal() {
        List list = this._qGuidsToRemove;
        synchronized (list) {
            Iterator iterator = this._qGuidsToRemove.iterator();
            while (iterator.hasNext()) {
                GUID gUID = (GUID)iterator.next();
                this._queries.remove(gUID);
            }
        }
    }

    private void waitForQueries() throws InterruptedException {
        QueryUnicaster.debug("QueryUnicaster.waitForQueries(): waiting for Queries.");
        Map map = this._queries;
        synchronized (map) {
            if (this._queries.isEmpty()) {
                this._queries.wait();
            }
        }
        QueryUnicaster.debug("QueryUnicaster.waitForQueries(): numQueries = " + this._queries.size());
    }

    public boolean addQuery(QueryRequest queryRequest, ReplyHandler replyHandler) {
        Object object;
        QueryUnicaster.debug("QueryUnicaster.addQuery(): entered.");
        boolean bl = false;
        GUID gUID = new GUID(queryRequest.getGUID());
        Map map = this._queries;
        synchronized (map) {
            if (!this._queries.containsKey(gUID)) {
                object = new QueryBundle(queryRequest);
                this._queries.put(gUID, object);
                bl = true;
            }
            if (bl) {
                this._queries.notifyAll();
            }
        }
        if (replyHandler == null) {
            return bl;
        }
        object = this._querySets;
        synchronized (object) {
            Set set = (Set)this._querySets.get(replyHandler);
            if (set == null) {
                set = new HashSet();
                this._querySets.put(replyHandler, set);
            }
            set.add(gUID);
        }
        QueryUnicaster.debug("QueryUnicaster.addQuery(): returning " + bl);
        return bl;
    }

    public void addUnicastEndpoint(InetAddress inetAddress, int n) {
        if (!SettingsManager.instance().getGuessEnabled()) {
            return;
        }
        if (this.notMe(inetAddress, n)) {
            GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
            this.addUnicastEndpoint(gUESSEndpoint);
        }
    }

    private void addUnicastEndpoint(GUESSEndpoint gUESSEndpoint) {
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            QueryUnicaster.debug("QueryUnicaster.addUnicastEndpoint(): obtained lock.");
            if (this._queryHosts.size() == 2000) {
                this._queryHosts.removeLast();
            }
            this._queryHosts.addFirst(gUESSEndpoint);
            this._queryHosts.notify();
            if (UDPService.instance().isListening() && !RouterService.isGUESSCapable() && this._testUDPPingsSent < 5) {
                PingRequest pingRequest = new PingRequest(1);
                UDPService.instance().send(pingRequest, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
                if (this.RECORD_STATS) {
                    SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pingRequest);
                }
                ++this._testUDPPingsSent;
            }
            QueryUnicaster.debug("QueryUnicaster.addUnicastEndpoint(): released lock.");
        }
    }

    private boolean notMe(InetAddress inetAddress, int n) {
        boolean bl = true;
        if (n == RouterService.getPort() && Arrays.equals(inetAddress.getAddress(), RouterService.getAddress())) {
            bl = false;
        }
        return bl;
    }

    void purgeQuery(ReplyHandler replyHandler) {
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(RH): entered.");
        if (replyHandler == null) {
            return;
        }
        Map map = this._querySets;
        synchronized (map) {
            Set set = (Set)this._querySets.remove(replyHandler);
            if (set == null) {
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.purgeQuery((GUID)iterator.next());
            }
        }
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(RH): returning.");
    }

    void purgeQuery(GUID gUID) {
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(GUID): entered.");
        this._qGuidsToRemove.add(gUID);
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(GUID): returning.");
    }

    public void handleQueryReply(QueryReply queryReply) {
        this.addResults(new GUID(queryReply.getGUID()), queryReply.getResultCount());
    }

    private void addResults(GUID gUID, int n) {
        Map map = this._queries;
        synchronized (map) {
            QueryBundle queryBundle = (QueryBundle)this._queries.get(gUID);
            if (queryBundle != null) {
                queryBundle._numResults += n;
            }
        }
    }

    private GUESSEndpoint getUnicastHost() throws InterruptedException {
        Object object;
        QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): waiting for hosts.");
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): obtained lock.");
            while (this._queryHosts.isEmpty()) {
                if (System.currentTimeMillis() - this._lastPingTime > 20000L) {
                    object = new PingRequest(SettingsManager.instance().getTTL());
                    RouterService.getMessageRouter().broadcastPingRequest((PingRequest)object);
                    this._lastPingTime = System.currentTimeMillis();
                }
                this._queryHosts.wait();
            }
            QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): got a host, let go lock!");
        }
        if (this._queryHosts.size() < 25) {
            object = (GUESSEndpoint)this._queryHosts.removeLast();
            Buffer buffer = this._pingList;
            synchronized (buffer) {
                if (!this._pingList.contains(object)) {
                    PingRequest pingRequest = new PingRequest(1);
                    InetAddress inetAddress = ((GUESSEndpoint)object).getAddress();
                    UDPService.instance().send(pingRequest, inetAddress, ((GUESSEndpoint)object).getPort());
                    this._pingList.add(object);
                    if (this.RECORD_STATS) {
                        SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pingRequest);
                    }
                }
            }
            return object;
        }
        return (GUESSEndpoint)this._queryHosts.removeLast();
    }

    private static final void debug(String string) {
    }

    private static final void debug(Exception exception) {
    }

    static {
        _instance = new QueryUnicaster();
    }

    private static class QueryBundle {
        public static final int MAX_RESULTS = 250;
        public static final int MAX_QUERIES = 1000;
        final QueryRequest _qr;
        int _numResults = 0;
        final Set _hostsQueried = new HashSet();

        public QueryBundle(QueryRequest queryRequest) {
            this._qr = queryRequest;
        }

        public String toString() {
            return "QueryBundle: " + this._qr;
        }
    }
}

