/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class RemoteFileDesc
implements Serializable {
    private static final long serialVersionUID = 6619479308616716538L;
    private final String _host;
    private final int _port;
    private final String _filename;
    private final long _index;
    private final byte[] _clientGUID;
    private final int _speed;
    private final int _size;
    private final boolean _chatEnabled;
    private final int _quality;
    private LimeXMLDocument[] _xmlDocs;
    private Set _urns;
    private boolean _browseHostEnabled;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public RemoteFileDesc(String string, int n, long l, String string2, int n2, byte[] byArray, int n3, boolean bl, int n4, boolean bl2, LimeXMLDocument limeXMLDocument, Set set) {
        this._speed = n3;
        this._host = string;
        this._port = n;
        this._index = l;
        this._filename = string2;
        this._size = n2;
        this._clientGUID = byArray;
        this._chatEnabled = bl;
        this._quality = n4;
        this._browseHostEnabled = bl2;
        this._xmlDocs = limeXMLDocument != null ? new LimeXMLDocument[]{limeXMLDocument} : null;
        this._urns = set == null ? EMPTY_SET : Collections.unmodifiableSet(set);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this._urns == null) {
            this._urns = EMPTY_SET;
            this._browseHostEnabled = false;
        }
        if (this._xmlDocs != null && this._xmlDocs.length == 0) {
            this._xmlDocs = null;
        }
    }

    public final String getHost() {
        return this._host;
    }

    public final int getPort() {
        return this._port;
    }

    public final long getIndex() {
        return this._index;
    }

    public final int getSize() {
        return this._size;
    }

    public final String getFileName() {
        return this._filename;
    }

    public final byte[] getClientGUID() {
        return this._clientGUID;
    }

    public final int getSpeed() {
        return this._speed;
    }

    public final boolean chatEnabled() {
        return this._chatEnabled;
    }

    public final boolean browseHostEnabled() {
        return this._browseHostEnabled;
    }

    public final int getQuality() {
        return this._quality;
    }

    public final LimeXMLDocument getXMLDoc() {
        if (this._xmlDocs == null) {
            return null;
        }
        return this._xmlDocs[0];
    }

    public final Set getUrns() {
        return this._urns;
    }

    public final URN getSHA1Urn() {
        Iterator iterator = this._urns.iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (!uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public URL getUrl() {
        try {
            String string = "";
            URN uRN = this.getSHA1Urn();
            string = uRN == null ? "/get/" + this._index + "/" + this._filename : "/uri-res/N2R?" + uRN.httpStringValue();
            return new URL("http", this._host, this._port, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public final boolean isPrivate() {
        if (this._host == null) {
            return true;
        }
        Endpoint endpoint = new Endpoint(this._host, this._port);
        return endpoint.isPrivateAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (object == this) {
            return true;
        }
        if (!(object instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
        if (this._host == null) {
            if (remoteFileDesc._host != null) return false;
            bl4 = true;
        } else {
            bl4 = this._host.equals(remoteFileDesc._host);
        }
        if (!bl4) return false;
        if (this._port != remoteFileDesc._port) return false;
        if (this._filename == null) {
            if (remoteFileDesc._filename != null) return false;
            bl3 = true;
        } else {
            bl3 = this._filename.equals(remoteFileDesc._filename);
        }
        if (!bl3) return false;
        if (this._index != remoteFileDesc._index) return false;
        if (this._clientGUID == null) {
            if (remoteFileDesc._clientGUID != null) return false;
            bl2 = true;
        } else {
            bl2 = Arrays.equals(this._clientGUID, remoteFileDesc._clientGUID);
        }
        if (!bl2) return false;
        if (this._speed != remoteFileDesc._speed) return false;
        if (this._size != remoteFileDesc._size) return false;
        if (this.getXMLDoc() == null) {
            if (remoteFileDesc.getXMLDoc() != null) return false;
            bl = true;
        } else {
            bl = this.getXMLDoc().equals(remoteFileDesc.getXMLDoc());
        }
        if (!bl) return false;
        if (this._urns == null) {
            if (remoteFileDesc._urns != null) return false;
            return true;
        }
        boolean bl5 = this._urns.equals(remoteFileDesc._urns);
        if (!bl5) return false;
        return true;
    }

    public String toString() {
        return "<" + this.getHost() + ":" + this.getPort() + ", " + this.getFileName() + "/" + this.getSize() + ", " + this.getSpeed() + ", " + this.getSHA1Urn() + ", " + this.getQuality() + ">";
    }
}

