/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class Response {
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private String metadata;
    private byte[] metaBytes;
    private LimeXMLDocument document;
    private final Set urns;
    private final byte[] extBytes;
    private static final String AUDIOS_NAMESPACE = "<audios xsi:noNamespaceSchemaLocation=\"http://www.limewire.com/schemas/audio.xsd\">";
    private static final String AUDIO_TITLE = "<audio title=\"";
    private static final String AUDIO_BITRATE = "bitrate=\"";
    private static final String AUDIO_SECONDS = "seconds=\"";
    private static final String AUDIOS_CLOSE = "</audio></audios>";
    private static final String QUOTE_SPACE = "\" ";
    private static final String CLOSE_TAG = "\">";
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public Response(long l, long l2, String string) {
        this(l, l2, string, "", null, null);
    }

    public Response(long l, long l2, String string, LimeXMLDocument limeXMLDocument) {
        this(l, l2, string, Response.extractMetadata(limeXMLDocument), null, limeXMLDocument);
    }

    public Response(long l, long l2, String string, String string2) {
        this(l, l2, string, string2, null, null);
    }

    public Response(FileDesc fileDesc) {
        this(fileDesc.getIndex(), fileDesc.getSize(), fileDesc.getName(), "", fileDesc.getUrns(), null);
    }

    public Response(long l, long l2, String string, String string2, Set set, LimeXMLDocument limeXMLDocument) {
        Assert.that((l & 0xFFFFFFFF00000000L) == 0L, "Response constructor: index too big!");
        Assert.that((l2 & 0xFFFFFFFF00000000L) == 0L, "Response constructor: size too big!");
        this.index = l;
        this.size = l2;
        this.name = string == null ? "" : string;
        this.nameBytes = this.name.getBytes();
        this.urns = set == null ? EMPTY_SET : Collections.unmodifiableSet(set);
        this.extBytes = Response.createExtBytes(this.urns);
        this.metadata = (string2 == null || string2.equals("")) && limeXMLDocument != null ? Response.extractMetadata(limeXMLDocument) : (string2 == null ? "" : string2.trim());
        Assert.that(this.metadata != null, "Null metadata");
        this.metaBytes = this.metadata.getBytes();
        this.document = limeXMLDocument;
    }

    public static Response createFromStream(InputStream inputStream) throws IOException {
        int n;
        long l = ByteOrder.ubytes2long(ByteOrder.leb2int(inputStream));
        long l2 = ByteOrder.ubytes2long(ByteOrder.leb2int(inputStream));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != 0) {
            byteArrayOutputStream.write(n);
        }
        String string = new String(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) != 0) {
            byteArrayOutputStream.write(n);
        }
        String string2 = new String(byteArrayOutputStream.toByteArray());
        if (string2 == null || string2.equals("")) {
            if (inputStream.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return new Response(l, l2, string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\u001c");
        Set set = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (URN.isUrn(string4)) {
                try {
                    URN uRN = URN.createSHA1Urn(string4);
                    if (set == null) {
                        set = new HashSet();
                    }
                    set.add(uRN);
                }
                catch (IOException iOException) {}
                continue;
            }
            string3 = Response.createXmlString(string, string4);
        }
        return new Response(l, l2, string, string3, set, null);
    }

    private static String createXmlString(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.countTokens() < 2) {
            return "";
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string4.startsWith(KBPS)) {
            bl = true;
        } else if (string3.endsWith(KBPS)) {
            bl2 = true;
        }
        if (bl) {
            string6 = string3;
        } else if (bl2) {
            n = string3.indexOf(KBPS);
            string6 = string3.substring(0, n);
        }
        if (bl || bl2) {
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
        } else if (string2.endsWith(KHZ)) {
            bl3 = true;
            string5 = string3;
            n = string4.indexOf(KBPS);
            if (n > -1) {
                string6 = string4.substring(0, n);
            } else {
                bl3 = false;
            }
        }
        if (bl || bl2 || bl3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AUDIOS_NAMESPACE);
            stringBuffer.append(AUDIO_TITLE);
            stringBuffer.append(string);
            stringBuffer.append(QUOTE_SPACE);
            stringBuffer.append(AUDIO_BITRATE);
            stringBuffer.append(string6);
            stringBuffer.append(QUOTE_SPACE);
            stringBuffer.append(AUDIO_SECONDS);
            stringBuffer.append(string5);
            stringBuffer.append(CLOSE_TAG);
            stringBuffer.append(AUDIOS_CLOSE);
            return stringBuffer.toString();
        }
        return "";
    }

    private static byte[] createExtBytes(Set set) {
        try {
            if (set == null) {
                return EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                URN uRN = (URN)iterator.next();
                Assert.that(uRN != null, "Null URN");
                byteArrayOutputStream.write(uRN.toString().getBytes());
                if (!iterator.hasNext()) continue;
                byteArrayOutputStream.write(28);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return EMPTY_BYTE_ARRAY;
        }
    }

    private static String extractMetadata(LimeXMLDocument limeXMLDocument) {
        if (limeXMLDocument == null) {
            return "";
        }
        try {
            return limeXMLDocument.getXMLString();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return "";
        }
    }

    public int writeToArray(byte[] byArray, int n) {
        ByteOrder.int2leb((int)this.index, byArray, n);
        ByteOrder.int2leb((int)this.size, byArray, n + 4);
        System.arraycopy(this.nameBytes, 0, byArray, n += 8, this.nameBytes.length);
        n += this.nameBytes.length;
        byArray[n++] = 0;
        System.arraycopy(this.extBytes, 0, byArray, n, this.extBytes.length);
        n += this.extBytes.length;
        byArray[n++] = 0;
        return n;
    }

    public void setDocument(LimeXMLDocument limeXMLDocument) {
        this.document = limeXMLDocument;
        this.metadata = Response.extractMetadata(this.document);
        this.metaBytes = this.metadata.getBytes();
    }

    public int getLength() {
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public int getNameBytesSize() {
        return this.nameBytes.length;
    }

    public int getMetaBytesSize() {
        return this.metaBytes.length;
    }

    public byte[] getNameBytes() {
        byte[] byArray = new byte[this.nameBytes.length];
        System.arraycopy(this.nameBytes, 0, byArray, 0, this.nameBytes.length);
        return byArray;
    }

    public byte[] getMetaBytes() {
        byte[] byArray = new byte[this.metaBytes.length];
        System.arraycopy(this.metaBytes, 0, byArray, 0, this.metaBytes.length);
        return byArray;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public LimeXMLDocument getDocument() {
        if (this.document != null) {
            return this.document;
        }
        if (this.metadata != null) {
            try {
                return new LimeXMLDocument(this.metadata);
            }
            catch (SAXException sAXException) {
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getUrns() {
        return this.urns;
    }

    byte[] getExtBytes() {
        return this.extBytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof Response)) {
            return false;
        }
        Response response = (Response)object;
        if (this.getIndex() != response.getIndex()) return false;
        if (this.getSize() != response.getSize()) return false;
        if (!this.getName().equals(response.getName())) return false;
        if (!Arrays.equals(this.getNameBytes(), response.getNameBytes())) return false;
        if (!this.getMetadata().equals(response.getMetadata())) return false;
        if (!Arrays.equals(this.getMetaBytes(), response.getMetaBytes())) return false;
        if (this.getDocument() == null) {
            if (response.getDocument() != null) return false;
            bl = true;
        } else {
            bl = this.getDocument().equals(response.getDocument());
        }
        if (!bl) return false;
        if (!this.getUrns().equals(response.getUrns())) return false;
        if (!Arrays.equals(this.getExtBytes(), response.getExtBytes())) return false;
        return true;
    }

    public int hashCode() {
        return this.getName().hashCode() + (int)this.getSize() + (int)this.getIndex();
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "metadata:     " + this.metadata + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }
}

