/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;
import org.xml.sax.SAXException;

public class ResponseVerifier {
    private ForgetfulHashMap mapper = new ForgetfulHashMap(15);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;

    public synchronized void record(QueryRequest queryRequest) {
        this.record(queryRequest, null);
    }

    public synchronized void record(QueryRequest queryRequest, MediaType mediaType) {
        byte[] byArray = queryRequest.getGUID();
        this.mapper.put(new GUID(byArray), new RequestData(queryRequest.getQuery(), queryRequest.getRichQuery(), mediaType));
    }

    public synchronized boolean isSpecificXMLSearch(byte[] byArray) {
        boolean bl = false;
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData != null) {
            try {
                if (new LimeXMLDocument(requestData.richQuery).getNumFields() > 1) {
                    bl = true;
                }
            }
            catch (SAXException sAXException) {
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    public synchronized int score(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null) {
            return 100;
        }
        String[] stringArray = requestData.queryWords;
        return ResponseVerifier.calculateScore(stringArray, response, requestData.xmlQuery());
    }

    public static int calculateScore(String[] stringArray, Response response, boolean bl) {
        int n = 0;
        int n2 = stringArray.length;
        if (n2 == 0) {
            return 100;
        }
        String string = null;
        string = bl ? ResponseVerifier.getSearchTerms(response) : response.getName().toLowerCase();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (StringUtils.contains(string, string2)) {
                ++n;
            }
            ++n3;
        }
        return (int)((float)n * 100.0f / (float)n2);
    }

    public boolean matchesType(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null || requestData.type == null) {
            return true;
        }
        String string = response.getName();
        return requestData.type.matches(string);
    }

    public boolean isMandragoreWorm(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(requestData.query + ".exe");
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static String getSearchTerms(Response response) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = ResponseVerifier.getSearchTerms(response.getName(), response.getMetadata());
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n] + " ");
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public static String[] getSearchTerms(String string, String string2) {
        String[] stringArray = null;
        HashSet hashSet = new HashSet();
        stringArray = StringUtils.split(string.toLowerCase(), DELIMITERS);
        int n = 0;
        while (n < stringArray.length) {
            hashSet.add(stringArray[n]);
            ++n;
        }
        List list = null;
        try {
            int n2;
            if (string2 != null && !string2.equals("")) {
                list = new LimeXMLDocument(string2).getKeyWords();
            }
            if (list != null) {
                int n3 = list.size();
                n2 = 0;
                while (n2 < n3) {
                    String string3 = (String)list.remove(0);
                    hashSet.add(string3.toLowerCase());
                    ++n2;
                }
            }
            stringArray = new String[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            n2 = 0;
            while (iterator.hasNext()) {
                stringArray[n2++] = (String)iterator.next();
            }
        }
        catch (SAXException sAXException) {
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringArray;
    }

    private static class RequestData {
        String query;
        String richQuery;
        String[] queryWords;
        MediaType type;

        RequestData(String string, MediaType mediaType) {
            this(string, null, mediaType);
        }

        RequestData(String string, String string2, MediaType mediaType) {
            this.query = string;
            this.richQuery = string2;
            this.queryWords = ResponseVerifier.getSearchTerms(string, string2);
            this.type = mediaType;
        }

        public boolean xmlQuery() {
            return this.richQuery != null && !this.richQuery.equals("");
        }
    }
}

