/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;

class RouteTable {
    private Map _newMap = new TreeMap(new GUID.GUIDByteComparator());
    private Map _oldMap = new TreeMap(new GUID.GUIDByteComparator());
    private int _mseconds;
    private long _nextSwitchTime;
    private int _maxSize;
    private Map _idMap = new HashMap();
    private Map _handlerMap = new HashMap();
    private int _nextID;
    private static boolean warned = false;

    public RouteTable(int n, int n2) {
        this._mseconds = n * 1000;
        this._nextSwitchTime = System.currentTimeMillis() + (long)this._mseconds;
        this._maxSize = n2;
    }

    public synchronized void routeReply(byte[] byArray, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        Assert.that(replyHandler != null);
        if (!replyHandler.isOpen()) {
            return;
        }
        int n = this.handler2id(replyHandler);
        RouteTableEntry routeTableEntry = (RouteTableEntry)this._newMap.remove(byArray);
        if (routeTableEntry == null) {
            routeTableEntry = (RouteTableEntry)this._oldMap.remove(byArray);
        }
        if (routeTableEntry == null) {
            routeTableEntry = new RouteTableEntry(n);
        } else {
            routeTableEntry.handlerID = n;
        }
        this._newMap.put(byArray, routeTableEntry);
    }

    public synchronized boolean tryToRouteReply(byte[] byArray, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        Assert.that(replyHandler != null);
        Assert.that(byArray != null, "Null GUID in tryToRouteReply");
        if (!replyHandler.isOpen()) {
            return false;
        }
        if (!this._newMap.containsKey(byArray) && !this._oldMap.containsKey(byArray)) {
            int n = this.handler2id(replyHandler);
            this._newMap.put(byArray, new RouteTableEntry(n));
            return true;
        }
        return false;
    }

    public synchronized ReplyHandler getReplyHandler(byte[] byArray) {
        this.repOk();
        RouteTableEntry routeTableEntry = (RouteTableEntry)this._newMap.get(byArray);
        if (routeTableEntry == null) {
            routeTableEntry = (RouteTableEntry)this._oldMap.get(byArray);
        }
        return routeTableEntry == null ? null : this.id2handler(new Integer(routeTableEntry.handlerID));
    }

    public synchronized ReplyRoutePair getReplyHandler(byte[] byArray, int n) {
        this.repOk();
        RouteTableEntry routeTableEntry = (RouteTableEntry)this._newMap.get(byArray);
        if (routeTableEntry == null) {
            routeTableEntry = (RouteTableEntry)this._oldMap.get(byArray);
        }
        if (routeTableEntry == null) {
            return null;
        }
        ReplyHandler replyHandler = this.id2handler(new Integer(routeTableEntry.handlerID));
        if (replyHandler == null) {
            return null;
        }
        ReplyRoutePair replyRoutePair = new ReplyRoutePair(replyHandler, routeTableEntry.bytesRouted);
        routeTableEntry.bytesRouted += n;
        return replyRoutePair;
    }

    public synchronized void removeReplyHandler(ReplyHandler replyHandler) {
        this.repOk();
        Assert.that(replyHandler != null, "Null replyHandler in removeReplyHandler");
        Integer n = this.handler2id(replyHandler);
        this._idMap.remove(n);
        this._handlerMap.remove(replyHandler);
    }

    private Integer handler2id(ReplyHandler replyHandler) {
        Integer n = (Integer)this._handlerMap.get(replyHandler);
        if (n != null) {
            return n;
        }
        while (this._idMap.get(n = new Integer(this._nextID++)) != null) {
        }
        this._handlerMap.put(replyHandler, n);
        this._idMap.put(n, replyHandler);
        return n;
    }

    private ReplyHandler id2handler(Integer n) {
        return (ReplyHandler)this._idMap.get(n);
    }

    private final boolean purge() {
        long l = System.currentTimeMillis();
        if (l < this._nextSwitchTime && this._newMap.size() < this._maxSize) {
            return false;
        }
        this._oldMap.clear();
        Map map = this._oldMap;
        this._oldMap = this._newMap;
        this._newMap = map;
        this._nextSwitchTime = l + (long)this._mseconds;
        return true;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        TreeMap treeMap = new TreeMap(new GUID.GUIDByteComparator());
        treeMap.putAll(this._oldMap);
        treeMap.putAll(this._newMap);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            stringBuffer.append(new GUID(byArray));
            stringBuffer.append("->");
            int n = ((RouteTableEntry)treeMap.get((Object)byArray)).handlerID;
            ReplyHandler replyHandler = this.id2handler(new Integer(n));
            stringBuffer.append(replyHandler == null ? "null" : replyHandler.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private final void repOk() {
    }

    public static class ReplyRoutePair {
        private ReplyHandler handler;
        private int volume;

        ReplyRoutePair(ReplyHandler replyHandler, int n) {
            this.handler = replyHandler;
            this.volume = n;
        }

        public ReplyHandler getReplyHandler() {
            return this.handler;
        }

        public int getBytesRouted() {
            return this.volume;
        }
    }

    private static class RouteTableEntry {
        int handlerID;
        int bytesRouted;

        RouteTableEntry(int n) {
            this.handlerID = n;
            this.bytesRouted = 0;
        }
    }
}

