/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BadConnectionSettingException;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.SpamFilter;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.security.Authenticator;
import com.limegroup.gnutella.security.Cookies;
import com.limegroup.gnutella.security.ServerAuthenticator;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.util.SimpleTimer;
import com.limegroup.gnutella.xml.MetaEnabledMessageRouter;
import com.limegroup.gnutella.xml.MetaFileManager;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class RouterService {
    private static FileManager fileManager = new MetaFileManager();
    private static final Authenticator authenticator = new ServerAuthenticator();
    private static final SimpleTimer timer = new SimpleTimer(true);
    private static final Acceptor acceptor = new Acceptor();
    private static final ConnectionManager manager = new ConnectionManager(authenticator);
    private static final HostCatcher catcher = new HostCatcher();
    private static final DownloadManager downloader = new DownloadManager();
    private static UploadManager uploadManager = new UploadManager();
    private static final ResponseVerifier verifier = new ResponseVerifier();
    private static final ChatManager chatManager = ChatManager.instance();
    private static final Statistics statistics = Statistics.instance();
    private static final UDPService udpService = UDPService.instance();
    private static boolean isShuttingDown;
    private static ActivityCallback callback;
    private static MessageRouter router;
    private static final SettingsManager SETTINGS;

    public RouterService(ActivityCallback activityCallback) {
        this(activityCallback, new MetaEnabledMessageRouter(activityCallback, fileManager));
    }

    public RouterService(ActivityCallback activityCallback, MessageRouter messageRouter) {
        int n;
        callback = activityCallback;
        router = messageRouter;
        messageRouter.initialize();
        manager.initialize();
        downloader.initialize();
        SupernodeAssigner supernodeAssigner = new SupernodeAssigner(uploadManager, downloader, manager);
        supernodeAssigner.start();
        if (SETTINGS.getConnectOnStartup() && (n = SETTINGS.getKeepAlive()) > 0) {
            RouterService.connect();
        }
    }

    public void start() {
        catcher.initialize();
        acceptor.initialize();
        fileManager.initialize();
        downloader.postGuiInit();
        UpdateManager updateManager = UpdateManager.instance();
        updateManager.postGuiInit(callback);
    }

    public static ActivityCallback getCallback() {
        return callback;
    }

    public static MessageRouter getMessageRouter() {
        return router;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public static DownloadManager getDownloadManager() {
        return downloader;
    }

    public static UDPService getUdpService() {
        return udpService;
    }

    public static ConnectionManager getConnectionManager() {
        return manager;
    }

    public static UploadManager getUploadManager() {
        return uploadManager;
    }

    public static Acceptor getAcceptor() {
        return acceptor;
    }

    public static HostCatcher getHostCatcher() {
        return catcher;
    }

    public static void schedule(Runnable runnable, long l, long l2) {
        timer.schedule(runnable, l, l2);
    }

    public static ManagedConnection connectToHostBlocking(String string, int n) throws IOException {
        return manager.createConnectionBlocking(string, n);
    }

    public static void connectToHostAsynchronously(String string, int n) {
        byte[] byArray = null;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        if (byArray[0] == 127 && n == acceptor.getPort()) {
            return;
        }
        byte[] byArray2 = acceptor.getAddress();
        if (Arrays.equals(byArray, byArray2) && n == acceptor.getPort()) {
            return;
        }
        if (!acceptor.isBannedIP(string)) {
            manager.createConnectionAsynchronously(string, n);
        }
    }

    public static void connect() {
        manager.connect();
    }

    public static void disconnect() {
        manager.disconnect();
    }

    public static void removeConnection(ManagedConnection managedConnection) {
        manager.remove(managedConnection);
    }

    public static void clearHostCatcher() {
        catcher.clear();
    }

    public static int getRealNumHosts() {
        return catcher.getNumHosts();
    }

    public static int getNumDownloads() {
        return downloader.downloadsInProgress();
    }

    public static int getNumUploads() {
        return uploadManager.uploadsInProgress();
    }

    public static void shutdown() {
        try {
            Statistics.instance().shutdown();
            try {
                Object var2;
                try {
                    catcher.write(SETTINGS.getHostList());
                }
                catch (IOException iOException) {
                    var2 = null;
                    SETTINGS.writeProperties();
                }
                var2 = null;
                SETTINGS.writeProperties();
            }
            catch (Throwable throwable) {
                Object var2_1 = null;
                SETTINGS.writeProperties();
                throw throwable;
            }
            File file = null;
            try {
                file = SETTINGS.getIncompleteDirectory();
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            String[] stringArray = file.list();
            if (stringArray == null) {
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("Preview-")) {
                    File file2 = new File(file, stringArray[n]);
                    file2.delete();
                }
                ++n;
            }
            downloader.writeSnapshot();
            Cookies.instance().save();
            UrnCache.instance().persistCache();
        }
        catch (Throwable throwable) {
            RouterService.error(throwable);
        }
    }

    public static void forceKeepAlive(int n) {
        manager.setKeepAlive(n);
    }

    public static void setKeepAlive(int n) throws BadConnectionSettingException {
        if (n < 0) {
            throw new BadConnectionSettingException(1, SETTINGS.getKeepAlive());
        }
        int n2 = SETTINGS.maxConnections();
        if (manager.hasSupernodeClientConnection()) {
            if (n < 6) {
                throw new BadConnectionSettingException(4, 6);
            }
            if (n > 6 && n > n2) {
                throw new BadConnectionSettingException(2, 6 > n2 ? 6 : n2);
            }
        } else if (n > n2) {
            throw new BadConnectionSettingException(2, n2);
        }
        if (manager.getKeepAlive() == 0) {
            catcher.expire();
        }
        RouterService.forceKeepAlive(n);
    }

    public static void adjustSpamFilters() {
        acceptor.refreshBannedIPs();
        Iterator iterator = manager.getConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.setPersonalFilter(SpamFilter.newPersonalFilter());
            managedConnection.setRouteFilter(SpamFilter.newRouteFilter());
        }
    }

    public static void setListeningPort(int n) throws IOException {
        acceptor.setListeningPort(n);
    }

    public static void setAlwaysNotifyKnownHost(boolean bl) {
        catcher.setAlwaysNotifyKnownHost(bl);
    }

    public static boolean acceptedIncomingConnection() {
        return acceptor.acceptedIncoming();
    }

    public static long getNumHosts() {
        long l = 0L;
        Iterator iterator = manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            l += ((ManagedConnection)iterator.next()).getNumHosts();
        }
        return l;
    }

    public static long getNumFiles() {
        long l = 0L;
        Iterator iterator = manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            l += ((ManagedConnection)iterator.next()).getNumFiles();
        }
        return l;
    }

    public static long getTotalFileSize() {
        long l = 0L;
        Iterator iterator = manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            l += ((ManagedConnection)iterator.next()).getTotalFileSize();
        }
        return l;
    }

    public static void dumpConnections() {
        System.out.println("UltraPeer connections");
        RouterService.dumpConnections(manager.getInitializedConnections2());
        System.out.println("Leaf connections");
        RouterService.dumpConnections(manager.getInitializedClientConnections2());
    }

    private static void dumpConnections(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString());
        }
    }

    public static void updateHorizon() {
        Iterator iterator = manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            ((ManagedConnection)iterator.next()).refreshHorizonStats();
        }
    }

    public static byte[] newQueryGUID() {
        return QueryRequest.newQueryGUID(false);
    }

    public static void query(byte[] byArray, String string, int n, MediaType mediaType) {
        RouterService.query(byArray, string, "", n, mediaType);
    }

    public static void query(final byte[] byArray, final String string, final String string2, final int n, final MediaType mediaType) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    HashSet hashSet = new HashSet();
                    hashSet.add(UrnType.ANY_TYPE);
                    QueryRequest queryRequest = new QueryRequest(byArray, SETTINGS.getTTL(), n, string, string2, false, hashSet, null);
                    verifier.record(queryRequest, mediaType);
                    router.broadcastQueryRequest(queryRequest);
                }
                catch (Throwable throwable) {
                    RouterService.error(throwable);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public static void query(byte[] byArray, String string, int n) {
        RouterService.query(byArray, string, n, null);
    }

    public static void stopQuery(GUID gUID) {
        QueryUnicaster.instance().purgeQuery(gUID);
    }

    public static int score(byte[] byArray, Response response) {
        return verifier.score(byArray, response);
    }

    public static boolean isSpecificXMLSearch(byte[] byArray) {
        return verifier.isSpecificXMLSearch(byArray);
    }

    public static boolean matchesType(byte[] byArray, Response response) {
        return verifier.matchesType(byArray, response);
    }

    public static boolean isMandragoreWorm(byte[] byArray, Response response) {
        return verifier.isMandragoreWorm(byArray, response);
    }

    public static Iterator getHosts() {
        return catcher.getHosts();
    }

    public static int getNumConnections() {
        return manager.getNumConnections();
    }

    public static boolean isConnected() {
        return manager.isConnected();
    }

    public static void removeHost(String string, int n) {
        catcher.removeHost(string, n);
    }

    public static int getNumSharedFiles() {
        return fileManager.getNumFiles();
    }

    public static int getNumPendingShared() {
        return fileManager.getNumPendingFiles();
    }

    public static int getSharedFileSize() {
        return fileManager.getSize();
    }

    public static FileDesc[] getSharedFileDescriptors(File file) {
        return fileManager.getSharedFileDescriptors(file);
    }

    public static File[] getSharedFiles(File file) {
        return fileManager.getSharedFiles(file);
    }

    public static Downloader download(RemoteFileDesc[] remoteFileDescArray, boolean bl) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        return downloader.download(remoteFileDescArray, bl);
    }

    public Downloader download(File file) throws AlreadyDownloadingException, CantResumeException {
        return downloader.download(file);
    }

    public Downloader download(String string, String string2, byte[] byArray, MediaType mediaType) throws AlreadyDownloadingException {
        return downloader.download(string, string2, byArray, mediaType);
    }

    public static Chatter createChat(String string, int n) {
        Chatter chatter = ChatManager.instance().request(string, n);
        return chatter;
    }

    public static void doBrowseHost(String string, int n, GUID gUID, GUID gUID2) {
        BrowseHostHandler browseHostHandler = new BrowseHostHandler(callback, router, acceptor, gUID, gUID2);
        browseHostHandler.browseHost(string, n);
    }

    public static boolean isSupernode() {
        return manager.isSupernode();
    }

    public static boolean hasClientSupernodeConnection() {
        return manager.hasClientSupernodeConnection();
    }

    public static boolean hasSupernodeClientConnection() {
        return manager.hasSupernodeClientConnection();
    }

    public static int getNumFreeLeafSlots() {
        return manager.getNumFreeLeafSlots();
    }

    public static int getNumFreeNonLeafSlots() {
        return manager.getNumFreeNonLeafSlots();
    }

    public static void setIsShuttingDown(boolean bl) {
        isShuttingDown = bl;
    }

    public static boolean getIsShuttingDown() {
        return isShuttingDown;
    }

    public static byte[] getAddress() {
        return acceptor.getAddress();
    }

    public static int getPort() {
        return acceptor.getPort();
    }

    public static void error(int n) {
        callback.error(n);
    }

    public static void error(Throwable throwable) {
        throwable.printStackTrace();
        callback.error(throwable);
    }

    public static void error(int n, Throwable throwable) {
        throwable.printStackTrace();
        callback.error(n, throwable);
    }

    public static boolean isGUESSCapable() {
        return udpService.isGUESSCapable() && SETTINGS.getGuessEnabled();
    }

    static {
        SETTINGS = SettingsManager.instance();
    }
}

