/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Constants;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.settings.Settings;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class SettingsManager {
    private static final Properties PROPS = Settings.getProperties();
    private final String CURRENT_DIRECTORY = System.getProperty("user.dir");
    private final String SAVE_DIRECTORY_NAME = "Shared";
    private final String HOST_LIST_NAME = "gnutella.net";
    private final String PROPS_NAME = "limewire.props";
    private final String ND_PROPS_NAME = "nd.props";
    private final File PROPS_FILE = Settings.getPropertiesFile();
    private final long EXPIRY_INTERVAL = 1209600000L;
    private final boolean DEFAULT_ALLOW_BROWSER = false;
    private final byte DEFAULT_TTL = (byte)6;
    private final byte DEFAULT_SOFT_MAX_TTL = (byte)6;
    private final byte DEFAULT_MAX_TTL = (byte)16;
    private final int DEFAULT_MAX_LENGTH = 65536;
    private final int DEFAULT_TIMEOUT = 8000;
    private final int DEFAULT_PERSISTENT_HTTP_CONNECTION_TIMEOUT = 15000;
    public static final int DEFAULT_KEEP_ALIVE = 4;
    private final int DEFAULT_PORT = 6346;
    private final int DEFAULT_SPEED = 56;
    private final int DEFAULT_UPLOAD_SPEED = 100;
    private final byte DEFAULT_SEARCH_LIMIT = (byte)64;
    private final String DEFAULT_CLIENT_ID;
    private final int DEFAULT_MAX_INCOMING_CONNECTION = 4;
    private final int DEFAULT_INCOMPLETE_PURGE_TIME = 7;
    private final String DEFAULT_SERVANT_TYPE = "XML_CLIENT";
    private final String SERVANT_TYPE = "SERVANT_TYPE";
    private final int DEFAULT_UPLOADS_PER_PERSON = 3;
    private final int DEFAULT_UPLOAD_QUEUE_SIZE = 10;
    private final boolean DEFAULT_LOCAL_IS_PRIVATE = true;
    private final String[] DEFAULT_BANNED_IPS = new String[0];
    private final String[] DEFAULT_ALLOWED_IPS = new String[0];
    private final String[] DEFAULT_BANNED_WORDS = new String[0];
    private final boolean DEFAULT_FILTER_ADULT = false;
    private final boolean DEFAULT_FILTER_DUPLICATES = true;
    private final boolean DEFAULT_FILTER_VBS = true;
    private final boolean DEFAULT_FILTER_HTML = false;
    private final boolean DEFAULT_FILTER_GREEDY_QUERIES = true;
    private final boolean DEFAULT_FILTER_BEARSHARE_QUERIES = true;
    public static final String DEFAULT_LIMEWIRE_ROUTER = "router.limewire.com";
    public static final String DEDICATED_LIMEWIRE_ROUTER = CommonUtils.isMacClassic() ? "64.61.25.171" : "router4.limewire.com";
    private final int DEFAULT_PARALLEL_SEARCH = 5;
    private final int DEFAULT_MAX_SIM_DOWNLOAD = 4;
    private final boolean DEFAULT_PROMPT_EXE_DOWNLOAD = true;
    private final int DEFAULT_MAX_UPLOADS = 20;
    private final int DEFAULT_SOFT_MAX_UPLOADS = 5;
    private final boolean DEFAULT_CLEAR_UPLOAD = true;
    private final boolean DEFAULT_CLEAR_DOWNLOAD = false;
    public static final String DEFAULT_CONNECT_STRING = "GNUTELLA CONNECT/0.4";
    private final String DEFAULT_CONNECT_OK_STRING = "GNUTELLA OK";
    private final int DEFAULT_BASIC_INFO_FOR_QUERY = 1000;
    private final int DEFAULT_ADVANCED_INFO_FOR_QUERY = 50;
    private final boolean DEFAULT_CHECK_AGAIN = true;
    private final boolean DEFAULT_FORCE_IP_ADDRESS = false;
    private final String DEFAULT_FORCED_IP_ADDRESS_STRING = "0.0.0.0";
    private final int DEFAULT_FORCED_PORT = 6346;
    private final int DEFAULT_FREELOADER_FILES = 1;
    private final int DEFAULT_FREELOADER_ALLOWED = 100;
    private final long DEFAULT_AVERAGE_UPTIME = 1200L;
    private final long DEFAULT_TOTAL_UPTIME = 1200L;
    private final long DEFAULT_LAST_SHUTDOWN_TIME = 0L;
    private final float DEFAULT_FRACTIONAL_UPTIME = 0.0f;
    private final boolean DEFAULT_INSTALLED = false;
    private final int DEFAULT_APP_WIDTH = 840;
    private final int DEFAULT_APP_HEIGHT = 600;
    private final boolean DEFAULT_RUN_ONCE = false;
    private final boolean DEFAULT_MINIMIZE_TO_TRAY = CommonUtils.supportsTray();
    private final boolean DEFAULT_SHUTDOWN_AFTER_TRANSFERS = CommonUtils.isMacOSX() ? false : !this.DEFAULT_MINIMIZE_TO_TRAY;
    public static final String DEFAULT_JAR_NAME = "LimeWire.jar";
    public static final String DEFAULT_CLASSPATH = "LimeWire.jar";
    private final boolean DEFAULT_CHAT_ENABLED = true;
    private final boolean DEFAULT_GUESS_ENABLED = false;
    private final boolean DEFAULT_PLAYER_ENABLED = true;
    private final String DEFAULT_BROWSER = "netscape";
    private final String DEFAULT_LANGUAGE = "";
    private final String DEFAULT_COUNTRY = "";
    private final String DEFAULT_LOCALE_VARIANT = "";
    private final boolean DEFAULT_MONITOR_VIEW_ENABLED = true;
    private final boolean DEFAULT_CONNECTION_VIEW_ENABLED = false;
    private final boolean DEFAULT_LIBRARY_VIEW_ENABLED = true;
    private final boolean DEFAULT_SHOPPING_VIEW_ENABLED = true;
    private final boolean DEFAULT_EVER_ACCEPTED_INCOMING = false;
    private final int DEFAULT_MAX_SHIELDED_CLIENT_CONNECTIONS = 75;
    private volatile int DEFAULT_MIN_SHIELDED_CLIENT_CONNECTIONS = 4;
    private final boolean DEFAULT_ACCEPT_AUTHENTICATED_CONNECTIONS_ONLY = false;
    private final String DEFAULT_COOKIES_FILE = "lib" + File.separator + "Cookies.dat";
    private final boolean DEFAULT_SERVER = false;
    private final int DEFAULT_MINIMUM_SEARCH_QUALITY = 0;
    private final int DEFAULT_MINIMUM_SEARCH_SPEED = 0;
    private final int DEFAULT_MAX_UPSTREAM_BYTES_PER_SEC = 0;
    private final boolean DEFAULT_EVER_SUPERNODE_CAPABLE = false;
    private final boolean DEFAULT_DISABLE_SUPERNODE_MODE = false;
    private final boolean DEFAULT_FORCE_SUPERNODE_MODE = false;
    private final int DEFAULT_MAX_DOWNSTREAM_BYTES_PER_SEC = 0;
    private final int DEFAULT_SESSIONS = 1;
    private final boolean DEFAULT_CONNECT_ON_STARTUP = true;
    private final long DEFAULT_LAST_EXPIRE_TIME = 0L;
    private final String DEFAULT_AD_VERSION = "1.0";
    private final File DEFAULT_SAVE_DIRECTORY = new File(CommonUtils.getUserHomeDir(), "Shared");
    private final File DEFAULT_SKIN_THEME = new File("");
    private final String DEFAULT_DIRECTORIES = this.DEFAULT_SAVE_DIRECTORY.getAbsolutePath();
    private final String DEFAULT_EXTENSIONS = "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso";
    private final String ALLOW_BROWSER = "ALLOW_BROWSER";
    private final String TTL = "TTL";
    private final String SOFT_MAX_TTL = "SOFT_MAX_TTL";
    private final String MAX_TTL = "MAX_TTL";
    private final String MAX_LENGTH = "MAX_LENGTH";
    private final String TIMEOUT = "TIMEOUT";
    private final String PERSISTENT_HTTP_CONNECTION_TIMEOUT = "PERSISTENT_HTTP_CONNECTION_TIMEOUT";
    private final String KEEP_ALIVE = "KEEP_ALIVE";
    private final String PORT = "PORT";
    private final String SPEED = "CONNECTION_SPEED";
    private final String UPLOAD_SPEED = "UPLOAD_SPEED";
    private final String SEARCH_LIMIT = "SEARCH_LIMIT";
    private final String CLIENT_ID = "CLIENT_ID";
    private final String MAX_INCOMING_CONNECTIONS = "MAX_INCOMING_CONNECTIONS";
    private final String SAVE_DIRECTORY = "DIRECTORY_FOR_SAVING_FILES";
    private final String INCOMPLETE_PURGE_TIME = "INCOMPLETE_PURGE_TIME";
    private final String DIRECTORIES = "DIRECTORIES_TO_SEARCH_FOR_FILES";
    private final String EXTENSIONS = "EXTENSIONS_TO_SEARCH_FOR";
    private final String BANNED_IPS = "BLACK_LISTED_IP_ADDRESSES";
    private final String ALLOWED_IPS = "WHITE_LISTED_IP_ADDRESSES";
    private final String BANNED_WORDS = "BANNED_WORDS";
    private final String FILTER_DUPLICATES = "FILTER_DUPLICATES";
    private final String FILTER_ADULT = "FILTER_ADULT";
    private final String FILTER_HTML = "FILTER_HTML";
    private final String FILTER_VBS = "FILTER_VBS";
    private final String FILTER_GREEDY_QUERIES = "FILTER_GREEDY_QUERIES";
    private final String FILTER_BEARSHARE_QUERIES = "FILTER_HIGHBIT_QUERIES";
    private final String PARALLEL_SEARCH = "PARALLEL_SEARCH";
    private final String MAX_SIM_DOWNLOAD = "MAX_SIM_DOWNLOAD";
    private final String PROMPT_EXE_DOWNLOAD = "PROMPT_EXE_DOWNLOAD";
    private final String MAX_UPLOADS = "MAX_UPLOADS";
    private final String SOFT_MAX_UPLOADS = "SOFT_MAX_UPLOADS";
    private final String CLEAR_UPLOAD = "CLEAR_UPLOAD";
    private final String CLEAR_DOWNLOAD = "CLEAR_DOWNLOAD";
    private final String CONNECT_STRING = "CONNECT_STRING";
    private final String CONNECT_OK_STRING = "CONNECT_OK_STRING";
    private final String CHECK_AGAIN = "CHECK_AGAIN";
    private final String BASIC_QUERY_INFO = "BASIC_QUERY_INFO";
    private final String ADVANCED_QUERY_INFO = "ADVANCED_QUERY_INFO";
    private final String FORCE_IP_ADDRESS = "FORCE_IP_ADDRESS";
    private final String FORCED_IP_ADDRESS_STRING = "FORCED_IP_ADDRESS_STRING";
    private final String FORCED_PORT = "FORCED_PORT";
    private final String FREELOADER_FILES = "FREELOADER_FILES";
    private final String FREELOADER_ALLOWED = "FREELOADER_ALLOWED";
    private final String UPLOADS_PER_PERSON = "UPLOADS_PER_PERSON";
    private final String UPLOAD_QUEUE_SIZE = "UPLOAD_QUEUE_SIZE";
    private final String LOCAL_IS_PRIVATE = "LOCAL_IS_PRIVATE";
    private final String AVERAGE_UPTIME = "AVERAGE_UPTIME";
    private final String TOTAL_UPTIME = "TOTAL_UPTIME";
    private final String SESSIONS = "SESSIONS";
    private final String LAST_SHUTDOWN_TIME = "LAST_SHUTDOWN_TIME";
    private final String FRACTIONAL_UPTIME = "FRACTIONAL_UPTIME";
    private final String INSTALLED = "INSTALLED";
    private final String APP_WIDTH = "APP_WIDTH";
    private final String APP_HEIGHT = "APP_HEIGHT";
    private final String RUN_ONCE = "RUN_ONCE";
    private final String WINDOW_X = "WINDOW_X";
    private final String WINDOW_Y = "WINDOW_Y";
    private final String MINIMIZE_TO_TRAY = "MINIMIZE_TO_TRAY";
    private final String SHUTDOWN_AFTER_TRANSFERS = "SHUTDOWN_AFTER_TRANSFERS";
    private final String CLASSPATH = "CLASSPATH";
    private final String JAR_NAME = "JAR_NAME";
    private final String CHAT_ENABLED = "CHAT_ENABLED";
    private final String GUESS_ENABLED = "GUESS_ENABLED";
    private final String PLAYER_ENABLED = "PLAYER_ENABLED";
    private final String BROWSER = "BROWSER";
    private final String MONITOR_VIEW_ENABLED = "MONITOR_VIEW_ENABLED";
    private final String CONNECTION_VIEW_ENABLED = "CONNECTION_VIEW_ENABLED";
    private final String LIBRARY_VIEW_ENABLED = "LIBRARY_VIEW_ENABLED";
    private final String SHOPPING_VIEW_ENABLED = "SHOPPING_VIEW_ENABLED";
    private final String LANGUAGE = "LANGUAGE";
    private final String COUNTRY = "COUNTRY";
    private final String LOCALE_VARIANT = "LOCALE_VARIANT";
    private final String MAX_SHIELDED_CLIENT_CONNECTIONS = "MAX_SHIELDED_CLIENT_CONNECTIONS";
    private final String MIN_SHIELDED_CLIENT_CONNECTIONS = "MIN_SHIELDED_CLIENT_CONNECTIONS";
    private final String ACCEPT_AUTHENTICATED_CONNECTIONS_ONLY = "ACCEPT_AUTHENTICATED_CONNECTIONS_ONLY";
    private final String COOKIES_FILE = "COOKIES_FILE";
    private final String SERVER = "SERVER";
    private final String MINIMUM_SEARCH_QUALITY = "MINIMUM_SEARCH_QUALITY";
    private final String MINIMUM_SEARCH_SPEED = "MINIMUM_SEARCH_SPEED";
    private final String EVER_ACCEPTED_INCOMING = "EVER_ACCEPTED_INCOMING";
    private final String MAX_UPSTREAM_BYTES_PER_SEC = "MAX_UPLOAD_BYTES_PER_SEC";
    private final String MAX_DOWNSTREAM_BYTES_PER_SEC = "MAX_DOWNLOAD_BYTES_PER_SEC";
    private final String EVER_SUPERNODE_CAPABLE = "EVER_SUPERNODE_CAPABLE";
    private final String DISABLE_SUPERNODE_MODE = "DISABLE_SUPERNODE_MODE";
    private final String FORCE_SUPERNODE_MODE = "FORCE_SUPERNODE_MODE";
    private final String CONNECT_ON_STARTUP = "CONNECT_ON_STARTUP";
    private final String LAST_EXPIRE_TIME = "LAST_EXPIRE_TIME";
    private final String AD_VERSION = "AD_VERSION";
    private final String SKIN_THEME = "SKIN_THEME";
    private volatile boolean _forceIPAddress;
    private volatile byte[] _forcedIPAddress;
    private volatile int _forcedPort;
    private volatile boolean _allowBroswer;
    private volatile byte _ttl;
    private volatile byte _softmaxttl;
    private volatile byte _maxttl;
    private volatile int _maxLength;
    private volatile int _timeout;
    private volatile int _persistentHTTPConnectionTimeout;
    private volatile String _hostList;
    private volatile int _keepAlive;
    private volatile int _port;
    private volatile int _connectionSpeed;
    private volatile int _uploadSpeed;
    private volatile byte _searchLimit;
    private volatile String _clientID;
    private volatile File _saveDirectory;
    private volatile File _incompleteDirectory;
    private volatile File[] _directories;
    private volatile int _incompletePurgeTime;
    private volatile String _extensions;
    private volatile String[] _bannedIps;
    private volatile String[] _allowedIps;
    private volatile String[] _bannedWords;
    private volatile boolean _filterDuplicates;
    private volatile boolean _filterAdult;
    private volatile boolean _filterVbs;
    private volatile boolean _filterHtml;
    private volatile boolean _filterGreedyQueries;
    private volatile boolean _filterBearShare;
    private volatile boolean _useQuickConnect;
    private volatile String[] _quickConnectHosts;
    private volatile int _parallelSearchMax;
    private volatile boolean _clearCompletedUpload;
    private volatile boolean _clearCompletedDownload;
    private volatile int _maxSimDownload;
    private volatile boolean _promptExeDownload;
    private volatile int _maxUploads;
    private volatile int _softMaxUploads;
    private volatile int _uploadsPerPerson;
    private volatile int _uploadQueueSize;
    private volatile boolean _localIsPrivate;
    private volatile boolean _chatEnabled;
    private volatile boolean _playerEnabled;
    private volatile boolean _monitorViewEnabled;
    private volatile boolean _connectionViewEnabled;
    private volatile boolean _libraryViewEnabled;
    private volatile boolean _shoppingViewEnabled;
    private volatile String _connectString;
    private volatile String _connectStringFirstWord;
    private volatile String _connectStringRemainder;
    private volatile String _connectOkString;
    private volatile int _basicQueryInfo;
    private volatile int _advancedQueryInfo;
    private volatile int _freeLoaderFiles;
    private volatile int _freeLoaderAllowed;
    private volatile long _averageUptime;
    private volatile long _totalUptime;
    private volatile int _sessions;
    private volatile boolean _installed;
    private volatile boolean _acceptedIncoming = false;
    private String _servantType;
    private volatile int _maxShieldedClientConnections;
    private volatile int _minShieldedClientConnections;
    private volatile boolean _server;
    private final Properties ND_PROPS = new Properties();
    private static final SettingsManager INSTANCE = new SettingsManager();
    private static final String STRING_DELIMETER = ";";

    public static SettingsManager instance() {
        return INSTANCE;
    }

    private SettingsManager() {
        Object object;
        Object object2;
        this.DEFAULT_CLIENT_ID = null;
        try {
            object2 = new FileInputStream(new File("nd.props"));
            try {
                this.ND_PROPS.load((InputStream)object2);
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object2 = new Properties();
        try {
            object = new FileInputStream(this.PROPS_FILE);
            try {
                ((Properties)object2).load((InputStream)object);
                this.loadDefaults();
                try {
                    ((FileInputStream)object).close();
                    this.validateFile((Properties)object2);
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException iOException) {
                this.loadDefaults();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.loadDefaults();
        }
        catch (SecurityException securityException) {
            this.loadDefaults();
        }
        try {
            object = this.getLanguage();
            String string = this.getCountry();
            String string2 = this.getLocaleVariant();
            Locale.setDefault(new Locale((String)object, string, string2));
        }
        catch (Exception exception) {
            System.out.println("Could not set new default locale.");
        }
        this.resetExpiredValues();
    }

    private void resetExpiredValues() {
        if (System.currentTimeMillis() - this.getLastExpireTime() < 1209600000L) {
            return;
        }
        this.setLastExpireTime(System.currentTimeMillis());
        this.setAverageUptime(1200L);
        this.setEverAcceptedIncoming(false);
        this.setMaxUpstreamBytesPerSec(0);
        this.setMaxDownstreamBytesPerSec(0);
        this.setEverSupernodeCapable(false);
    }

    private void validateFile(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (string.equals("TTL")) {
                    this.setTTL(Byte.parseByte(string2));
                    continue;
                }
                if (string.equals("ALLOW_BROWSER")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setAllowBrowser(bl);
                    continue;
                }
                if (string.equals("SOFT_MAX_TTL")) {
                    this.setSoftMaxTTL(Byte.parseByte(string2));
                    continue;
                }
                if (string.equals("MAX_TTL")) {
                    this.setMaxTTL(Byte.parseByte(string2));
                    continue;
                }
                if (string.equals("MAX_LENGTH")) {
                    this.setMaxLength(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("PARALLEL_SEARCH")) {
                    this.setParallelSearchMax(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("MAX_SIM_DOWNLOAD")) {
                    this.setMaxSimDownload(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("PROMPT_EXE_DOWNLOAD")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setPromptExeDownload(bl);
                    continue;
                }
                if (string.equals("MAX_UPLOADS")) {
                    this.setMaxUploads(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("SOFT_MAX_UPLOADS")) {
                    this.setSoftMaxUploads(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("CLEAR_DOWNLOAD")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setClearCompletedDownload(bl);
                    continue;
                }
                if (string.equals("CLEAR_UPLOAD")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setClearCompletedUpload(bl);
                    continue;
                }
                if (string.equals("TIMEOUT")) {
                    this.setTimeout(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("PERSISTENT_HTTP_CONNECTION_TIMEOUT")) {
                    this.setPersistentHTTPConnectionTimeout(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("UPLOADS_PER_PERSON")) {
                    this.setUploadsPerPerson(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("UPLOAD_QUEUE_SIZE")) {
                    this.setUploadQueueSize(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("LOCAL_IS_PRIVATE")) {
                    this.setLocalIsPrivate(Boolean.valueOf(string2));
                    continue;
                }
                if (string.equals("KEEP_ALIVE")) {
                    this.setKeepAlive(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("PORT")) {
                    this.setPort(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("CONNECTION_SPEED")) {
                    this.setConnectionSpeed(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("UPLOAD_SPEED")) {
                    this.setUploadSpeed(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("SEARCH_LIMIT")) {
                    this.setSearchLimit(Byte.parseByte(string2));
                    continue;
                }
                if (string.equals("CHAT_ENABLED")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setChatEnabled(bl);
                    continue;
                }
                if (string.equals("GUESS_ENABLED")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setGuessEnabled(bl);
                    continue;
                }
                if (string.equals("PLAYER_ENABLED")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setPlayerEnabled(bl);
                    continue;
                }
                if (string.equals("BROWSER")) {
                    this.setBrowser(string2);
                    continue;
                }
                if (string.equals("MONITOR_VIEW_ENABLED")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setMonitorViewEnabled(bl);
                    continue;
                }
                if (string.equals("CONNECTION_VIEW_ENABLED")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setConnectionViewEnabled(bl);
                    continue;
                }
                if (string.equals("LIBRARY_VIEW_ENABLED")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setLibraryViewEnabled(bl);
                    continue;
                }
                if (string.equals("SHOPPING_VIEW_ENABLED")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setShoppingViewEnabled(bl);
                    continue;
                }
                if (string.equals("CLIENT_ID")) {
                    this.setClientID(string2);
                    continue;
                }
                if (string.equals("DIRECTORY_FOR_SAVING_FILES")) {
                    try {
                        this.setSaveDirectory(new File(string2));
                    }
                    catch (IOException iOException) {
                        try {
                            this.setSaveDirectory(this.DEFAULT_SAVE_DIRECTORY);
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        iOException.printStackTrace();
                    }
                    continue;
                }
                if (string.equals("INCOMPLETE_PURGE_TIME")) {
                    this.setIncompletePurgeTime(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("DIRECTORIES_TO_SEARCH_FOR_FILES")) {
                    this.setDirectories(string2);
                    continue;
                }
                if (string.equals("EXTENSIONS_TO_SEARCH_FOR")) {
                    this.setExtensions(string2);
                    continue;
                }
                if (string.equals("CHECK_AGAIN")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setCheckAgain(bl);
                    continue;
                }
                if (string.equals("BLACK_LISTED_IP_ADDRESSES")) {
                    this.setBannedIps(SettingsManager.decode(string2));
                    continue;
                }
                if (string.equals("WHITE_LISTED_IP_ADDRESSES")) {
                    this.setAllowedIps(SettingsManager.decode(string2));
                    continue;
                }
                if (string.equals("BANNED_WORDS")) {
                    this.setBannedWords(SettingsManager.decode(string2));
                    continue;
                }
                if (string.equals("FILTER_ADULT")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setFilterAdult(bl);
                    continue;
                }
                if (string.equals("FILTER_DUPLICATES")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setFilterDuplicates(bl);
                    continue;
                }
                if (string.equals("FILTER_HTML")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setFilterHtml(bl);
                    continue;
                }
                if (string.equals("FILTER_VBS")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setFilterVbs(bl);
                    continue;
                }
                if (string.equals("FILTER_GREEDY_QUERIES")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setFilterGreedyQueries(bl);
                    continue;
                }
                if (string.equals("FILTER_HIGHBIT_QUERIES")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setFilterBearShareQueries(bl);
                    continue;
                }
                if (string.equals("CONNECT_STRING")) {
                    this.setConnectString(string2);
                    continue;
                }
                if (string.equals("CONNECT_OK_STRING")) {
                    this.setConnectOkString(string2);
                    continue;
                }
                if (string.equals("BASIC_QUERY_INFO")) {
                    this.setBasicInfoForQuery(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("ADVANCED_QUERY_INFO")) {
                    this.setAdvancedInfoForQuery(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("FORCE_IP_ADDRESS")) {
                    boolean bl;
                    if (string2.equals("true")) {
                        bl = true;
                    } else {
                        if (!string2.equals("false")) break;
                        bl = false;
                    }
                    this.setForceIPAddress(bl);
                    continue;
                }
                if (string.equals("FORCED_IP_ADDRESS_STRING")) {
                    this.setForcedIPAddressString(string2);
                    continue;
                }
                if (string.equals("FORCED_PORT")) {
                    this.setForcedPort(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("FREELOADER_FILES")) {
                    this.setFreeloaderFiles(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("FREELOADER_ALLOWED")) {
                    this.setFreeloaderAllowed(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("SESSIONS")) {
                    this.setSessions(Integer.parseInt(string2) + 1);
                    continue;
                }
                if (string.equals("AVERAGE_UPTIME")) {
                    this.setAverageUptime(Long.parseLong(string2));
                    continue;
                }
                if (string.equals("TOTAL_UPTIME")) {
                    this.setTotalUptime(Long.parseLong(string2));
                    continue;
                }
                if (string.equals("LAST_SHUTDOWN_TIME")) {
                    this.setLastShutdownTime(Long.parseLong(string2));
                    continue;
                }
                if (string.equals("FRACTIONAL_UPTIME")) {
                    this.setFractionalUptime(Float.valueOf(string2).floatValue());
                    continue;
                }
                if (string.equals("SERVANT_TYPE")) {
                    this.setServantType(string2);
                    continue;
                }
                if (string.equals("INSTALLED")) {
                    Boolean bl = new Boolean(string2);
                    this.setInstalled(bl);
                    continue;
                }
                if (string.equals("APP_WIDTH")) {
                    this.setAppWidth(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("APP_HEIGHT")) {
                    this.setAppHeight(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("RUN_ONCE")) {
                    Boolean bl = new Boolean(string2);
                    this.setRunOnce(bl);
                    continue;
                }
                if (string.equals("WINDOW_X")) {
                    this.setWindowX(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("WINDOW_Y")) {
                    this.setWindowY(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("MINIMIZE_TO_TRAY")) {
                    Boolean bl = new Boolean(string2);
                    this.setMinimizeToTray(bl);
                    continue;
                }
                if (string.equals("SHUTDOWN_AFTER_TRANSFERS")) {
                    Boolean bl = new Boolean(string2);
                    this.setShutdownAfterTransfers(bl);
                    continue;
                }
                if (string.equals("LANGUAGE")) {
                    this.setLanguage(string2);
                    continue;
                }
                if (string.equals("COUNTRY")) {
                    this.setCountry(string2);
                    continue;
                }
                if (string.equals("LOCALE_VARIANT")) {
                    this.setLocaleVariant(string2);
                    continue;
                }
                if (string.equals("MINIMUM_SEARCH_QUALITY")) {
                    this.setMinimumSearchQuality(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("MINIMUM_SEARCH_SPEED")) {
                    this.setMinimumSearchSpeed(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("EVER_ACCEPTED_INCOMING")) {
                    Boolean bl = new Boolean(string2);
                    this.setEverAcceptedIncoming(bl);
                    continue;
                }
                if (string.equals("MAX_UPLOAD_BYTES_PER_SEC")) {
                    this.setMaxUpstreamBytesPerSec(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("MAX_DOWNLOAD_BYTES_PER_SEC")) {
                    this.setMaxDownstreamBytesPerSec(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("EVER_SUPERNODE_CAPABLE")) {
                    Boolean bl = new Boolean(string2);
                    this.setEverSupernodeCapable(bl);
                    continue;
                }
                if (string.equals("DISABLE_SUPERNODE_MODE")) {
                    Boolean bl = new Boolean(string2);
                    this.setDisableSupernodeMode(bl);
                    continue;
                }
                if (string.equals("FORCE_SUPERNODE_MODE")) {
                    Boolean bl = new Boolean(string2);
                    this.setForceSupernodeMode(bl);
                    continue;
                }
                if (string.equals("MAX_SHIELDED_CLIENT_CONNECTIONS")) {
                    this.setMaxShieldedClientConnections(new Integer(string2));
                    continue;
                }
                if (string.equals("MIN_SHIELDED_CLIENT_CONNECTIONS")) {
                    this.setMinShieldedClientConnections(new Integer(string2));
                    continue;
                }
                if (string.equals("CONNECT_ON_STARTUP")) {
                    this.setConnectOnStartup(new Boolean(string2));
                    continue;
                }
                if (string.equals("LAST_EXPIRE_TIME")) {
                    this.setLastExpireTime(new Long(string2));
                    continue;
                }
                if (string.equals("ACCEPT_AUTHENTICATED_CONNECTIONS_ONLY")) {
                    this.setAcceptAuthenticatedConnectionsOnly(new Boolean(string2));
                    continue;
                }
                if (string.equals("COOKIES_FILE")) {
                    this.setCookiesFile(string2);
                    continue;
                }
                if (string.equals("SERVER")) {
                    this.setServer(new Boolean(string2));
                    continue;
                }
                if (string.equals("AD_VERSION")) {
                    this.setAdVersion(string2);
                    continue;
                }
                if (string.equals("JAR_NAME")) {
                    this.setJarName(string2);
                    continue;
                }
                if (string.equals("CLASSPATH")) {
                    this.setClasspath(string2);
                    continue;
                }
                if (!string.equals("SKIN_THEME")) continue;
                this.setSkinTheme(new File(string2));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void loadDefaults() {
        this.setAllowBrowser(false);
        this.setMaxTTL((byte)16);
        this.setSoftMaxTTL((byte)6);
        this.setTTL((byte)6);
        this.setMaxLength(65536);
        this.setTimeout(8000);
        this.setPersistentHTTPConnectionTimeout(15000);
        this.setKeepAlive(4);
        this.setPort(6346);
        this.setConnectionSpeed(56);
        this.setUploadSpeed(100);
        this.setSearchLimit((byte)64);
        this.setClientID(new GUID(Message.makeGuid()).toHexString());
        this.setBannedIps(this.DEFAULT_BANNED_IPS);
        this.setAllowedIps(this.DEFAULT_ALLOWED_IPS);
        this.setBannedWords(this.DEFAULT_BANNED_WORDS);
        this.setFilterAdult(false);
        this.setFilterDuplicates(true);
        this.setFilterVbs(true);
        this.setFilterHtml(false);
        this.setFilterGreedyQueries(true);
        this.setExtensions("asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso");
        this.setBannedIps(this.DEFAULT_BANNED_IPS);
        this.setBannedWords(this.DEFAULT_BANNED_WORDS);
        this.setFilterAdult(false);
        this.setFilterDuplicates(true);
        this.setFilterVbs(true);
        this.setFilterHtml(false);
        this.setFilterGreedyQueries(true);
        this.setFilterBearShareQueries(true);
        this.setParallelSearchMax(5);
        this.setClearCompletedUpload(true);
        this.setClearCompletedDownload(false);
        this.setMaxSimDownload(4);
        this.setPromptExeDownload(true);
        this.setMaxUploads(20);
        this.setSoftMaxUploads(5);
        this.setConnectString(DEFAULT_CONNECT_STRING);
        this.setConnectOkString("GNUTELLA OK");
        this.setCheckAgain(true);
        this.setBasicInfoForQuery(1000);
        this.setAdvancedInfoForQuery(50);
        this.setForceIPAddress(false);
        this.setForcedIPAddressString("0.0.0.0");
        this.setForcedPort(6346);
        this.setFreeloaderFiles(1);
        this.setFreeloaderAllowed(100);
        this.setUploadsPerPerson(3);
        this.setUploadQueueSize(10);
        this.setLocalIsPrivate(true);
        this.setAverageUptime(1200L);
        this.setTotalUptime(1200L);
        this.setLastShutdownTime(0L);
        this.setFractionalUptime(0.0f);
        this.setServantType("XML_CLIENT");
        this.setInstalled(false);
        this.setRunOnce(false);
        this.setMinimizeToTray(this.DEFAULT_MINIMIZE_TO_TRAY);
        this.setShutdownAfterTransfers(this.DEFAULT_SHUTDOWN_AFTER_TRANSFERS);
        this.setAppWidth(840);
        this.setAppHeight(600);
        this.setChatEnabled(true);
        this.setGuessEnabled(false);
        this.setPlayerEnabled(true);
        this.setBrowser(this.getDefaultBrowser());
        this.setMonitorViewEnabled(true);
        this.setConnectionViewEnabled(false);
        this.setLibraryViewEnabled(true);
        this.setShoppingViewEnabled(true);
        this.setLanguage("");
        this.setCountry("");
        this.setLocaleVariant("");
        this.setMinimumSearchQuality(0);
        this.setMinimumSearchSpeed(0);
        this.setEverAcceptedIncoming(false);
        this.setMaxUpstreamBytesPerSec(0);
        this.setMaxDownstreamBytesPerSec(0);
        this.setEverSupernodeCapable(false);
        this.setDisableSupernodeMode(false);
        this.setForceSupernodeMode(false);
        this.setMaxShieldedClientConnections(75);
        this.setMinShieldedClientConnections(this.DEFAULT_MIN_SHIELDED_CLIENT_CONNECTIONS);
        this.setAcceptAuthenticatedConnectionsOnly(false);
        this.setCookiesFile(this.DEFAULT_COOKIES_FILE);
        this.setServer(false);
        this.setSessions(1);
        this.setAverageUptime(1200L);
        this.setTotalUptime(1200L);
        this.setConnectOnStartup(true);
        this.setIncompletePurgeTime(7);
        this.setLastExpireTime(0L);
        this.setAdVersion("1.0");
        this.setJarName("LimeWire.jar");
        this.setClasspath("LimeWire.jar");
        this.setSkinTheme(this.DEFAULT_SKIN_THEME);
    }

    public boolean getAllowBrowser() {
        return this._allowBroswer;
    }

    public byte getTTL() {
        return this._ttl;
    }

    public byte getSoftMaxTTL() {
        return this._softmaxttl;
    }

    public byte getMaxTTL() {
        return this._maxttl;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public int getPersistentHTTPConnectionTimeout() {
        return this._persistentHTTPConnectionTimeout;
    }

    public String getHostList() {
        return new File(CommonUtils.getUserSettingsDir(), "gnutella.net").getAbsolutePath();
    }

    public int getKeepAlive() {
        return this._keepAlive;
    }

    public int getPort() {
        return this._port;
    }

    public int getConnectionSpeed() {
        return this._connectionSpeed;
    }

    public int getUploadSpeed() {
        return this._uploadSpeed;
    }

    public byte getSearchLimit() {
        return this._searchLimit;
    }

    public String getClientID() {
        return this._clientID;
    }

    public int getUploadsPerPerson() {
        return this._uploadsPerPerson;
    }

    public int getUploadQueueSize() {
        return this._uploadQueueSize;
    }

    public boolean getLocalIsPrivate() {
        return this._localIsPrivate;
    }

    public File getSaveDirectory() throws FileNotFoundException {
        if (this._saveDirectory == null) {
            throw new FileNotFoundException();
        }
        return this._saveDirectory;
    }

    public File getSaveDefault() {
        return this.DEFAULT_SAVE_DIRECTORY;
    }

    public File getSkinTheme() {
        return this.getFileValue("SKIN_THEME");
    }

    public boolean getChatEnabled() {
        return this._chatEnabled;
    }

    public boolean getGuessEnabled() {
        return this.getBooleanValue("GUESS_ENABLED");
    }

    public boolean getPlayerEnabled() {
        if (CommonUtils.isMacClassic()) {
            return false;
        }
        return this._playerEnabled;
    }

    public String getBrowser() {
        return this.getStringValue("BROWSER");
    }

    public String getDefaultBrowser() {
        return "netscape";
    }

    public boolean getMonitorViewEnabled() {
        return this._monitorViewEnabled;
    }

    public boolean getConnectionViewEnabled() {
        return this._connectionViewEnabled;
    }

    public boolean getLibraryViewEnabled() {
        return this._libraryViewEnabled;
    }

    public boolean getShoppingViewEnabled() {
        return this._shoppingViewEnabled;
    }

    public File getIncompleteDirectory() throws FileNotFoundException {
        if (this._incompleteDirectory == null) {
            throw new FileNotFoundException();
        }
        return this._incompleteDirectory;
    }

    public int getIncompletePurgeTime() {
        return this._incompletePurgeTime;
    }

    public File[] getDirectories() {
        return this._directories;
    }

    public File[] getDirectoriesWithIncompleteAsArray() {
        int n = this._directories.length + 1;
        File[] fileArray = new File[n];
        File file = null;
        try {
            fileArray[this._directories.length] = file = this.getIncompleteDirectory();
            int n2 = 0;
            while (n2 < this._directories.length) {
                fileArray[n2] = this._directories[n2];
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this._directories;
        }
        return fileArray;
    }

    public File getDownloadSnapshotFile() {
        File file = null;
        try {
            file = this.getIncompleteDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return new File(file, "downloads.dat");
    }

    public String getExtensions() {
        return this._extensions;
    }

    public String getDefaultExtensions() {
        return "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso";
    }

    public String[] getBannedIps() {
        return this._bannedIps;
    }

    public String[] getAllowedIps() {
        return this._allowedIps;
    }

    public String[] getBannedWords() {
        return this._bannedWords;
    }

    public boolean getFilterAdult() {
        return this._filterAdult;
    }

    public boolean getFilterDuplicates() {
        return this._filterDuplicates;
    }

    public boolean getFilterHtml() {
        return this._filterHtml;
    }

    public boolean getFilterVbs() {
        return this._filterVbs;
    }

    public boolean getFilterGreedyQueries() {
        return this._filterGreedyQueries;
    }

    public boolean getFilterBearShareQueries() {
        return this._filterBearShare;
    }

    public boolean getUseQuickConnect() {
        return true;
    }

    public String[] getQuickConnectHosts() {
        return this._quickConnectHosts;
    }

    public int getParallelSearchMax() {
        return this._parallelSearchMax;
    }

    public int getMaxSimDownload() {
        return this._maxSimDownload;
    }

    public boolean getPromptExeDownload() {
        return this._promptExeDownload;
    }

    public int getMaxUploads() {
        return this._maxUploads;
    }

    public int getSoftMaxUploads() {
        return this._softMaxUploads;
    }

    public boolean getClearCompletedUpload() {
        return this._clearCompletedUpload;
    }

    public boolean getClearCompletedDownload() {
        return this._clearCompletedDownload;
    }

    public String getConnectString() {
        return this._connectString;
    }

    public String getConnectStringFirstWord() {
        return this._connectStringFirstWord;
    }

    public String getConnectStringRemainder() {
        return this._connectStringRemainder;
    }

    public String getConnectOkString() {
        return this._connectOkString;
    }

    public Properties getNDProps() {
        return this.ND_PROPS;
    }

    public int getBasicInfoSizeForQuery() {
        return this._basicQueryInfo;
    }

    public int getAdvancedInfoSizeForQuery() {
        return this._advancedQueryInfo;
    }

    public boolean getForceIPAddress() {
        return this._forceIPAddress;
    }

    public byte[] getForcedIPAddress() {
        return this._forcedIPAddress;
    }

    public String getForcedIPAddressString() {
        return Message.ip2string(this._forcedIPAddress);
    }

    public int getForcedPort() {
        return this._forcedPort;
    }

    public boolean getCheckAgain() {
        Boolean bl = new Boolean(PROPS.getProperty("CHECK_AGAIN"));
        return bl;
    }

    public int getFreeloaderFiles() {
        return this._freeLoaderFiles;
    }

    public int getFreeloaderAllowed() {
        return this._freeLoaderAllowed;
    }

    public long getAverageUptime() {
        return this._averageUptime;
    }

    public long getTotalUptime() {
        return this._totalUptime;
    }

    public int getSessions() {
        return this._sessions;
    }

    public float getFractionalUptime() {
        return this.getFloatValue("FRACTIONAL_UPTIME");
    }

    public long getLastShutdownTime() {
        return this.getLongValue("LAST_SHUTDOWN_TIME");
    }

    public boolean getInstalled() {
        return this._installed;
    }

    public int getAppWidth() {
        return Integer.parseInt(PROPS.getProperty("APP_WIDTH"));
    }

    public int getAppHeight() {
        return Integer.parseInt(PROPS.getProperty("APP_HEIGHT"));
    }

    public String getServantType() {
        return this._servantType;
    }

    public boolean getRunOnce() {
        Boolean bl = Boolean.valueOf(PROPS.getProperty("RUN_ONCE"));
        return bl;
    }

    public int getWindowX() {
        return Integer.parseInt(PROPS.getProperty("WINDOW_X"));
    }

    public int getWindowY() {
        return Integer.parseInt(PROPS.getProperty("WINDOW_Y"));
    }

    public boolean getMinimizeToTray() {
        return this.getBooleanValue("MINIMIZE_TO_TRAY");
    }

    public boolean getShutdownAfterTransfers() {
        Boolean bl = new Boolean(PROPS.getProperty("SHUTDOWN_AFTER_TRANSFERS"));
        return bl;
    }

    public boolean getAcceptedIncoming() {
        return this._acceptedIncoming;
    }

    public boolean getEverAcceptedIncoming() {
        return this.getBooleanValue("EVER_ACCEPTED_INCOMING");
    }

    public String getLanguage() {
        return PROPS.getProperty("LANGUAGE");
    }

    public String getCountry() {
        return PROPS.getProperty("COUNTRY");
    }

    public String getLocaleVariant() {
        return PROPS.getProperty("LOCALE_VARIANT");
    }

    public int getMinimumSearchQuality() {
        return this.getIntValue("MINIMUM_SEARCH_QUALITY");
    }

    public int getMinimumSearchSpeed() {
        return this.getIntValue("MINIMUM_SEARCH_SPEED");
    }

    public int getMaxUpstreamBytesPerSec() {
        return this.getIntValue("MAX_UPLOAD_BYTES_PER_SEC");
    }

    public int getMaxDownstreamBytesPerSec() {
        return this.getIntValue("MAX_DOWNLOAD_BYTES_PER_SEC");
    }

    public int getMaxShieldedClientConnections() {
        return this._maxShieldedClientConnections;
    }

    public int getMinShieldedClientConnections() {
        return this._minShieldedClientConnections;
    }

    public boolean getEverSupernodeCapable() {
        return this.getBooleanValue("EVER_SUPERNODE_CAPABLE");
    }

    public boolean getDisableSupernodeMode() {
        return this.getBooleanValue("DISABLE_SUPERNODE_MODE");
    }

    public boolean getForceSupernodeMode() {
        return this.getBooleanValue("FORCE_SUPERNODE_MODE");
    }

    public boolean getConnectOnStartup() {
        return this.getBooleanValue("CONNECT_ON_STARTUP");
    }

    public long getLastExpireTime() {
        return this.getLongValue("LAST_EXPIRE_TIME");
    }

    public boolean acceptAuthenticatedConnectionsOnly() {
        return Boolean.valueOf(PROPS.getProperty("ACCEPT_AUTHENTICATED_CONNECTIONS_ONLY"));
    }

    public String getCookiesFile() {
        return PROPS.getProperty("COOKIES_FILE");
    }

    public boolean isServer() {
        return this._server;
    }

    public String getAdVersion() {
        return this.getStringValue("AD_VERSION");
    }

    public void updateUptime(int n) {
        this._totalUptime += (long)n;
        this._averageUptime = this._totalUptime / (long)this._sessions;
        this.setTotalUptime(this._totalUptime);
        this.setAverageUptime(this._averageUptime);
    }

    private void setSessions(int n) {
        this._sessions = n;
        ((Hashtable)PROPS).put("SESSIONS", Integer.toString(this._sessions));
    }

    private void setAverageUptime(long l) {
        this._averageUptime = l;
        ((Hashtable)PROPS).put("AVERAGE_UPTIME", Long.toString(l));
    }

    private void setTotalUptime(long l) {
        this._totalUptime = l;
        String string = Long.toString(this._totalUptime);
        ((Hashtable)PROPS).put("TOTAL_UPTIME", string);
    }

    public void setFractionalUptime(float f) {
        this.setFloatValue("FRACTIONAL_UPTIME", f);
    }

    public void setLastShutdownTime(long l) {
        this.setLongValue("LAST_SHUTDOWN_TIME", l);
    }

    public void setMaxLength(int n) {
        this._maxLength = n;
        String string = Integer.toString(this._maxLength);
        ((Hashtable)PROPS).put("MAX_LENGTH", string);
    }

    public void setTimeout(int n) {
        this._timeout = n;
        String string = Integer.toString(this._timeout);
        ((Hashtable)PROPS).put("TIMEOUT", string);
    }

    public void setPersistentHTTPConnectionTimeout(int n) {
        this._persistentHTTPConnectionTimeout = n;
        String string = Integer.toString(this._persistentHTTPConnectionTimeout);
        ((Hashtable)PROPS).put("PERSISTENT_HTTP_CONNECTION_TIMEOUT", string);
    }

    public void setKeepAlive(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this._keepAlive = n;
        String string = Integer.toString(this._keepAlive);
        ((Hashtable)PROPS).put("KEEP_ALIVE", string);
    }

    public int maxConnections() {
        int n = this.getConnectionSpeed();
        if (n <= 56) {
            return 3;
        }
        if (n <= 350) {
            return 6;
        }
        if (n <= 1000) {
            return 10;
        }
        return 12;
    }

    public void setSearchLimit(byte by) {
        if (by < 0 || by > 10000) {
            throw new IllegalArgumentException();
        }
        this._searchLimit = by;
        String string = Byte.toString(this._searchLimit);
        ((Hashtable)PROPS).put("SEARCH_LIMIT", string);
    }

    public void setClientID(String string) {
        this._clientID = string;
        ((Hashtable)PROPS).put("CLIENT_ID", this._clientID);
    }

    public void setMaxTTL(byte by) throws IllegalArgumentException {
        if (by < 0 || by > 50) {
            throw new IllegalArgumentException();
        }
        this._maxttl = by;
        String string = Byte.toString(this._maxttl);
        ((Hashtable)PROPS).put("MAX_TTL", string);
    }

    public void setBasicInfoForQuery(int n) {
        this._basicQueryInfo = n;
        String string = Integer.toString(n);
        ((Hashtable)PROPS).put("BASIC_QUERY_INFO", string);
    }

    public void setUploadsPerPerson(int n) {
        this._uploadsPerPerson = n;
        String string = Integer.toString(n);
        ((Hashtable)PROPS).put("UPLOADS_PER_PERSON", string);
    }

    public void setUploadQueueSize(int n) {
        this._uploadQueueSize = n;
        String string = Integer.toString(n);
        ((Hashtable)PROPS).put("UPLOAD_QUEUE_SIZE", string);
    }

    public void setLocalIsPrivate(boolean bl) {
        this._localIsPrivate = bl;
        String string = new Boolean(bl).toString();
        ((Hashtable)PROPS).put("LOCAL_IS_PRIVATE", string);
    }

    public void setAdvancedInfoForQuery(int n) {
        this._advancedQueryInfo = n;
        String string = Integer.toString(n);
        ((Hashtable)PROPS).put("ADVANCED_QUERY_INFO", string);
    }

    public void setSaveDirectory(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException();
        }
        String string = file.getParent();
        File file2 = new File(string, "Incomplete");
        if (!file2.isDirectory() && !file2.mkdirs()) {
            throw new IOException();
        }
        if (!(file.canRead() && file.canWrite() && file2.canRead() && file2.canWrite())) {
            throw new IOException();
        }
        this._saveDirectory = file;
        this._incompleteDirectory = file2;
        this.setStringValue("DIRECTORY_FOR_SAVING_FILES", file.getAbsolutePath());
    }

    private void setDirectories(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, STRING_DELIMETER);
        int n = stringTokenizer.countTokens();
        File[] fileArray = new File[n];
        int n2 = 0;
        while (n2 < n) {
            fileArray[n2] = new File(stringTokenizer.nextToken());
            ++n2;
        }
        this.setDirectories(fileArray);
    }

    public void setIncompletePurgeTime(int n) {
        this._incompletePurgeTime = n;
        ((Hashtable)PROPS).put("INCOMPLETE_PURGE_TIME", Integer.toString(n));
    }

    public void setDirectories(File[] fileArray) {
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                hashMap.put(fileArray[n], "");
            }
            ++n;
        }
        Set set = hashMap.keySet();
        Object[] objectArray = set.toArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != null) {
                stringBuffer.append(objectArray[n2]);
                stringBuffer.append(';');
            }
            ++n2;
        }
        this._directories = new File[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            this._directories[n3] = (File)objectArray[n3];
            ++n3;
        }
        ((Hashtable)PROPS).put("DIRECTORIES_TO_SEARCH_FOR_FILES", stringBuffer.toString());
    }

    public void addDirectory(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException();
        }
        if (this._directories == null) {
            this._directories = new File[1];
            this._directories[0] = file;
        } else {
            int n = this._directories.length + 1;
            File[] fileArray = new File[n];
            int n2 = 0;
            while (n2 < this._directories.length) {
                fileArray[n2] = this._directories[n2];
                ++n2;
            }
            fileArray[this._directories.length] = file;
            this.setDirectories(fileArray);
        }
    }

    public void setExtensions(String string) {
        this._extensions = string;
        ((Hashtable)PROPS).put("EXTENSIONS_TO_SEARCH_FOR", string);
    }

    public void setTTL(byte by) {
        if (by < 1 || by > 14) {
            throw new IllegalArgumentException();
        }
        this._ttl = by;
        String string = Byte.toString(this._ttl);
        ((Hashtable)PROPS).put("TTL", string);
    }

    public void setSoftMaxTTL(byte by) {
        if (by < 0 || by > 14) {
            throw new IllegalArgumentException();
        }
        this._softmaxttl = by;
        String string = Byte.toString(by);
        ((Hashtable)PROPS).put("SOFT_MAX_TTL", string);
    }

    public void setPort(int n) {
        if (n > 65536 || n < 0) {
            throw new IllegalArgumentException();
        }
        this._port = n;
        String string = Integer.toString(this._port);
        ((Hashtable)PROPS).put("PORT", string);
    }

    public void setConnectionSpeed(int n) {
        if (n < 0 || n > 20000) {
            throw new IllegalArgumentException();
        }
        this._connectionSpeed = n;
        String string = Integer.toString(this._connectionSpeed);
        ((Hashtable)PROPS).put("CONNECTION_SPEED", string);
    }

    public void setUploadSpeed(int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException();
        }
        this._uploadSpeed = n;
        String string = Integer.toString(this._uploadSpeed);
        ((Hashtable)PROPS).put("UPLOAD_SPEED", string);
    }

    public void setConnectString(String string) throws IllegalArgumentException {
        int n = string.indexOf(" ");
        if (string.length() < 1) {
            throw new IllegalArgumentException();
        }
        if (n == -1 || n == string.length() - 1) {
            throw new IllegalArgumentException();
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = string2.toUpperCase();
        if (string4.equals("GIV") || string4.equals("GET") || string4.equals("PUT") || string4.equals("POST") || string4.equals("HEAD") || string4.equals("DELETE")) {
            throw new IllegalArgumentException();
        }
        this._connectString = string;
        this._connectStringFirstWord = string2;
        this._connectStringRemainder = string3;
        ((Hashtable)PROPS).put("CONNECT_STRING", string);
    }

    public void setConnectOkString(String string) throws IllegalArgumentException {
        if (string.length() < 1) {
            throw new IllegalArgumentException();
        }
        this._connectOkString = string;
        ((Hashtable)PROPS).put("CONNECT_OK_STRING", string);
    }

    public void setParallelSearchMax(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this._parallelSearchMax = n;
        String string = String.valueOf(n);
        ((Hashtable)PROPS).put("PARALLEL_SEARCH", string);
    }

    public void setPromptExeDownload(boolean bl) {
        this._promptExeDownload = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("PROMPT_EXE_DOWNLOAD", string);
    }

    public void setChatEnabled(boolean bl) {
        this._chatEnabled = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("CHAT_ENABLED", string);
    }

    public void setGuessEnabled(boolean bl) {
        this.setBooleanValue("GUESS_ENABLED", bl);
    }

    public void setPlayerEnabled(boolean bl) {
        this._playerEnabled = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("PLAYER_ENABLED", string);
    }

    public void setBrowser(String string) {
        ((Hashtable)PROPS).put("BROWSER", string);
    }

    public void setMonitorViewEnabled(boolean bl) {
        this._monitorViewEnabled = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("MONITOR_VIEW_ENABLED", string);
    }

    public void setConnectionViewEnabled(boolean bl) {
        this._connectionViewEnabled = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("CONNECTION_VIEW_ENABLED", string);
    }

    public void setLibraryViewEnabled(boolean bl) {
        this._libraryViewEnabled = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("LIBRARY_VIEW_ENABLED", string);
    }

    public void setShoppingViewEnabled(boolean bl) {
        this._shoppingViewEnabled = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("SHOPPING_VIEW_ENABLED", string);
    }

    public void setMaxSimDownload(int n) {
        this._maxSimDownload = n;
        String string = String.valueOf(n);
        ((Hashtable)PROPS).put("MAX_SIM_DOWNLOAD", string);
    }

    public void setMaxUploads(int n) {
        this._maxUploads = n;
        String string = String.valueOf(n);
        ((Hashtable)PROPS).put("MAX_UPLOADS", string);
    }

    public void setSoftMaxUploads(int n) {
        this._softMaxUploads = n;
        String string = String.valueOf(n);
        ((Hashtable)PROPS).put("SOFT_MAX_UPLOADS", string);
    }

    public void setClearCompletedUpload(boolean bl) {
        this._clearCompletedUpload = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("CLEAR_UPLOAD", string);
    }

    public void setClearCompletedDownload(boolean bl) {
        this._clearCompletedDownload = bl;
        ((Hashtable)PROPS).put("CLEAR_DOWNLOAD", String.valueOf(bl));
    }

    public void setForceIPAddress(boolean bl) {
        String string = bl ? "true" : "false";
        this._forceIPAddress = bl;
        ((Hashtable)PROPS).put("FORCE_IP_ADDRESS", string);
    }

    public void setAllowBrowser(boolean bl) {
        String string = bl ? "true" : "false";
        this._allowBroswer = bl;
        ((Hashtable)PROPS).put("ALLOW_BROWSER", string);
    }

    public void setForcedIPAddressString(String string) throws IllegalArgumentException {
        try {
            if (string.equals("0.0.0.0")) {
                this._forcedIPAddress = new byte[4];
                this._forcedIPAddress[0] = 0;
                this._forcedIPAddress[1] = 0;
                this._forcedIPAddress[2] = 0;
                this._forcedIPAddress[3] = 0;
            } else {
                InetAddress inetAddress = InetAddress.getByName(string);
                this._forcedIPAddress = inetAddress.getAddress();
            }
            ((Hashtable)PROPS).put("FORCED_IP_ADDRESS_STRING", string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException();
        }
    }

    public void setForcedPort(int n) {
        if (n > 65536 || n < 1) {
            throw new IllegalArgumentException();
        }
        this._forcedPort = n;
        String string = Integer.toString(this._forcedPort);
        ((Hashtable)PROPS).put("FORCED_PORT", string);
    }

    public void setInstalled(boolean bl) {
        this._installed = bl;
        String string = String.valueOf(bl);
        ((Hashtable)PROPS).put("INSTALLED", string);
    }

    public void setBannedIps(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        this._bannedIps = stringArray;
        ((Hashtable)PROPS).put("BLACK_LISTED_IP_ADDRESSES", SettingsManager.encode(stringArray));
    }

    public void setAllowedIps(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        this._allowedIps = stringArray;
        ((Hashtable)PROPS).put("WHITE_LISTED_IP_ADDRESSES", SettingsManager.encode(stringArray));
    }

    public void setBannedWords(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        this._bannedWords = stringArray;
        ((Hashtable)PROPS).put("BANNED_WORDS", SettingsManager.encode(stringArray));
    }

    public void setFilterAdult(boolean bl) {
        this._filterAdult = bl;
        Boolean bl2 = new Boolean(bl);
        String string = bl2.toString();
        ((Hashtable)PROPS).put("FILTER_ADULT", string);
    }

    public void setFilterDuplicates(boolean bl) {
        this._filterDuplicates = bl;
        Boolean bl2 = new Boolean(bl);
        String string = bl2.toString();
        ((Hashtable)PROPS).put("FILTER_DUPLICATES", string);
    }

    public void setFilterHtml(boolean bl) {
        this._filterHtml = bl;
        Boolean bl2 = new Boolean(bl);
        String string = bl2.toString();
        ((Hashtable)PROPS).put("FILTER_HTML", string);
    }

    public void setFilterVbs(boolean bl) {
        this._filterVbs = bl;
        Boolean bl2 = new Boolean(bl);
        String string = bl2.toString();
        ((Hashtable)PROPS).put("FILTER_VBS", string);
    }

    public void setFilterGreedyQueries(boolean bl) {
        this._filterGreedyQueries = bl;
        Boolean bl2 = new Boolean(bl);
        String string = bl2.toString();
        ((Hashtable)PROPS).put("FILTER_GREEDY_QUERIES", string);
    }

    public void setFilterBearShareQueries(boolean bl) {
        this._filterBearShare = bl;
        Boolean bl2 = new Boolean(bl);
        String string = bl2.toString();
        ((Hashtable)PROPS).put("FILTER_HIGHBIT_QUERIES", string);
    }

    public void setFreeloaderAllowed(int n) throws IllegalArgumentException {
        if (n > 100 || n < 0) {
            throw new IllegalArgumentException();
        }
        this._freeLoaderAllowed = n;
        String string = Integer.toString(n);
        ((Hashtable)PROPS).put("FREELOADER_ALLOWED", string);
    }

    public void setFreeloaderFiles(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this._freeLoaderFiles = n;
        String string = Integer.toString(n);
        ((Hashtable)PROPS).put("FREELOADER_FILES", string);
    }

    public void setCheckAgain(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)PROPS).put("CHECK_AGAIN", bl2.toString());
    }

    public void setAppWidth(int n) {
        String string = Integer.toString(n);
        ((Hashtable)PROPS).put("APP_WIDTH", string);
    }

    public void setAppHeight(int n) {
        ((Hashtable)PROPS).put("APP_HEIGHT", Integer.toString(n));
    }

    public void setRunOnce(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)PROPS).put("RUN_ONCE", bl2.toString());
    }

    public void setWindowX(int n) {
        ((Hashtable)PROPS).put("WINDOW_X", Integer.toString(n));
    }

    public void setWindowY(int n) {
        ((Hashtable)PROPS).put("WINDOW_Y", Integer.toString(n));
    }

    public void setMinimizeToTray(boolean bl) {
        this.setBooleanValue("MINIMIZE_TO_TRAY", bl);
    }

    public void setShutdownAfterTransfers(boolean bl) {
        this.setBooleanValue("SHUTDOWN_AFTER_TRANSFERS", bl);
    }

    public void setAcceptedIncoming(boolean bl) {
        this._acceptedIncoming = bl;
        this.setEverAcceptedIncoming(bl);
    }

    public void setEverAcceptedIncoming(boolean bl) {
        this.setBooleanValue("EVER_ACCEPTED_INCOMING", bl);
    }

    private void setServantType(String string) {
        this._servantType = Constants.isValidServantType(string) ? string : "XML_CLIENT";
        ((Hashtable)PROPS).put("SERVANT_TYPE", this._servantType);
    }

    public void setLanguage(String string) {
        ((Hashtable)PROPS).put("LANGUAGE", string);
    }

    public void setCountry(String string) {
        ((Hashtable)PROPS).put("COUNTRY", string);
    }

    public void setLocaleVariant(String string) {
        ((Hashtable)PROPS).put("LOCALE_VARIANT", string);
    }

    public void setMinimumSearchQuality(int n) {
        ((Hashtable)PROPS).put("MINIMUM_SEARCH_QUALITY", Integer.toString(n));
    }

    public void setMinimumSearchSpeed(int n) {
        ((Hashtable)PROPS).put("MINIMUM_SEARCH_SPEED", Integer.toString(n));
    }

    public void setMaxUpstreamBytesPerSec(int n) {
        ((Hashtable)PROPS).put("MAX_UPLOAD_BYTES_PER_SEC", Integer.toString(n));
    }

    public void setMaxDownstreamBytesPerSec(int n) {
        ((Hashtable)PROPS).put("MAX_DOWNLOAD_BYTES_PER_SEC", Integer.toString(n));
    }

    public void setEverSupernodeCapable(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)PROPS).put("EVER_SUPERNODE_CAPABLE", bl2.toString());
    }

    public void setDisableSupernodeMode(boolean bl) {
        this.setBooleanValue("DISABLE_SUPERNODE_MODE", bl);
    }

    public void setForceSupernodeMode(boolean bl) {
        this.setBooleanValue("FORCE_SUPERNODE_MODE", bl);
    }

    public void setMaxShieldedClientConnections(int n) {
        this._maxShieldedClientConnections = n;
        ((Hashtable)PROPS).put("MAX_SHIELDED_CLIENT_CONNECTIONS", Integer.toString(n));
    }

    public void setMinShieldedClientConnections(int n) {
        this._minShieldedClientConnections = n;
        ((Hashtable)PROPS).put("MIN_SHIELDED_CLIENT_CONNECTIONS", Integer.toString(n));
    }

    public void setConnectOnStartup(boolean bl) {
        this.setBooleanValue("CONNECT_ON_STARTUP", bl);
    }

    public void setLastExpireTime(long l) {
        this.setLongValue("LAST_EXPIRE_TIME", l);
    }

    public void setAdVersion(String string) {
        this.setStringValue("AD_VERSION", string);
    }

    public void setJarName(String string) {
        this.setStringValue("JAR_NAME", string);
        this.setStringValue("CLASSPATH", string);
    }

    private void setClasspath(String string) {
        this.setStringValue("CLASSPATH", string);
        this.setStringValue("JAR_NAME", string);
    }

    public void setSkinTheme(File file) {
        this.setFileValue("SKIN_THEME", file);
    }

    public void setServer(boolean bl) {
        this._server = bl;
        this.setBooleanValue("SERVER", bl);
    }

    public void setCookiesFile(String string) {
        this.setStringValue("COOKIES_FILE", string);
    }

    public void setAcceptAuthenticatedConnectionsOnly(boolean bl) {
        this.setBooleanValue("ACCEPT_AUTHENTICATED_CONNECTIONS_ONLY", bl);
    }

    private void setBooleanValue(String string, boolean bl) {
        ((Hashtable)PROPS).put(string, String.valueOf(bl));
    }

    private void setLongValue(String string, long l) {
        ((Hashtable)PROPS).put(string, String.valueOf(l));
    }

    private void setIntValue(String string, int n) {
        ((Hashtable)PROPS).put(string, Integer.toString(n));
    }

    private void setFloatValue(String string, float f) {
        ((Hashtable)PROPS).put(string, Float.toString(f));
    }

    private void setStringValue(String string, String string2) {
        ((Hashtable)PROPS).put(string, string2);
    }

    private void setFileValue(String string, File file) {
        ((Hashtable)PROPS).put(string, file.getAbsolutePath());
    }

    private boolean getBooleanValue(String string) {
        return Boolean.valueOf(PROPS.getProperty(string));
    }

    private long getLongValue(String string) {
        return Long.valueOf(PROPS.getProperty(string));
    }

    private String getStringValue(String string) {
        return PROPS.getProperty(string);
    }

    private int getIntValue(String string) {
        return Integer.parseInt(PROPS.getProperty(string));
    }

    private float getFloatValue(String string) {
        return Float.valueOf(PROPS.getProperty(string)).floatValue();
    }

    private File getFileValue(String string) {
        return new File(PROPS.getProperty(string));
    }

    /*
     * Loose catch block
     */
    public void writeProperties() {
        block11: {
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(this.PROPS_FILE);
            PROPS.save(fileOutputStream, "");
            fileOutputStream.close();
            Object var4_2 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {
                this.showInternalError(iOException);
            }
            break block11;
            {
                catch (Throwable throwable) {
                    this.showInternalError(throwable);
                    Object var4_3 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException) {
                        this.showInternalError(iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.showInternalError(iOException);
                }
                throw throwable;
            }
        }
    }

    private static String encode(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length - 1) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(STRING_DELIMETER);
            ++n;
        }
        if (stringArray.length != 0) {
            stringBuffer.append(stringArray[stringArray.length - 1]);
        }
        return stringBuffer.toString();
    }

    private static String[] decode(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, STRING_DELIMETER);
        Vector vector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void showInternalError(Throwable throwable) {
        Object object;
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("LimeWire version ");
        printWriter.println(CommonUtils.getLimeWireVersion());
        printWriter.print("Java version ");
        printWriter.print(CommonUtils.getJavaVersion());
        printWriter.print(" from ");
        printWriter.println(this.prop("java.vendor"));
        printWriter.print(CommonUtils.getOS());
        printWriter.print(" v. ");
        printWriter.print(this.prop("os.version"));
        printWriter.print(" on ");
        printWriter.println(this.prop("os.arch"));
        Runtime runtime = Runtime.getRuntime();
        printWriter.println("Free/total memory: " + runtime.freeMemory() + "/" + runtime.totalMemory());
        printWriter.println();
        throwable.printStackTrace(printWriter);
        printWriter.println();
        File file = new File(CommonUtils.getUserSettingsDir(), "limewire.props");
        Properties properties = new Properties();
        try {
            object = new FileInputStream(file);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
            properties.list(printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.println("");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("FILES IN CURRENT DIRECTORY:");
        object = CommonUtils.getCurrentDirectory();
        String[] stringArray = ((File)object).list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File((File)object, stringArray[n]);
            printWriter.println(file2.toString());
            printWriter.println("LAST MODIFIED: " + file2.lastModified());
            printWriter.println("SIZE: " + file2.length());
            printWriter.println();
            ++n;
        }
        printWriter.flush();
        this.displayError(stringWriter.toString());
        if (throwable instanceof ExceptionInInitializerError) {
            this.showInternalError(((ExceptionInInitializerError)throwable).getException());
        }
    }

    private String prop(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return "?";
        }
        return string2;
    }

    private void displayError(String string) {
        final JDialog jDialog = new JDialog();
        Dimension dimension = new Dimension(260, 120);
        Dimension dimension2 = new Dimension(220, 100);
        ((Component)jDialog).setSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("LimeWire has encountered an error.  If you would be so kind, please copy this message and send it to bugs@limewire.com.");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jLabel);
        jPanel3.add(Box.createVerticalStrut(6));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createHorizontalGlue());
        final JTextArea jTextArea = new JTextArea(string);
        jTextArea.selectAll();
        jTextArea.copy();
        jTextArea.setColumns(50);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setPreferredSize(dimension2);
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Copy Selection");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.copy();
            }
        });
        JButton jButton2 = new JButton("Ok");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add(jPanel2);
        jPanel.add(jScrollPane);
        jPanel.add(jPanel4);
        jDialog.getContentPane().add(jPanel);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jDialog).setLocation((dimension3.width - dimension.width) / 2, (dimension3.height - dimension.height) / 2);
        jDialog.pack();
        jDialog.show();
    }

    public Properties getProperties() {
        return PROPS;
    }
}

