/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.BearShareFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GUIDFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.RequeryFilter;
import com.sun.java.util.collections.Vector;

public abstract class SpamFilter {
    public static SpamFilter newPersonalFilter() {
        Object object;
        SettingsManager settingsManager = SettingsManager.instance();
        Vector vector = new Vector();
        String[] stringArray = settingsManager.getBannedIps();
        if (stringArray.length != 0) {
            object = new IPFilter();
            vector.add(object);
        }
        object = settingsManager.getBannedWords();
        boolean bl = settingsManager.getFilterAdult();
        boolean bl2 = settingsManager.getFilterVbs();
        boolean bl3 = settingsManager.getFilterHtml();
        if (((String[])object).length != 0 || bl || bl2 || bl3) {
            KeywordFilter keywordFilter = new KeywordFilter();
            int n = 0;
            while (n < ((String[])object).length) {
                keywordFilter.disallow(object[n]);
                ++n;
            }
            if (bl) {
                keywordFilter.disallowAdult();
            }
            if (bl2) {
                keywordFilter.disallowVbs();
            }
            if (bl3) {
                keywordFilter.disallowHtml();
            }
            vector.add(keywordFilter);
        }
        return SpamFilter.compose(vector);
    }

    public static SpamFilter newRouteFilter() {
        SettingsManager settingsManager = SettingsManager.instance();
        Vector vector = new Vector();
        vector.add(new RequeryFilter());
        vector.add(new GUIDFilter());
        if (settingsManager.getFilterDuplicates()) {
            vector.add(new DuplicateFilter());
        }
        if (settingsManager.getFilterGreedyQueries()) {
            vector.add(new GreedyQueryFilter());
        }
        if (settingsManager.getFilterBearShareQueries()) {
            vector.add(new BearShareFilter());
        }
        return SpamFilter.compose(vector);
    }

    private static SpamFilter compose(Vector vector) {
        if (vector.size() == 0) {
            return new AllowFilter();
        }
        if (vector.size() == 1) {
            return (SpamFilter)vector.get(0);
        }
        Object[] objectArray = new SpamFilter[vector.size()];
        vector.copyInto(objectArray);
        return new CompositeFilter((SpamFilter[])objectArray);
    }

    public abstract boolean allow(Message var1);
}

