/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;

public class StandardMessageRouter
extends MessageRouter {
    private ActivityCallback _callback;
    private FileManager _fileManager;

    public StandardMessageRouter(ActivityCallback activityCallback, FileManager fileManager) {
        this._callback = activityCallback;
        this._fileManager = fileManager;
    }

    protected void handleQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (!replyHandler.isPersonalSpam(queryRequest)) {
            this._callback.handleQueryString(queryRequest.getQuery());
        }
        super.handleQueryRequest(queryRequest, replyHandler);
    }

    protected void respondToPingRequest(PingRequest pingRequest) {
        byte by;
        byte by2 = pingRequest.getHops();
        if (by2 + (by = pingRequest.getTTL()) > 2 && !this._manager.allowAnyConnection()) {
            return;
        }
        if (by2 == 1 && by == 1) {
            this.handleCrawlerPing(pingRequest);
        }
        int n = by2 + 1;
        if (by2 + by <= 2) {
            n = 1;
        }
        int n2 = RouterService.getNumSharedFiles();
        int n3 = RouterService.getSharedFileSize() / 1024;
        boolean bl = RouterService.isSupernode();
        int n4 = Statistics.instance().calculateDailyUptime();
        PingReply pingReply = new PingReply(pingRequest.getGUID(), (byte)n, RouterService.getPort(), RouterService.getAddress(), (long)n2, (long)n3, bl, n4);
        try {
            this.sendPingReply(pingReply);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void respondToUDPPingRequest(PingRequest pingRequest) {
        List list = this.UNICASTER.getUnicastEndpoints();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GUESSEndpoint gUESSEndpoint = (GUESSEndpoint)iterator.next();
            PingReply pingReply = new PingReply(pingRequest.getGUID(), 1, gUESSEndpoint.getPort(), gUESSEndpoint.getAddress().getAddress(), 0L, 0L, true);
            try {
                this.sendPingReply(pingReply);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleCrawlerPing(PingRequest pingRequest) {
        List list = this._manager.getInitializedClientConnections2();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            PingReply pingReply = new PingReply(pingRequest.getGUID(), 2, managedConnection.getOrigPort(), managedConnection.getInetAddress().getAddress(), 0L, 0L);
            pingReply.hop();
            try {
                this.sendPingReply(pingReply);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        if (replyHandler instanceof ManagedConnection) {
            ManagedConnection managedConnection = (ManagedConnection)replyHandler;
            managedConnection.updateHorizonStats(pingReply);
        }
        super.handlePingReply(pingReply, replyHandler);
    }

    public GroupPingRequest createGroupPingRequest(String string) {
        int n = RouterService.getNumSharedFiles();
        int n2 = RouterService.getSharedFileSize() / 1024;
        GroupPingRequest groupPingRequest = new GroupPingRequest(SettingsManager.instance().getTTL(), RouterService.getPort(), RouterService.getAddress(), n, n2, string + ":" + SettingsManager.instance().getEverSupernodeCapable());
        return groupPingRequest;
    }

    protected void respondToQueryRequest(QueryRequest queryRequest, byte[] byArray) {
        Response[] responseArray = this._fileManager.query(queryRequest);
        this.sendResponses(responseArray, queryRequest, byArray);
    }

    public void sendResponses(Response[] responseArray, QueryRequest queryRequest, byte[] byArray) {
        if (responseArray == null || responseArray.length < 1) {
            return;
        }
        long l = RouterService.getUploadManager().measuredUploadSpeed();
        boolean bl = true;
        if (l == -1L) {
            l = SettingsManager.instance().getConnectionSpeed();
            bl = false;
        }
        Iterator iterator = this.responsesToQueryReplies(responseArray, queryRequest);
        try {
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                this.sendQueryReply(queryReply);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void addQueryRoutingEntries(QueryRouteTable queryRouteTable) {
        Iterator iterator = this._fileManager.getKeyWords().iterator();
        while (iterator.hasNext()) {
            queryRouteTable.add((String)iterator.next());
        }
        Iterator iterator2 = this._fileManager.getIndivisibleKeyWords().iterator();
        while (iterator2.hasNext()) {
            queryRouteTable.addIndivisible((String)iterator2.next());
        }
    }
}

