/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.SettingsManager;

public class Statistics {
    private static Statistics _instance = new Statistics();
    private static final int SECONDS_PER_DAY = 86400;
    private static final int WINDOW_MILLISECONDS = 604800000;
    private long startTime = this.now();

    protected Statistics() {
    }

    public static Statistics instance() {
        return _instance;
    }

    public long getUptime() {
        return this.now() - this.startTime;
    }

    public int calculateDailyUptime() {
        return (int)(this.calculateFractionalUptime() * 86400.0f);
    }

    public float calculateFractionalUptime() {
        SettingsManager settingsManager = SettingsManager.instance();
        float f = Math.min(6.048E8f, (float)(this.now() - settingsManager.getLastShutdownTime()));
        float f2 = Math.min(6.048E8f, (float)this.getUptime());
        float f3 = settingsManager.getFractionalUptime();
        if (f2 < 0.0f || f < 0.0f || f2 > f) {
            return f3;
        }
        return f2 / 6.048E8f + (6.048E8f - f) / 6.048E8f * f3;
    }

    public void shutdown() {
        SettingsManager settingsManager = SettingsManager.instance();
        settingsManager.setFractionalUptime(this.calculateFractionalUptime());
        settingsManager.setLastShutdownTime(this.now());
    }

    protected long now() {
        return System.currentTimeMillis();
    }
}

