/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.CommonUtils;

public final class SupernodeAssigner {
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private final int MINIMUM_REQUIRED_UPSTREAM_KBYTES_PER_SECOND = 15;
    private final int MINIMUM_REQUIRED_DOWNSTREAM_KBYTES_PER_SECOND = 20;
    private final int MINIMUM_AVERAGE_UPTIME = 3600;
    private final int MINIMUM_CURRENT_UPTIME = 7200;
    private boolean SUPERNODE_OS = CommonUtils.isSupernodeOS();
    public static final int TIMER_DELAY = 1000;
    private final int TIMER_DELAY_IN_SECONDS = 1;
    private BandwidthTracker _uploadTracker;
    private BandwidthTracker _downloadTracker;
    private ConnectionManager _manager;
    private long _currentUptime = 0L;
    private int _maxUpstreamBytesPerSec = this.SETTINGS.getMaxUpstreamBytesPerSec();
    private int _maxDownstreamBytesPerSec = this.SETTINGS.getMaxDownstreamBytesPerSec();
    private volatile boolean _wasSupernodeCapable;

    public SupernodeAssigner(BandwidthTracker bandwidthTracker, BandwidthTracker bandwidthTracker2, ConnectionManager connectionManager) {
        this._uploadTracker = bandwidthTracker;
        this._downloadTracker = bandwidthTracker2;
        this._manager = connectionManager;
        this._wasSupernodeCapable = this._manager.isSupernode();
    }

    public void start() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    SupernodeAssigner.this.collectBandwidthData();
                }
                catch (Throwable throwable) {
                    RouterService.error(throwable);
                }
            }
        };
        RouterService.schedule(runnable, 0L, 1000L);
    }

    public void setSupernodeCapable() {
        boolean bl;
        if (this.SETTINGS.getDisableSupernodeMode()) {
            this.SETTINGS.setEverSupernodeCapable(false);
            return;
        }
        boolean bl2 = bl = !(this._maxUpstreamBytesPerSec < 15 && this._maxDownstreamBytesPerSec < 20 || this.SETTINGS.getConnectionSpeed() <= 56 || this.SETTINGS.getAverageUptime() < 3600L && this._currentUptime < 7200L || !this.SETTINGS.getEverAcceptedIncoming() || !RouterService.isGUESSCapable() || !this.SUPERNODE_OS);
        if (bl) {
            this.SETTINGS.setEverSupernodeCapable(true);
        }
    }

    private void collectBandwidthData() {
        ++this._currentUptime;
        this._uploadTracker.measureBandwidth();
        this._downloadTracker.measureBandwidth();
        this._manager.measureBandwidth();
        float f = 0.0f;
        try {
            f = this._uploadTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            f = 0.0f;
        }
        int n = (int)f + (int)this._manager.getMeasuredUpstreamBandwidth();
        f = 0.0f;
        try {
            f = this._downloadTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            f = 0.0f;
        }
        int n2 = (int)f + (int)this._manager.getMeasuredDownstreamBandwidth();
        if (n > this._maxUpstreamBytesPerSec) {
            this._maxUpstreamBytesPerSec = n;
            this.SETTINGS.setMaxUpstreamBytesPerSec(this._maxUpstreamBytesPerSec);
        }
        if (n2 > this._maxDownstreamBytesPerSec) {
            this._maxDownstreamBytesPerSec = n2;
            this.SETTINGS.setMaxDownstreamBytesPerSec(this._maxDownstreamBytesPerSec);
        }
        this.setSupernodeCapable();
    }
}

