/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.net.InetAddress;

public final class UDPReplyHandler
implements ReplyHandler {
    private final InetAddress IP;
    private final int PORT;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static final UDPService UDP_SERVICE = UDPService.instance();
    private final boolean RECORD_STATS = !CommonUtils.isJava118();

    public UDPReplyHandler(InetAddress inetAddress, int n) {
        this.IP = inetAddress;
        this.PORT = n;
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        UDP_SERVICE.send(pingReply, this.IP, this.PORT);
        if (this.RECORD_STATS) {
            SentMessageStatHandler.UDP_PING_REPLIES.addMessage(pingReply);
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        UDP_SERVICE.send(queryReply, this.IP, this.PORT);
        if (this.RECORD_STATS) {
            SentMessageStatHandler.UDP_QUERY_REPLIES.addMessage(queryReply);
        }
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        UDP_SERVICE.send(pushRequest, this.IP, this.PORT);
        if (this.RECORD_STATS) {
            SentMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(pushRequest);
        }
    }

    public void countDroppedMessage() {
    }

    public Set getDomains() {
        return EMPTY_SET;
    }

    public boolean isPersonalSpam(Message message) {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public String toString() {
        return "UDPReplyHandler:\r\n" + this.IP.toString() + "\r\n" + this.PORT + "\r\n";
    }
}

