/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public final class UDPService
implements Runnable {
    private static final UDPService INSTANCE = new UDPService();
    private volatile DatagramSocket _socket;
    private final Object _receiveLock = new Object();
    private final Object _sendLock = new Object();
    private final int BUFFER_SIZE = 32768;
    private boolean _isGUESSCapable = false;
    private final Thread UDP_THREAD = new Thread(this);
    private QueryUnicaster UNICASTER = QueryUnicaster.instance();

    public static UDPService instance() {
        return INSTANCE;
    }

    private UDPService() {
    }

    DatagramSocket newListeningSocket(int n) throws IOException {
        try {
            return new DatagramSocket(n);
        }
        catch (SocketException socketException) {
            throw new IOException();
        }
        catch (SecurityException securityException) {
            throw new IOException();
        }
    }

    void setListeningSocket(DatagramSocket datagramSocket) {
        if (!this.UDP_THREAD.isAlive()) {
            this.UDP_THREAD.setDaemon(true);
            this.UDP_THREAD.start();
        }
        if (this._socket != null) {
            this._socket.close();
        }
        Object object = this._receiveLock;
        synchronized (object) {
            Object object2 = this._sendLock;
            synchronized (object2) {
                this._socket = datagramSocket;
                this._receiveLock.notify();
                this._sendLock.notify();
            }
        }
    }

    public void run() {
        try {
            MessageRouter messageRouter = RouterService.getMessageRouter();
            byte[] byArray = new byte[32768];
            while (true) {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 32768);
                Object object = this._receiveLock;
                synchronized (object) {
                    if (this._socket == null) {
                        try {
                            this._receiveLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                    }
                    try {
                        this._socket.receive(datagramPacket);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                this._isGUESSCapable = true;
                byte[] byArray2 = datagramPacket.getData();
                int n = datagramPacket.getLength();
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    Message message = Message.read(byteArrayInputStream);
                    if (message == null) continue;
                    messageRouter.handleUDPMessage(message, datagramPacket);
                }
                catch (IOException iOException) {
                }
                catch (BadPacketException badPacketException) {}
            }
        }
        catch (Throwable throwable) {
            RouterService.error(throwable);
            return;
        }
    }

    public synchronized void send(Message message, InetAddress inetAddress, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            message.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        Object object = this._sendLock;
        synchronized (object) {
            if (this._socket == null) {
                return;
            }
            try {
                this._socket.send(datagramPacket);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean isGUESSCapable() {
        return this._isGUESSCapable;
    }

    public boolean isListening() {
        if (this._socket == null) {
            return false;
        }
        return this._socket.getLocalPort() != -1;
    }

    public String toString() {
        return "UDPAcceptor\r\nsocket: " + this._socket;
    }
}

