/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.IntWrapper;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class URN
implements HTTPHeaderValue,
Serializable {
    private static final long serialVersionUID = -6053855548211564799L;
    private static final String SPACE = " ";
    private static final String QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private static final String TWO = "2";
    private transient String _urnString;
    private transient UrnType _urnType;
    private volatile transient int hashCode = 0;
    private static Map progressMap = new HashMap();

    public static int getHashingProgress(File file) {
        IntWrapper intWrapper = (IntWrapper)progressMap.get(file);
        if (intWrapper == null) {
            return -1;
        }
        return intWrapper.getInt();
    }

    public static URN createSHA1Urn(File file) throws IOException, InterruptedException {
        return new URN(URN.createSHA1String(file), UrnType.SHA1);
    }

    public static URN createSHA1Urn(String string) throws IOException {
        return URN.createSHA1UrnFromString(string);
    }

    public static URN createSHA1UrnFromHttpRequest(String string) throws IOException {
        if (!URN.isValidUrnHttpRequest(string)) {
            throw new IOException("IVVALID URN HTTP REQUEST");
        }
        String string2 = URN.extractUrnFromHttpRequest(string);
        if (string2 == null) {
            throw new IOException("COULD NOT CONSTRUCT URN");
        }
        return URN.createSHA1UrnFromString(string2);
    }

    private static URN createSHA1UrnFromString(String string) throws IOException {
        if (string == null) {
            throw new IOException("cannot accept null URN string");
        }
        if (!URN.isValidUrn(string)) {
            throw new IOException("invalid urn string: " + string);
        }
        String string2 = URN.getTypeString(string);
        if (!UrnType.isSupportedUrnType(string2)) {
            throw new IOException("urn type not recognized: " + string2);
        }
        UrnType urnType = UrnType.createUrnType(string2);
        return new URN(string, urnType);
    }

    private URN(String string, UrnType urnType) throws IOException {
        this._urnString = string;
        this._urnType = urnType;
    }

    public UrnType getUrnType() {
        return this._urnType;
    }

    public String httpStringValue() {
        return this._urnString;
    }

    public static boolean isUrn(String string) {
        return URN.isValidUrn(string);
    }

    public boolean isSHA1() {
        return this._urnType.isSHA1();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URN)) {
            return false;
        }
        URN uRN = (URN)object;
        return this._urnString.equals(uRN._urnString) && this._urnType.equals(uRN._urnType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + this._urnString.hashCode();
            this.hashCode = n = 37 * n + this._urnType.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._urnString;
    }

    private static String extractUrnFromHttpRequest(String string) {
        int n = string.indexOf(QUESTION_MARK) + 1;
        int n2 = string.indexOf(SPACE, n);
        if (n == -1 || n2 == -1) {
            return null;
        }
        return string.substring(n, n2);
    }

    private static boolean isValidUrnHttpRequest(String string) {
        return URN.isValidSize(string) && URN.isValidUriRes(string) && URN.isValidResolutionProtocol(string) && URN.isValidHTTPSpecifier(string);
    }

    private static final boolean isValidSize(String string) {
        int n = string.length();
        return n == 63 || n == 107;
    }

    private static final boolean isValidUriRes(String string) {
        int n = string.indexOf(SLASH);
        if (n == -1) {
            return false;
        }
        int n2 = string.indexOf(SLASH, n + 1);
        if (n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 1, n2);
        return string2.equalsIgnoreCase("uri-res");
    }

    private static boolean isValidResolutionProtocol(String string) {
        int n = string.indexOf(TWO);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n - 1, n + 3);
        return string2.equalsIgnoreCase("N2R?");
    }

    private static boolean isValidHTTPSpecifier(String string) {
        int n = string.lastIndexOf(SPACE);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        return string2.equalsIgnoreCase("HTTP/1.0") || string2.equalsIgnoreCase("HTTP/1.1");
    }

    private static String getTypeString(String string) {
        String string2 = string.trim();
        return string2.substring(0, string2.indexOf(58, 4) + 1);
    }

    private static String createSHA1String(File file) throws IOException, InterruptedException {
        byte[] byArray;
        FileInputStream fileInputStream = new FileInputStream(file);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("NO SUCH ALGORITHM");
        }
        try {
            int n;
            byArray = new byte[16384];
            IntWrapper intWrapper = new IntWrapper(0);
            progressMap.put(file, intWrapper);
            while ((n = fileInputStream.read(byArray)) != -1) {
                long l = System.currentTimeMillis();
                messageDigest.update(byArray, 0, n);
                intWrapper.addInt(n);
                long l2 = System.currentTimeMillis();
                long l3 = Math.max(0L, l2 - l);
                Thread.sleep(l3 * 2L);
            }
            Object var13_10 = null;
            progressMap.remove(file);
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            progressMap.remove(file);
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        byArray = messageDigest.digest();
        return "urn:sha1:" + Base32.encode(byArray);
    }

    private static boolean isValidUrn(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return false;
        }
        int n2 = n - 3;
        int n3 = n + 1;
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        String string2 = string.substring(0, n + 1);
        int n4 = string.indexOf(":", n + 1);
        if (n4 == -1) {
            return false;
        }
        String string3 = string.substring(0, n4 + 1);
        return UrnType.isSupportedUrnType(string3) && URN.isValidNamespaceSpecificString(string.substring(n4 + 1));
    }

    private static boolean isValidNamespaceSpecificString(String string) {
        int n = string.length();
        return n == 32 || n == 72;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this._urnString);
        objectOutputStream.writeObject(this._urnType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._urnString = objectInputStream.readUTF();
        this._urnType = (UrnType)objectInputStream.readObject();
        if (!URN.isValidUrn(this._urnString)) {
            throw new InvalidObjectException("invalid urn: " + this._urnString);
        }
        if (!this._urnType.isSHA1()) {
            throw new InvalidObjectException("invalid urn type: " + this._urnType);
        }
        this._urnType = UrnType.SHA1;
    }
}

