/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.URLDecoder;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class UploadManager
implements BandwidthTracker {
    private final int REJECTED = 0;
    private final int QUEUED = 1;
    private final int ACCEPTED = 2;
    public static final int MIN_POLL_TIME = 45000;
    public static final int MAX_POLL_TIME = 120000;
    private static final int PUSH_INVALIDATE_TIME = 300;
    private List _failedPushes = new LinkedList();
    private List _attemptingPushes = new LinkedList();
    private List _activeUploadList = new LinkedList();
    private List _queuedUploads = new LinkedList();
    private volatile boolean _hadSuccesfulUpload = false;
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    private Buffer speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    public static final int BROWSE_HOST_FILE_INDEX = -1;
    public static final int UPDATE_FILE_INDEX = -2;
    private final boolean debugOn = false;
    private final boolean log = false;
    PrintWriter writer = null;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acceptUpload(HTTPRequestMethod var1_1, Socket var2_2) {
        this.debug(" accepting upload");
        var3_3 = null;
        try {
            try {
                var4_4 = -1;
                var5_6 = "";
                var6_7 = var1_1;
                while (true) {
                    block20: {
                        var7_8 = this.parseHttpRequest(var2_2);
                        this.debug(" successfully parsed request");
                        var8_9 = var7_8._fileName;
                        var3_3 = new HTTPUploader(var6_7, var8_9, var2_2, var7_8._index, var3_3);
                        var3_3.readHeader();
                        this.debug(var3_3 + " HTTPUploader created and read all headers");
                        var9_10 = var5_6.equalsIgnoreCase(var8_9) != false && var4_4 == 2;
                        var4_4 = this.doSingleUpload(var3_3, var2_2, var2_2.getInetAddress().getHostAddress(), var7_8._index, var9_10);
                        var5_6 = var8_9;
                        if (var7_8.isHTTP11() && !var3_3.getCloseConnection() || var4_4 == 1) break block20;
                        var13_13 = null;
                        var14_17 = this;
                        synchronized (var14_17) {
                            var15_21 = false;
                            var16_25 = this._queuedUploads.iterator();
                            if (true) ** GOTO lbl67
                        }
                    }
                    this.debug(var3_3 + " waiting for next request with socket ");
                    var10_11 = var2_2.getSoTimeout();
                    if (var4_4 != 1) {
                        var2_2.setSoTimeout(SettingsManager.instance().getPersistentHTTPConnectionTimeout());
                    }
                    var11_12 = IOUtils.readWord(var2_2.getInputStream(), 4);
                    this.debug(var3_3 + " next request arrived ");
                    var2_2.setSoTimeout(var10_11);
                    if (var11_12.equals("GET")) {
                        var6_7 = HTTPRequestMethod.GET;
                        continue;
                    }
                    if (!var11_12.equals("HEAD")) break;
                    var6_7 = HTTPRequestMethod.HEAD;
                }
                var13_14 = null;
                var14_18 = this;
            }
            catch (IOException var4_5) {
                this.debug("IOE thrown, closing socket");
                var13_15 = null;
                var14_19 = this;
                synchronized (var14_19) {
                    var15_23 = false;
                    var16_27 = this._queuedUploads.iterator();
                    if (true) ** GOTO lbl87
                }
            }
            synchronized (var14_18) {
                var15_22 = false;
                var16_26 = this._queuedUploads.iterator();
                if (true) ** GOTO lbl77
            }
        }
        catch (Throwable var12_33) {
            var13_16 = null;
            var14_20 = this;
            synchronized (var14_20) {
                var15_24 = false;
                var16_28 = this._queuedUploads.iterator();
                if (true) ** GOTO lbl97
            }
        }
        {
            do {
                if ((var17_29 = (KeyValue)var16_25.next()).getKey() != var2_2) continue;
                var15_21 = true;
                var16_25.remove();
lbl67:
                // 3 sources

            } while (var16_25.hasNext());
            if (var15_21) {
                var3_3.setState(5);
            }
        }
        this.debug("closing socket");
        this.close(var2_2);
        return;
        {
            do {
                if ((var17_30 = (KeyValue)var16_26.next()).getKey() != var2_2) continue;
                var15_22 = true;
                var16_26.remove();
lbl77:
                // 3 sources

            } while (var16_26.hasNext());
            if (var15_22) {
                var3_3.setState(5);
            }
        }
        this.debug("closing socket");
        this.close(var2_2);
        return;
        {
            do {
                if ((var17_31 = (KeyValue)var16_27.next()).getKey() != var2_2) continue;
                var15_23 = true;
                var16_27.remove();
lbl87:
                // 3 sources

            } while (var16_27.hasNext());
            if (var15_23) {
                var3_3.setState(5);
            }
        }
        this.debug("closing socket");
        this.close(var2_2);
        return;
        {
            do {
                if ((var17_32 = (KeyValue)var16_28.next()).getKey() != var2_2) continue;
                var15_24 = true;
                var16_28.remove();
lbl97:
                // 3 sources

            } while (var16_28.hasNext());
            if (var15_24) {
                var3_3.setState(5);
            }
        }
        this.debug("closing socket");
        this.close(var2_2);
        throw var12_33;
    }

    private int doSingleUpload(Uploader uploader, Socket socket, String string, int n, boolean bl) throws IOException {
        Object object;
        long l = -1L;
        this.debug(uploader + " starting single upload");
        boolean bl2 = uploader.getState() == 8;
        boolean bl3 = uploader.getState() == 10;
        int n2 = -1;
        if (!bl2 && !bl3) {
            if (uploader.getState() == 0) {
                n2 = this.checkAndQueue(uploader, string, socket, bl);
                this.debug(uploader + " insert and test returned " + n2);
                Assert.that(n2 != -1);
            }
            RouterService.getCallback().addUpload(uploader);
            object = uploader.getFileDesc();
            if (object != null) {
                ((FileDesc)object).incrementAttemptedUploads();
                RouterService.getCallback().handleSharedFileUpdate(((FileDesc)object).getFile());
            }
        }
        if (n2 == 1) {
            socket.setSoTimeout(120000);
            uploader.setState(9);
        } else if (n2 == 2) {
            object = this;
            synchronized (object) {
                uploader.setState(0);
                this._activeUploadList.add(uploader);
            }
        }
        l = System.currentTimeMillis();
        uploader.writeResponse();
        this.debug(uploader + " Uploader wrote response");
        if (uploader.getState() == 3 || uploader.getState() == 0) {
            uploader.setState(5);
        }
        if (uploader.getState() == 4) {
            this._hadSuccesfulUpload = true;
            if (!bl2 && (object = uploader.getFileDesc()) != null) {
                ((FileDesc)object).incrementCompletedUploads();
                RouterService.getCallback().handleSharedFileUpdate(((FileDesc)object).getFile());
            }
        }
        long l2 = System.currentTimeMillis();
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            if (l > 0L) {
                this.reportUploadSpeed(l2 - l, uploader.amountUploaded());
            }
            this.removeFromList(uploader);
            if (!bl2) {
                RouterService.getCallback().removeUpload(uploader);
            }
            int n3 = n2;
            return n3;
        }
    }

    public void close(Socket socket) {
        try {
            if (socket != null) {
                socket.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (socket != null) {
                socket.getInputStream().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void acceptPushUpload(String string, final String string2, int n, final int n2, String string3) {
        final HTTPUploader hTTPUploader = new HTTPUploader(string, string2, n, n2, string3);
        this.clearFailedPushes();
        if (!this.testAttemptingPush(string2, n2) || !this.testFailedPush(string2, n2)) {
            return;
        }
        this.insertAttemptingPush(string2, n2);
        Thread thread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                UploadManager uploadManager;
                try {
                    try {
                        Socket socket = hTTPUploader.connect();
                        String string = IOUtils.readWord(socket.getInputStream(), 4);
                        if (string.equals("GET")) {
                            UploadManager.this.acceptUpload(HTTPRequestMethod.GET, socket);
                        } else {
                            if (!string.equals("HEAD")) throw new IOException();
                            UploadManager.this.acceptUpload(HTTPRequestMethod.HEAD, socket);
                        }
                        Object var5_6 = null;
                        hTTPUploader.stop();
                        uploadManager = UploadManager.this;
                    }
                    catch (IOException iOException) {
                        UploadManager uploadManager3 = UploadManager.this;
                        synchronized (uploadManager3) {
                            UploadManager.this.insertFailedPush(string2, n2);
                        }
                        Object var5_7 = null;
                        hTTPUploader.stop();
                        UploadManager uploadManager4 = UploadManager.this;
                        synchronized (uploadManager4) {
                            UploadManager.this.removeAttemptingPush(string2, n2);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        RouterService.error(throwable);
                        Object var5_8 = null;
                        hTTPUploader.stop();
                        UploadManager uploadManager5 = UploadManager.this;
                        synchronized (uploadManager5) {
                            UploadManager.this.removeAttemptingPush(string2, n2);
                            return;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    hTTPUploader.stop();
                    UploadManager uploadManager2 = UploadManager.this;
                    synchronized (uploadManager2) {
                        UploadManager.this.removeAttemptingPush(string2, n2);
                        throw throwable;
                    }
                }
                synchronized (uploadManager) {
                    UploadManager.this.removeAttemptingPush(string2, n2);
                    return;
                }
            }
        };
        thread.start();
    }

    public synchronized boolean isBusy() {
        if (RouterService.getIsShuttingDown()) {
            return true;
        }
        return !this.testTotalUploadLimit();
    }

    public int uploadsInProgress() {
        return this._activeUploadList.size();
    }

    public boolean hadSuccesfulUpload() {
        return this._hadSuccesfulUpload;
    }

    private synchronized int checkAndQueue(Uploader uploader, String string, Socket socket, boolean bl) throws IOException {
        boolean bl2 = this.hostLimitReached(string);
        int n = this._queuedUploads.size();
        int n2 = this.positionInQueue(socket);
        int n3 = SettingsManager.instance().getUploadQueueSize();
        boolean bl3 = n >= n3;
        int n4 = -1;
        boolean bl4 = uploader.supportsQueueing();
        Assert.that(n3 > 0, "queue size 0, cannot use");
        Assert.that(uploader.getState() != 8);
        if (bl) {
            return 2;
        }
        if (n2 == -1) {
            this.debug(uploader + "Uploader not in que(capacity:" + n3 + ")");
            if (bl2 || bl3) {
                this.debug(uploader + " limited? " + bl2 + " wontAccept? " + bl3);
                uploader.setState(2);
                return 0;
            }
            this.addToQueue(socket);
            n2 = n;
            n4 = 1;
            this.debug(uploader + " new uploader added to queue");
        } else {
            KeyValue keyValue = (KeyValue)this._queuedUploads.get(n2);
            Long l = (Long)keyValue.getValue();
            if (l + 45000L > System.currentTimeMillis()) {
                this._queuedUploads.remove(n2);
                this.debug(uploader + " queued uploader flooding-throwing exception");
                throw new IOException();
            }
            keyValue.setValue(new Long(System.currentTimeMillis()));
            this.debug(uploader + " updated queued uploader");
            n4 = 1;
        }
        this.debug(uploader + " checking if given uploader is can be accomodated ");
        if (!this.isBusy() && n2 == 0) {
            n4 = 2;
            this.debug(uploader + " accepting upload");
            this._queuedUploads.remove(0);
        } else if (!bl4) {
            this._queuedUploads.remove(n2);
            uploader.setState(2);
            n4 = 0;
        }
        return n4;
    }

    private synchronized void addToQueue(Socket socket) {
        Long l = new Long(System.currentTimeMillis());
        this._queuedUploads.add(new KeyValue(socket, l));
    }

    public synchronized int positionInQueue(Socket socket) {
        int n = 0;
        Iterator iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            Object object = ((KeyValue)iterator.next()).getKey();
            if (object == socket) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private synchronized void removeFromList(Uploader uploader) {
        this._activeUploadList.remove(uploader);
        if (this._activeUploadList.size() == 0) {
            RouterService.getCallback().uploadsComplete();
        }
    }

    private synchronized boolean hostLimitReached(String string) {
        Object object;
        int n = SettingsManager.instance().getUploadsPerPerson();
        int n2 = 0;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            object = (Uploader)iterator.next();
            if (!object.getHost().equals(string)) continue;
            ++n2;
        }
        iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            object = (Socket)((KeyValue)iterator.next()).getKey();
            if (!((Socket)object).getInetAddress().getHostAddress().equals(string)) continue;
            ++n2;
        }
        return n2 >= n;
    }

    private boolean testTotalUploadLimit() {
        SettingsManager settingsManager;
        int n = this.uploadsInProgress();
        if (n >= (settingsManager = SettingsManager.instance()).getMaxUploads()) {
            return false;
        }
        if (n < settingsManager.getSoftMaxUploads()) {
            return true;
        }
        float f = 0.0f;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
        }
        return f > 3.0f;
    }

    private void insertFailedPush(String string, int n) {
        this._failedPushes.add(new PushedFile(string, n));
    }

    private boolean testFailedPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._failedPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            return false;
        }
        return true;
    }

    private void insertAttemptingPush(String string, int n) {
        this._attemptingPushes.add(new PushedFile(string, n));
    }

    private boolean testAttemptingPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._attemptingPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            return false;
        }
        return true;
    }

    private void removeAttemptingPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._attemptingPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            iterator.remove();
        }
    }

    private void clearFailedPushes() {
        Date date = new Date();
        date.setTime(date.getTime() - 300000L);
        Iterator iterator = this._failedPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile = (PushedFile)iterator.next();
            if (!pushedFile.before(date)) continue;
            iterator.remove();
        }
    }

    public int calculateBandwidth() {
        float f = this.getTotalBandwith();
        float f2 = f / (float)this.uploadsInProgress();
        return (int)f2;
    }

    private float getTotalBandwith() {
        SettingsManager settingsManager = SettingsManager.instance();
        float f = (float)settingsManager.getConnectionSpeed() / 8.0f;
        float f2 = settingsManager.getUploadSpeed();
        float f3 = f * (f2 / 100.0f);
        return f3;
    }

    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    private void reportUploadSpeed(long l, long l2) {
        if (l2 < 200000L) {
            return;
        }
        int n = 8 * (int)((float)l2 / (float)l);
        this.speeds.add(new Integer(n));
        if (this.speeds.size() >= 5) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.speeds.size()) {
                n2 = Math.max(n2, (Integer)this.speeds.get(n3));
                ++n3;
            }
            this.highestSpeed = n2;
        }
    }

    private HttpRequestLine parseHttpRequest(Socket socket) throws IOException {
        socket.setSoTimeout(SettingsManager.instance().getTimeout());
        ByteReader byteReader = new ByteReader(socket.getInputStream());
        String string = byteReader.readLine();
        if (string == null) {
            throw new IOException();
        }
        string.trim();
        if (this.isURNGet(string)) {
            return this.parseURNGet(string);
        }
        return UploadManager.parseTraditionalGet(string);
    }

    private boolean isTraditionalGet(String string) {
        return string.indexOf("/get/") != -1;
    }

    private boolean isURNGet(String string) {
        int n = string.indexOf("/");
        int n2 = string.indexOf("/", n + 1);
        if (n == -1 || n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 1, n2);
        return string2.equalsIgnoreCase("uri-res");
    }

    private static HttpRequestLine parseTraditionalGet(String string) throws IOException {
        try {
            int n;
            String string2;
            int n2 = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = stringTokenizer.nextToken().trim();
            if (string3.equals("/")) {
                n2 = -1;
                string2 = "Browse-Host Request";
            } else if (string3.equals("/update.xml")) {
                n2 = -2;
                string2 = "Update-File Request";
            } else {
                n = string.indexOf("/get/");
                int n3 = string.indexOf("/", n + 5);
                String string5 = string.substring(n + 5, n3);
                n2 = Integer.parseInt(string5);
                int n4 = string.indexOf(" HTTP/", n3);
                try {
                    string2 = URLDecoder.decode(string.substring(n3 + 1, n4));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string2 = string.substring(n3 + 1, n4);
                }
            }
            n = 0;
            if (string.endsWith("1.1")) {
                n = 1;
            }
            return new HttpRequestLine(n2, string2, n != 0);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IOException();
        }
    }

    private HttpRequestLine parseURNGet(String string) throws IOException {
        URN uRN = URN.createSHA1UrnFromHttpRequest(string);
        FileDesc fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN);
        if (fileDesc == null) {
            throw new IOException("NO MATCHING FILEDESC FOR URN");
        }
        int n = fileDesc.getIndex();
        String string2 = fileDesc.getName();
        return new HttpRequestLine(fileDesc.getIndex(), fileDesc.getName(), this.isHTTP11Request(string));
    }

    private boolean isHTTP11Request(String string) {
        return string.endsWith("1.1");
    }

    public synchronized void measureBandwidth() {
        float f = 0.0f;
        boolean bl = false;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            bl = true;
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            bandwidthTracker.measureBandwidth();
            f += bandwidthTracker.getAverageBandwidth();
        }
        if (bl) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private final void debug(String string) {
    }

    private final void debug(Exception exception) {
    }

    static void tBandwidthTracker(UploadManager uploadManager) {
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 2000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 3000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 4000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 5000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 400);
        uploadManager.reportUploadSpeed(100000L, 6000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 480);
        uploadManager.reportUploadSpeed(1L, 1000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 480);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 80);
        System.out.println("passed");
    }

    private static class PushedFile {
        private final String _host;
        private final int _index;
        private final Date _time;

        public PushedFile(String string, int n) {
            this._host = string;
            this._index = n;
            this._time = new Date();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PushedFile)) {
                return false;
            }
            PushedFile pushedFile = (PushedFile)object;
            return this._index == pushedFile._index && this._host.equals(pushedFile._host);
        }

        public boolean before(Date date) {
            return this._time.before(date);
        }
    }

    private static final class HttpRequestLine {
        final int _index;
        final String _fileName;
        final boolean _http11;

        HttpRequestLine(int n, String string, boolean bl) {
            this._index = n;
            this._fileName = string;
            this._http11 = bl;
        }

        boolean isHTTP11() {
            return this._http11;
        }
    }
}

