/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class UrnCache {
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static UrnCache instance = null;
    private static final Map URN_MAP = UrnCache.createMap();
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public static synchronized UrnCache instance() {
        if (instance == null) {
            instance = new UrnCache();
        }
        return instance;
    }

    private UrnCache() {
        UrnCache.removeOldEntries(URN_MAP);
    }

    public synchronized Set getUrns(File file) {
        if (file.lastModified() == 0L) {
            return EMPTY_SET;
        }
        UrnSetKey urnSetKey = new UrnSetKey(file);
        Set set = (Set)URN_MAP.get(urnSetKey);
        if (set == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(set);
    }

    public synchronized void addUrns(File file, Set set) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        URN_MAP.put(urnSetKey, Collections.unmodifiableSet(set));
    }

    private static Map createMap() {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(URN_CACHE_FILE));
            return (Map)objectInputStream.readObject();
        }
        catch (Exception exception) {
            return new HashMap();
        }
    }

    private static void removeOldEntries(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            UrnSetKey urnSetKey = (UrnSetKey)iterator.next();
            File file = new File(urnSetKey._path);
            if (file.exists() && file.lastModified() == urnSetKey._modTime) continue;
            iterator.remove();
        }
    }

    public synchronized void persistCache() {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(URN_CACHE_FILE));
            objectOutputStream.writeObject(URN_MAP);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            RouterService.getCallback().error(12, exception);
        }
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int n = 17;
            n = n * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            n = n * 37 + this._path.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey urnSetKey = (UrnSetKey)object;
            return this._modTime == urnSetKey._modTime && this._path.equals(urnSetKey._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeLong(this._modTime);
            objectOutputStream.writeObject(this._path);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this._modTime = objectInputStream.readLong();
            this._path = (String)objectInputStream.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }
}

