/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.DefaultBootstrapServers;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Random12;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;

public class BootstrapServerManager {
    private static final int ENDPOINTS_TO_ADD = 10;
    private static final int MAX_BOOTSTRAP_SERVERS = 200;
    public static int MAX_HOSTS_PER_REQUEST = 20;
    public static int UPDATE_DELAY_MSEC = 3600000;
    private final List SERVERS = new ArrayList();
    private BootstrapServer _lastConnectable;
    private final HostCatcher CATCHER;
    private Random12 _rand = new Random12();
    private boolean _hostFetchInProgress = false;

    public BootstrapServerManager(HostCatcher hostCatcher) {
        this.CATCHER = hostCatcher;
    }

    public synchronized void addBootstrapServer(BootstrapServer bootstrapServer) {
        if (bootstrapServer == null) {
            throw new NullPointerException("null bootstrap server not allowed");
        }
        if (!this.SERVERS.contains(bootstrapServer)) {
            this.SERVERS.add(bootstrapServer);
        }
        if (this.SERVERS.size() > 200) {
            this.SERVERS.remove(this.randomServer());
        }
    }

    public synchronized Iterator getBootstrapServers() {
        return this.SERVERS.iterator();
    }

    public synchronized void fetchBootstrapServersAsync() {
        this.addDefaultsIfNeeded();
        this.requestAsync(new UrlfileRequest(), "GWebCache urlfile");
    }

    public synchronized void fetchEndpointsAsync() {
        this.addDefaultsIfNeeded();
        if (!this._hostFetchInProgress) {
            this._hostFetchInProgress = true;
            this.requestAsync(new HostfileRequest(), "GWebCache hostfile");
        }
    }

    public synchronized void sendUpdatesAsync(Endpoint endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("cannot accept null update IP");
        }
        this.addDefaultsIfNeeded();
        if (!endpoint.isPrivateAddress()) {
            this.requestAsync(new UpdateRequest(endpoint), "GWebCache update");
        }
    }

    private void addDefaultsIfNeeded() {
        if (this.SERVERS.size() > 0) {
            return;
        }
        DefaultBootstrapServers.addDefaults(this);
    }

    private void requestAsync(final GWebCacheRequest gWebCacheRequest, String string) {
        if (gWebCacheRequest == null) {
            throw new NullPointerException("asynchronous request to null cache");
        }
        Thread thread = new Thread(){

            public void run() {
                try {
                    try {
                        BootstrapServerManager.this.requestBlocking(gWebCacheRequest);
                    }
                    catch (Throwable throwable) {
                        RouterService.getCallback().error(throwable);
                        Object var3_2 = null;
                        gWebCacheRequest.done();
                    }
                    Object var3_1 = null;
                    gWebCacheRequest.done();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    gWebCacheRequest.done();
                    throw throwable;
                }
            }
        };
        thread.setName(string);
        thread.setDaemon(true);
        thread.start();
    }

    private void requestBlocking(GWebCacheRequest gWebCacheRequest) {
        if (gWebCacheRequest == null) {
            throw new NullPointerException("blocking request to null cache");
        }
        int n = 0;
        while (gWebCacheRequest.needsMoreData() && n < MAX_HOSTS_PER_REQUEST) {
            BootstrapServer bootstrapServer;
            BootstrapServerManager bootstrapServerManager = this;
            synchronized (bootstrapServerManager) {
                if (this.SERVERS.size() == 0) {
                    break;
                }
                bootstrapServer = (BootstrapServer)this.SERVERS.get(this.randomServer());
            }
            this.requestFromOneHost(gWebCacheRequest, bootstrapServer);
            ++n;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void requestFromOneHost(GWebCacheRequest gWebCacheRequest, BootstrapServer bootstrapServer) {
        BufferedReader bufferedReader;
        block13: {
            String string;
            if (gWebCacheRequest == null) {
                throw new NullPointerException("null cache in request to one host");
            }
            if (bootstrapServer == null) {
                throw new NullPointerException("null server in request to one host");
            }
            bufferedReader = null;
            URL uRL = new URL(bootstrapServer.getURL().toString() + "?client=" + "LIME" + "&version=" + URLEncoder.encode(CommonUtils.getLimeWireVersion()) + "&" + gWebCacheRequest.parameters());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("User-Agent", CommonUtils.getHttpServer());
            httpURLConnection.setRequestProperty(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "ISO-8859-1"));
            boolean bl = true;
            boolean bl2 = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl && StringUtils.startsWithIgnoreCase(string, "ERROR")) {
                    gWebCacheRequest.handleError(bootstrapServer);
                    bl2 = true;
                } else {
                    gWebCacheRequest.handleResponseData(bootstrapServer, string);
                }
                bl = false;
            }
            if (bl2) break block13;
            this._lastConnectable = bootstrapServer;
        }
        Object var10_10 = null;
        if (bufferedReader == null) return;
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                gWebCacheRequest.handleError(bootstrapServer);
                Object var10_11 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected int randomServer() {
        return this._rand.nextInt(this.SERVERS.size());
    }

    protected synchronized int size() {
        return this.SERVERS.size();
    }

    private final class UpdateRequest
    extends GWebCacheRequest {
        private boolean gotResponse = false;
        private Endpoint myIP;

        protected UpdateRequest(Endpoint endpoint) {
            this.myIP = endpoint;
        }

        protected String parameters() {
            String string = null;
            if (BootstrapServerManager.this._lastConnectable != null) {
                string = "url=" + URLEncoder.encode(BootstrapServerManager.this._lastConnectable.getURL().toString());
            }
            String string2 = null;
            if (this.myIP != null) {
                string2 = "ip=" + this.myIP.getHostname() + ":" + this.myIP.getPort();
            }
            if (string == null && string2 == null) {
                return "";
            }
            if (string != null && string2 == null) {
                return string;
            }
            if (string == null && string2 != null) {
                return string2;
            }
            Assert.that(string != null && string2 != null);
            return string2 + "&" + string;
        }

        protected void handleResponseData(BootstrapServer bootstrapServer, String string) {
            if (StringUtils.startsWithIgnoreCase(string, "OK")) {
                this.gotResponse = true;
            }
        }

        protected boolean needsMoreData() {
            return !this.gotResponse;
        }
    }

    private final class UrlfileRequest
    extends GWebCacheRequest {
        private int responses = 0;

        private UrlfileRequest() {
        }

        protected String parameters() {
            return "urlfile=1";
        }

        protected void handleResponseData(BootstrapServer bootstrapServer, String string) {
            try {
                BootstrapServer bootstrapServer2 = new BootstrapServer(string);
                BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
                synchronized (bootstrapServerManager) {
                    BootstrapServerManager.this.addBootstrapServer(bootstrapServer2);
                }
                ++this.responses;
            }
            catch (ParseException parseException) {
                this.handleError(bootstrapServer);
            }
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }
    }

    private final class HostfileRequest
    extends GWebCacheRequest {
        private int responses = 0;

        private HostfileRequest() {
        }

        protected String parameters() {
            return "hostfile=1";
        }

        protected void handleResponseData(BootstrapServer bootstrapServer, String string) {
            try {
                Endpoint endpoint = new Endpoint(string, true);
                BootstrapServerManager.this.CATCHER.add(endpoint, true);
                ++this.responses;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleError(bootstrapServer);
            }
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }

        protected void done() {
            BootstrapServerManager.this._hostFetchInProgress = false;
        }
    }

    private abstract class GWebCacheRequest {
        private GWebCacheRequest() {
        }

        protected abstract String parameters();

        protected void handleError(BootstrapServer bootstrapServer) {
            BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
            synchronized (bootstrapServerManager) {
                BootstrapServerManager.this.SERVERS.remove(bootstrapServer);
                if (BootstrapServerManager.this._lastConnectable == bootstrapServer) {
                    BootstrapServerManager.this._lastConnectable = null;
                }
            }
        }

        protected abstract void handleResponseData(BootstrapServer var1, String var2);

        protected abstract boolean needsMoreData();

        protected void done() {
        }
    }
}

