/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.util.StringComparator;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.net.Socket;

public final class ChatManager {
    private static final ChatManager CHAT_MANAGER = new ChatManager();
    private List _chatsInProgress = Collections.synchronizedList(new LinkedList());
    private List _blockedHosts = Collections.synchronizedList(new LinkedList());

    public static ChatManager instance() {
        return CHAT_MANAGER;
    }

    public void accept(Socket socket) {
        boolean bl = SettingsManager.instance().getChatEnabled();
        if (!bl) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        String string = socket.getInetAddress().getHostAddress();
        SettingsManager settingsManager = SettingsManager.instance();
        Object[] objectArray = settingsManager.getBannedIps();
        List list = Arrays.asList(objectArray);
        if (list.contains(string)) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            ActivityCallback activityCallback = RouterService.getCallback();
            InstantMessenger instantMessenger = new InstantMessenger(socket, this, activityCallback);
            this._chatsInProgress.add(instantMessenger);
            activityCallback.acceptChat(instantMessenger);
            instantMessenger.start();
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }

    public Chatter request(String string, int n) {
        InstantMessenger instantMessenger = null;
        try {
            ActivityCallback activityCallback = RouterService.getCallback();
            instantMessenger = new InstantMessenger(string, n, this, activityCallback);
            this._chatsInProgress.add(instantMessenger);
            instantMessenger.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return instantMessenger;
    }

    public void removeChat(InstantMessenger instantMessenger) {
        this._chatsInProgress.remove(instantMessenger);
    }

    public void blockHost(String string) {
        SettingsManager settingsManager = SettingsManager.instance();
        Object[] objectArray = settingsManager.getBannedIps();
        Arrays.sort(objectArray);
        ChatManager chatManager = this;
        synchronized (chatManager) {
            if (Arrays.binarySearch(objectArray, string, new StringComparator()) < 0) {
                String[] stringArray = new String[objectArray.length + 1];
                System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
                stringArray[objectArray.length] = string;
                settingsManager.setBannedIps(stringArray);
            }
        }
    }

    public void unblockHost(String string) {
        SettingsManager settingsManager = SettingsManager.instance();
        Object[] objectArray = settingsManager.getBannedIps();
        List list = Arrays.asList(objectArray);
        ChatManager chatManager = this;
        synchronized (chatManager) {
            if (list.remove(string)) {
                settingsManager.setBannedIps((String[])list.toArray());
            }
        }
    }
}

