/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class InstantMessenger
implements Chatter {
    private Socket _socket;
    private ByteReader _reader;
    private BufferedWriter _out;
    private String _host;
    private int _port;
    private String _message = "";
    private ActivityCallback _activityCallback;
    private ChatManager _manager;
    private boolean _outgoing = false;

    public InstantMessenger(Socket socket, ChatManager chatManager, ActivityCallback activityCallback) throws IOException {
        this._manager = chatManager;
        this._socket = socket;
        this._port = socket.getPort();
        this._host = this._socket.getInetAddress().getHostAddress();
        this._activityCallback = activityCallback;
        OutputStream outputStream = this._socket.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this._out = new BufferedWriter(outputStreamWriter);
        InputStream inputStream = this._socket.getInputStream();
        this._reader = new ByteReader(inputStream);
        this.readHeader();
    }

    public InstantMessenger(String string, int n, ChatManager chatManager, ActivityCallback activityCallback) throws IOException {
        this._host = string;
        this._port = n;
        this._manager = chatManager;
        this._activityCallback = activityCallback;
        this._outgoing = true;
    }

    private void OutgoingInitializer() throws IOException {
        String string;
        this._socket = new Socket(this._host, this._port);
        this._socket.setSoTimeout(SettingsManager.instance().getTimeout());
        OutputStream outputStream = this._socket.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this._out = new BufferedWriter(outputStreamWriter);
        this._out.write("CHAT CONNECT/0.1\r\n");
        this._out.write("User-Agent: " + CommonUtils.getVendor() + "\r\n");
        this._out.write("\r\n");
        this._out.flush();
        InputStream inputStream = this._socket.getInputStream();
        this._reader = new ByteReader(inputStream);
        do {
            if ((string = this._reader.readLine()) != null) continue;
            return;
        } while (!string.equals(""));
        this._out.write("CHAT/0.1 200 OK\r\n");
        this._out.write("\r\n");
        this._out.flush();
        this._socket.setSoTimeout(0);
        this._activityCallback.acceptChat(this);
    }

    public void start() {
        MessageReader messageReader = new MessageReader(this);
        Thread thread = new Thread(messageReader);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this._manager.removeChat(this);
        try {
            this._out.close();
            this._socket.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void send(String string) {
        try {
            this._out.write(string + "\n");
            this._out.flush();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public synchronized String getMessage() {
        String string = this._message;
        this._message = "";
        return string;
    }

    public void blockHost(String string) {
        this._manager.blockHost(string);
    }

    public void readHeader() throws IOException {
        String string;
        this._socket.setSoTimeout(SettingsManager.instance().getTimeout());
        do {
            if ((string = this._reader.readLine()) != null) continue;
            return;
        } while (!string.equals(""));
        this._out.write("CHAT/0.1 200 OK\r\n");
        this._out.write("\r\n");
        this._out.flush();
        while (!(string = this._reader.readLine()).equals("")) {
            if (string != null) continue;
            return;
        }
        this._socket.setSoTimeout(0);
    }

    private class MessageReader
    implements Runnable {
        Chatter _chatter;

        public MessageReader(Chatter chatter) {
            this._chatter = chatter;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block11: {
                try {
                    if (InstantMessenger.this._outgoing) {
                        try {
                            InstantMessenger.this.OutgoingInitializer();
                        }
                        catch (IOException iOException) {
                            InstantMessenger.this._activityCallback.chatUnavailable(this._chatter);
                            return;
                        }
                    }
                    try {}
                    catch (IOException iOException) {
                        InstantMessenger.this._activityCallback.chatUnavailable(this._chatter);
                        return;
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    RouterService.error(throwable);
                }
                return;
            }
            while (true) {
                String string = InstantMessenger.this._reader.readLine();
                InstantMessenger instantMessenger = InstantMessenger.this;
                synchronized (instantMessenger) {
                    if (string == null) throw new IOException();
                    if (string == "") {
                        throw new IOException();
                    }
                    InstantMessenger.this._message = InstantMessenger.this._message + string;
                    InstantMessenger.this._activityCallback.receiveMessage(this._chatter);
                }
            }
        }
    }
}

