/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.util.BucketQueue;

public class PriorityMessageQueue
extends MessageQueue {
    private static final int PRIORITIES = 8;
    private BucketQueue _queue;

    public PriorityMessageQueue(int n, int n2, int n3) {
        super(n, n2);
        this._queue = new BucketQueue(8, n3);
    }

    public void add(Message message) {
        Message message2 = (Message)this._queue.insert(message, PriorityMessageQueue.priority(message));
        if (message2 != null) {
            message2.recordDrop();
            ++this._dropped;
        }
    }

    private static final int priority(Message message) {
        if (message instanceof QueryReply) {
            return PriorityMessageQueue.priority((QueryReply)message);
        }
        if (message instanceof PingReply) {
            return PriorityMessageQueue.bound(message.getHops());
        }
        return PriorityMessageQueue.bound(7 - message.getHops());
    }

    private static final int priority(QueryReply queryReply) {
        int n = queryReply.getPriority();
        if (n == 0) {
            return 7;
        }
        if (n < 1000) {
            return 6;
        }
        if (n < 5000) {
            return 5;
        }
        if (n < 10000) {
            return 4;
        }
        if (n < 20000) {
            return 3;
        }
        if (n < 30000) {
            return 2;
        }
        if (n < 40000) {
            return 1;
        }
        return 0;
    }

    private static final int bound(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= 8) {
            return 7;
        }
        return n;
    }

    public Message removeNextInternal() {
        if (this._queue.isEmpty()) {
            return null;
        }
        return (Message)this._queue.extractMax();
    }

    public int size() {
        return this._queue.size();
    }
}

