/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import java.io.Serializable;
import java.util.StringTokenizer;

public class AutoDownloadDetails
implements Serializable {
    static final long serialVersionUID = 3400666689236195243L;
    private String query = null;
    private String richQuery = null;
    private MediaType type = null;
    private byte[] guid = null;
    private List dlList = null;
    private static final int MATCHER_BUF_SIZE = 120;
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private float MATCH_PRECISION_DL = 0.3f;
    private float WORD_INCIDENCE_RATE = 0.509999f;
    private int LOW_SCORE = 95;
    private Set wordSet = null;
    public static final int MAX_DOWNLOADS = 1;
    private int committedDLs = 0;
    private static final boolean debugOn = false;

    public AutoDownloadDetails(String string, String string2, byte[] byArray, MediaType mediaType) {
        this.query = string;
        this.richQuery = string2;
        this.type = mediaType;
        this.guid = byArray;
        this.dlList = new Vector();
        this.wordSet = new HashSet();
    }

    public String getQuery() {
        return this.query;
    }

    public String getRichQuery() {
        return this.richQuery;
    }

    public MediaType getMediaType() {
        return this.type;
    }

    private Response deriveResponse(RemoteFileDesc remoteFileDesc) {
        Response response = null;
        response = new Response(remoteFileDesc.getIndex(), remoteFileDesc.getSize(), remoteFileDesc.getFileName());
        return response;
    }

    public synchronized boolean addDownload(RemoteFileDesc remoteFileDesc) {
        AutoDownloadDetails.debug("ADD.addDownload(): *-----------");
        AutoDownloadDetails.debug("ADD.addDownload(): entered.");
        boolean bl = true;
        if (!this.expired()) {
            Object object;
            boolean bl2;
            Response response;
            String[] stringArray;
            int n;
            String string = remoteFileDesc.getFileName();
            if (this.type != null && !this.type.matches(string)) {
                bl = false;
                AutoDownloadDetails.debug("ADD.addDownload(): file " + string + " isn't the right type.");
            }
            if ((n = ResponseVerifier.calculateScore(stringArray = ResponseVerifier.getSearchTerms(this.query, this.richQuery), response, bl2 = (response = this.deriveResponse(remoteFileDesc)).getDocument() != null)) < this.LOW_SCORE) {
                bl = false;
                AutoDownloadDetails.debug("ADD.addDownload(): file " + string + " has low score of " + n);
            }
            if (bl && this.wordSet.size() > 0) {
                object = new StringTokenizer(this.ripExtension(string), " -._+/*()\\");
                int n2 = 0;
                int n3 = ((StringTokenizer)object).countTokens();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken().toLowerCase();
                    AutoDownloadDetails.debug("ADD.addDownload(): currToken = " + string2);
                    if (this.wordSet.contains(string2)) continue;
                    ++n2;
                }
                float f = (float)(n3 - n2) / (float)this.wordSet.size();
                if (n2 == 0 || f > this.WORD_INCIDENCE_RATE) {
                    bl = false;
                    AutoDownloadDetails.debug("ADD.addDownload(): file " + string + " has many elements similar to" + " other files. matchRate = " + f + ", additions = " + n2);
                }
            }
            if (bl && this.dlList.size() > 0) {
                ApproximateMatcher approximateMatcher = matcher;
                synchronized (approximateMatcher) {
                    object = matcher.process(string);
                }
                int n4 = 0;
                while (n4 < this.dlList.size()) {
                    String string3;
                    RemoteFileDesc remoteFileDesc2 = (RemoteFileDesc)this.dlList.get(n4);
                    String string4 = remoteFileDesc2.getFileName();
                    int n5 = 0;
                    ApproximateMatcher approximateMatcher2 = matcher;
                    synchronized (approximateMatcher2) {
                        string3 = matcher.process(string4);
                        n5 = matcher.match((String)object, string3);
                    }
                    int n6 = Math.min(((String)object).length(), string3.length());
                    if ((float)n5 / (float)n6 < this.MATCH_PRECISION_DL) {
                        bl = false;
                        AutoDownloadDetails.debug("ADD.addDownload(): conflict for file " + string + " and " + string4);
                    }
                    if (!bl) break;
                    ++n4;
                }
            }
            if (bl) {
                this.dlList.add(remoteFileDesc);
                object = new StringTokenizer(this.ripExtension(string), " -._+/*()\\");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.wordSet.add(((StringTokenizer)object).nextToken().toLowerCase());
                }
                AutoDownloadDetails.debug("ADD.addDownload(): wordSet = " + this.wordSet);
            }
        } else {
            bl = false;
        }
        AutoDownloadDetails.debug("ADD.addDownload(): returning " + bl);
        AutoDownloadDetails.debug("ADD.addDownload(): -----------*");
        return bl;
    }

    public synchronized void removeDownload(RemoteFileDesc remoteFileDesc) {
        this.dlList.remove(remoteFileDesc);
        StringTokenizer stringTokenizer = new StringTokenizer(this.ripExtension(remoteFileDesc.getFileName()), " -._+/*()\\");
        while (stringTokenizer.hasMoreTokens()) {
            this.wordSet.remove(stringTokenizer.nextToken().toLowerCase());
        }
    }

    public synchronized void commitDownload(RemoteFileDesc remoteFileDesc) {
        if (this.dlList.contains(remoteFileDesc)) {
            ++this.committedDLs;
        }
    }

    public synchronized boolean expired() {
        boolean bl = false;
        if (this.committedDLs >= 1) {
            bl = true;
        }
        return bl;
    }

    private String ripExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    private static void debug(String string) {
    }

    private static void debug(Exception exception) {
    }

    static {
        matcher.setIgnoreCase(true);
        matcher.setIgnoreWhitespace(true);
        matcher.setCompareBackwards(true);
    }
}

