/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.FileIncompleteException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.ProblemReadingHeaderException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.ReaderIsNullException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Sockets;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.NoSuchElementException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class HTTPDownloader
implements BandwidthTracker {
    public static final int BUF_LENGTH = 1024;
    private RemoteFileDesc _rfd;
    private boolean _isPush;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private volatile int _amountRead;
    private volatile int _amountToRead;
    private int _initialReadingPoint;
    private ByteReader _byteReader;
    private Socket _socket;
    private File _incompleteFile;
    private AlternateLocationCollection _alternateLocationsReceived;
    private AlternateLocationCollection _alternateLocationsToSend;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();

    public HTTPDownloader(RemoteFileDesc remoteFileDesc, File file, AlternateLocationCollection alternateLocationCollection) {
        this(null, remoteFileDesc, file, alternateLocationCollection);
        this._isPush = false;
    }

    public HTTPDownloader(Socket socket, RemoteFileDesc remoteFileDesc, File file, AlternateLocationCollection alternateLocationCollection) {
        this._isPush = true;
        this._rfd = remoteFileDesc;
        this._socket = socket;
        this._incompleteFile = file;
        this._filename = remoteFileDesc.getFileName();
        this._index = remoteFileDesc.getIndex();
        this._guid = remoteFileDesc.getClientGUID();
        this._amountToRead = remoteFileDesc.getSize();
        this._port = remoteFileDesc.getPort();
        this._host = remoteFileDesc.getHost();
        this._chatEnabled = remoteFileDesc.chatEnabled();
        this._browseEnabled = remoteFileDesc.browseHostEnabled();
        this._alternateLocationsToSend = alternateLocationCollection;
        this._alternateLocationsReceived = new AlternateLocationCollection();
        this._amountRead = 0;
    }

    public AlternateLocationCollection getAlternateLocations() {
        return this._alternateLocationsReceived;
    }

    public void connectTCP(int n) throws IOException {
        InputStream inputStream = null;
        try {
            if (this._socket == null) {
                this._socket = Sockets.connect(this._host, this._port, n, true);
            }
            Sockets.setKeepAlive(this._socket, true);
            inputStream = this._socket.getInputStream();
        }
        catch (Exception exception) {
            throw new CantConnectException();
        }
        this._socket.setSoTimeout(SettingsManager.instance().getTimeout());
        this._byteReader = new ByteReader(inputStream);
    }

    public void connectHTTP(int n, int n2, boolean bl) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException {
        this._amountToRead = n2 - n;
        this._amountRead = 0;
        this._initialReadingPoint = n;
        OutputStream outputStream = this._socket.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        String string = String.valueOf(this._initialReadingPoint);
        bufferedWriter.write("GET /get/" + this._index + "/" + this._filename + " HTTP/1.1\r\n");
        bufferedWriter.write("Host: " + this._host + ":" + this._port + "\r\n");
        bufferedWriter.write("User-Agent: " + CommonUtils.getHttpServer() + "\r\n");
        if (bl) {
            bufferedWriter.write("X-Queue: 0.1\r\n");
        }
        AlternateLocationCollection alternateLocationCollection = new AlternateLocationCollection();
        AlternateLocationCollection alternateLocationCollection2 = this._alternateLocationsToSend;
        synchronized (alternateLocationCollection2) {
            alternateLocationCollection.addAlternateLocationCollection(this._alternateLocationsToSend);
        }
        URN uRN = this._rfd.getSHA1Urn();
        if (uRN != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)uRN, bufferedWriter);
        }
        if (alternateLocationCollection.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)alternateLocationCollection, bufferedWriter);
        }
        bufferedWriter.write("Range: bytes=" + string + "-" + (n2 - 1) + "\r\n");
        SettingsManager settingsManager = SettingsManager.instance();
        if (settingsManager.getChatEnabled()) {
            String string2;
            int n3;
            if (settingsManager.getForceIPAddress()) {
                n3 = settingsManager.getForcedPort();
                string2 = settingsManager.getForcedIPAddressString();
            } else {
                n3 = settingsManager.getPort();
                string2 = this._socket.getLocalAddress().getHostAddress();
            }
            bufferedWriter.write("Chat: " + string2 + ":" + n3 + "\r\n");
        }
        bufferedWriter.write("\r\n");
        bufferedWriter.flush();
        this.readHeaders();
    }

    private void readHeaders() throws IOException {
        int n;
        if (this._byteReader == null) {
            throw new ReaderIsNullException();
        }
        String string = this._byteReader.readLine();
        if (string == null || string.equals("")) {
            return;
        }
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
        }
        int n2 = HTTPDownloader.parseHTTPCode(string);
        int[] nArray = new int[]{-1, -1, -1};
        while ((string = this._byteReader.readLine()) != null && !string.equals("")) {
            if (!CommonUtils.isJava118()) {
                BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
            }
            if (string.toUpperCase().startsWith("CONTENT-RANGE:")) {
                n = HTTPDownloader.parseContentRangeStart(string);
                if (n == this._initialReadingPoint) continue;
                throw new IOException("Unexpected start offset; too dumb to recover");
            }
            if (HTTPHeaderName.ALT_LOCATION.matchesStartOfString(string)) {
                HTTPDownloader.readAlternateLocations(string, this._alternateLocationsReceived);
                continue;
            }
            if (!string.toUpperCase().startsWith("X-QUEUE")) continue;
            this.parseQueueHeaders(string, nArray);
        }
        if (n2 < 200 || n2 >= 300) {
            if (n2 == 404) {
                throw new FileNotFoundException();
            }
            if (n2 == 410) {
                throw new NotSharingException();
            }
            if (n2 == 503) {
                n = nArray[0];
                int n3 = nArray[1];
                int n4 = nArray[2];
                if (n != -1 && n3 != -1 && n4 != -1) {
                    throw new QueuedException(n, n3, n4);
                }
                throw new TryAgainLaterException();
            }
            throw new IOException();
        }
    }

    private static void readAlternateLocations(String string, AlternateLocationCollector alternateLocationCollector) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                AlternateLocation alternateLocation = AlternateLocation.createAlternateLocation(stringTokenizer.nextToken().trim());
                alternateLocationCollector.addAlternateLocation(alternateLocation);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static int parseHTTPCode(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseQueueHeaders(String var1_1, int[] var2_2) {
        if (var1_1 == null) {
            return;
        }
        var3_3 = new StringTokenizer(var1_1, " ,:=");
        if (!var3_3.hasMoreTokens()) {
            return;
        }
        var4_4 = var3_3.nextToken();
        if (var4_4.equalsIgnoreCase("X-Queue")) ** GOTO lbl28
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = var3_3.nextToken();
            try {
                if (var4_4.equalsIgnoreCase("pollMin")) {
                    var5_5 = var3_3.nextToken();
                    var2_2[0] = Integer.parseInt(var5_5);
                    continue;
                }
                if (var4_4.equalsIgnoreCase("pollMax")) {
                    var5_5 = var3_3.nextToken();
                    var2_2[1] = Integer.parseInt(var5_5);
                    continue;
                }
                if (!var4_4.equalsIgnoreCase("position")) continue;
                var5_5 = var3_3.nextToken();
                var2_2[2] = Integer.parseInt(var5_5);
                continue;
            }
            catch (NumberFormatException var6_6) {
                Arrays.fill(var2_2, -1);
                continue;
            }
            catch (NoSuchElementException var7_7) {
                Arrays.fill(var2_2, -1);
            }
lbl28:
            // 7 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl29:
        // 1 sources

    }

    private static int parseContentRangeStart(String string) throws IOException {
        int n;
        int n2;
        int n3;
        try {
            int n4 = string.indexOf("bytes") + 6;
            int n5 = string.indexOf(47);
            if (string.substring(n4, n5).equals("*")) {
                return 0;
            }
            int n6 = string.lastIndexOf("-");
            n3 = Integer.parseInt(string.substring(n4, n6));
            n2 = Integer.parseInt(string.substring(n6 + 1, n5));
            if (string.substring(n5 + 1).equals("*")) {
                return n3;
            }
            n = Integer.parseInt(string.substring(n5 + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        if (n2 == n) {
            --n3;
            --n2;
        }
        return n3;
    }

    public void doDownload(VerifyingFile verifyingFile, boolean bl) throws IOException {
        this._socket.setSoTimeout(0);
        long l = this._initialReadingPoint;
        try {
            int n;
            int n2 = -1;
            byte[] byArray = new byte[1024];
            byte[] byArray2 = new byte[1024];
            while (this._amountRead < (n = this._amountToRead)) {
                int n3 = n - this._amountRead;
                Assert.that(n3 > 0);
                n2 = this._byteReader.read(byArray, 0, Math.min(1024, n3));
                if (n2 == -1) break;
                if (!CommonUtils.isJava118()) {
                    BandwidthStat.HTTP_BODY_DOWNSTREAM_BANDWIDTH.addData(n2);
                }
                verifyingFile.writeBlock(l, n2, byArray);
                l += (long)n2;
                this._amountRead += n2;
            }
            if (this._amountRead < this._amountToRead) {
                throw new FileIncompleteException();
            }
            Object var11_9 = null;
            if (!bl) {
                this._byteReader.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (!bl) {
                this._byteReader.close();
            }
            throw throwable;
        }
    }

    public void stop() {
        if (this._byteReader != null) {
            this._byteReader.close();
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stopAt(int n) {
        this._amountToRead = n - this._initialReadingPoint;
    }

    public int getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public int getAmountRead() {
        return this._amountRead;
    }

    public int getAmountToRead() {
        return this._amountToRead;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isPush() {
        return this._isPush;
    }

    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.getAmountRead());
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    private HTTPDownloader(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this._byteReader = new ByteReader(byteArrayInputStream);
    }

    static void unitTest() {
        try {
            Assert.that(HTTPDownloader.parseContentRangeStart("Content-range: bytes 1-9/10") == 1);
            Assert.that(HTTPDownloader.parseContentRangeStart("Content-range:bytes=1-9/10") == 1);
            Assert.that(HTTPDownloader.parseContentRangeStart("Content-range:bytes */10") == 0);
            Assert.that(HTTPDownloader.parseContentRangeStart("Content-range:bytes */*") == 0);
            Assert.that(HTTPDownloader.parseContentRangeStart("Content-range:bytes 1-9/*") == 1);
            Assert.that(HTTPDownloader.parseContentRangeStart("Content-range:bytes 1-9/*") == 1);
            Assert.that(HTTPDownloader.parseContentRangeStart("Content-range:bytes 1-10/10") == 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Assert.that(false);
        }
        try {
            HTTPDownloader.parseContentRangeStart("Content-range:bytes 1 10 10");
        }
        catch (IOException iOException) {
            Assert.that(true);
        }
        boolean bl = true;
        String string = "HTTP/1.1 200 OK\r\n";
        HTTPDownloader hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        string = "HTTP/1.1 301 Moved Permanently\r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
            Assert.that(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = "HTTP/1.1 300 Multiple Choices\r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
            Assert.that(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = "HTTP/1.1 404 File Not Found \r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
            Assert.that(false);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        string = "HTTP/1.1 410 Not Sharing \r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
            Assert.that(false);
        }
        catch (NotSharingException notSharingException) {
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        string = "HTTP/1.1 412 \r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
            Assert.that(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = "HTTP/1.1 503 \r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
            Assert.that(false);
        }
        catch (TryAgainLaterException tryAgainLaterException) {
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        string = "HTTP/1.1 210 \r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        string = "HTTP/1.1 204 Partial Content\r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        string = "HTTP/1.1 200 OK\r\nUser-Agent: LimeWire\r\n\r\nx";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            Assert.that((char)hTTPDownloader._byteReader.read() == 'x');
            hTTPDownloader.stop();
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        string = "200 OK\r\n";
        hTTPDownloader = new HTTPDownloader(string);
        try {
            hTTPDownloader.readHeaders();
            hTTPDownloader.stop();
            Assert.that(false);
        }
        catch (NoHTTPOKException noHTTPOKException) {
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
    }
}

