/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

final class HeadRequester
implements Runnable {
    private final List HOSTS;
    private final URN RESOURCE_NAME;
    private final AlternateLocationCollector COLLECTOR;
    private final AlternateLocationCollection TOTAL_ALTS;

    public HeadRequester(List list, URN uRN, AlternateLocationCollector alternateLocationCollector, AlternateLocationCollection alternateLocationCollection) {
        this.HOSTS = Collections.unmodifiableList(list);
        this.RESOURCE_NAME = uRN;
        this.COLLECTOR = alternateLocationCollector;
        this.TOTAL_ALTS = alternateLocationCollection;
    }

    public void run() {
        try {
            Iterator iterator = this.HOSTS.iterator();
            while (iterator.hasNext()) {
                URL uRL;
                URN uRN;
                RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
                if (QueryReply.isFirewalledQuality(remoteFileDesc.getQuality()) || (uRN = remoteFileDesc.getSHA1Urn()) == null || !uRN.equals(this.RESOURCE_NAME) || (uRL = remoteFileDesc.getUrl()) == null) continue;
                try {
                    Object object;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("HEAD");
                    httpURLConnection.setRequestProperty("User-Agent", CommonUtils.getHttpServer());
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setAllowUserInteraction(false);
                    httpURLConnection.setRequestProperty(HTTPHeaderName.GNUTELLA_CONTENT_URN.httpStringValue(), this.RESOURCE_NAME.httpStringValue());
                    httpURLConnection.setRequestProperty(HTTPHeaderName.ALT_LOCATION.httpStringValue(), this.TOTAL_ALTS.httpStringValue());
                    httpURLConnection.setRequestProperty(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
                    httpURLConnection.connect();
                    String string = httpURLConnection.getHeaderField(HTTPHeaderName.GNUTELLA_CONTENT_URN.httpStringValue());
                    if (string == null) continue;
                    try {
                        object = URN.createSHA1Urn(string);
                        if (!((URN)object).equals(this.RESOURCE_NAME)) {
                        }
                    }
                    catch (IOException iOException) {}
                    continue;
                    object = httpURLConnection.getHeaderField(HTTPHeaderName.ALT_LOCATION.httpStringValue());
                    if (object == null) continue;
                    AlternateLocationCollection alternateLocationCollection = AlternateLocationCollection.createCollectionFromHttpValue((String)object);
                    this.COLLECTOR.addAlternateLocationCollection(alternateLocationCollection);
                    httpURLConnection.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            RouterService.getCallback().error(exception);
        }
    }
}

