/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.util.FileComparator;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IncompleteFileManager
implements Serializable {
    static final long serialVersionUID = -7658285233614679878L;
    static final String SEPARATOR = "-";
    public static final String PREVIEW_PREFIX = "Preview-";
    private Map blocks = new TreeMap(new FileComparator());
    private Map hashes = new HashMap();

    public synchronized boolean purge(boolean bl) {
        Object object;
        boolean bl2 = false;
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            if (((File)object).exists() && !IncompleteFileManager.isOld((File)object)) continue;
            bl2 = true;
            ((File)object).delete();
            iterator.remove();
        }
        if (bl) {
            object = this.hashes.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                URN uRN = (URN)entry.getKey();
                File file = (File)entry.getValue();
                if (file.exists()) continue;
                object.remove();
                bl2 = true;
            }
        }
        return bl2;
    }

    private static final boolean isOld(File file) {
        long l = file.lastModified();
        long l2 = SettingsManager.instance().getIncompletePurgeTime();
        long l3 = System.currentTimeMillis() - l2 * 24L * 60L * 60L * 1000L;
        return l < l3;
    }

    static boolean same(RemoteFileDesc remoteFileDesc, RemoteFileDesc remoteFileDesc2) {
        return IncompleteFileManager.same(remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getSHA1Urn(), remoteFileDesc2.getFileName(), remoteFileDesc2.getSize(), remoteFileDesc2.getSHA1Urn());
    }

    static boolean same(String string, int n, URN uRN, String string2, int n2, URN uRN2) {
        if (uRN != null && uRN2 != null) {
            return uRN.equals(uRN2);
        }
        return n == n2 && string.equals(string2);
    }

    public synchronized File getFile(RemoteFileDesc remoteFileDesc) {
        File file = null;
        try {
            file = SettingsManager.instance().getIncompleteDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        URN uRN = remoteFileDesc.getSHA1Urn();
        if (uRN != null) {
            File file2 = (File)this.hashes.get(uRN);
            if (file2 != null) {
                return file2;
            }
            int n = 1;
            while (true) {
                file2 = new File(file, IncompleteFileManager.tempName(remoteFileDesc.getFileName(), remoteFileDesc.getSize(), n));
                if (!this.hashes.values().contains(file2)) break;
                ++n;
            }
            this.hashes.put(uRN, file2);
            return file2;
        }
        return new File(file, IncompleteFileManager.tempName(remoteFileDesc.getFileName(), remoteFileDesc.getSize(), 0));
    }

    private static String tempName(String string, int n, int n2) {
        if (n2 <= 1) {
            return "T-" + n + SEPARATOR + string;
        }
        int n3 = string.lastIndexOf(46);
        if (n3 < 0) {
            return "T-" + n + SEPARATOR + string + " (" + n2 + ")";
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3);
        return "T-" + n + SEPARATOR + string2 + " (" + n2 + ")" + string3;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hashes = new HashMap();
        objectInputStream.defaultReadObject();
        this.blocks = this.transform(this.blocks);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        Map map = this.blocks;
        try {
            this.blocks = this.invTransform();
            objectOutputStream.defaultWriteObject();
            Object var4_3 = null;
            this.blocks = map;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.blocks = map;
            throw throwable;
        }
    }

    private Map transform(Object object) {
        Map map = (Map)object;
        TreeMap treeMap = new TreeMap(new FileComparator());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            Object object3 = map.get(object2);
            if (object3 == null) continue;
            Iterator iterator2 = ((List)object3).iterator();
            VerifyingFile verifyingFile = new VerifyingFile(true);
            while (iterator2.hasNext()) {
                Interval interval = (Interval)iterator2.next();
                --interval.high;
                if (interval.high < interval.low) continue;
                verifyingFile.addInterval(interval);
            }
            treeMap.put(object2, verifyingFile);
        }
        return treeMap;
    }

    private Map invTransform() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            VerifyingFile verifyingFile;
            ArrayList arrayList = new ArrayList();
            Object object = iterator.next();
            VerifyingFile verifyingFile2 = verifyingFile = (VerifyingFile)this.blocks.get(object);
            synchronized (verifyingFile2) {
                List list = verifyingFile.getBlocksAsList();
                int n = 0;
                while (n < list.size()) {
                    Interval interval = (Interval)list.get(n);
                    Interval interval2 = new Interval(interval.low, interval.high + 1);
                    arrayList.add(interval2);
                    ++n;
                }
            }
            hashMap.put(object, arrayList);
        }
        return hashMap;
    }

    public synchronized void removeEntry(File file) {
        this.blocks.remove(file);
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!file.equals(entry.getValue())) continue;
            iterator.remove();
        }
    }

    public synchronized void addEntry(File file, VerifyingFile verifyingFile) {
        this.blocks.put(file, verifyingFile);
    }

    public synchronized VerifyingFile getEntry(File file) {
        Object object = this.blocks.get(file);
        return (VerifyingFile)object;
    }

    public synchronized int getBlockSize(File file) {
        Object object = this.blocks.get(file);
        if (object == null) {
            return 0;
        }
        VerifyingFile verifyingFile = (VerifyingFile)object;
        return verifyingFile.getBlockSize();
    }

    public static String getCompletedName(File file) throws IllegalArgumentException {
        String string = file.getName();
        int n = string.indexOf(SEPARATOR);
        if (n < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        int n2 = string.indexOf(SEPARATOR, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        if (n2 == string.length() - 1) {
            throw new IllegalArgumentException("No name after last separator");
        }
        return string.substring(n2 + 1);
    }

    public static long getCompletedSize(File file) throws IllegalArgumentException {
        String string = file.getName();
        int n = string.indexOf(SEPARATOR);
        if (n < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        int n2 = string.indexOf(SEPARATOR, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        try {
            return Long.parseLong(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad number format: " + string);
        }
    }

    public synchronized URN getCompletedHash(File file) {
        Iterator iterator = this.hashes.keySet().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (!this.hashes.get(uRN).equals(file)) continue;
            return uRN;
        }
        return null;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        boolean bl = true;
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            File file = (File)iterator.next();
            List list = ((VerifyingFile)this.blocks.get(file)).getBlocksAsList();
            stringBuffer.append(file);
            stringBuffer.append(":");
            stringBuffer.append(list.toString());
            bl = false;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static void unitTest() {
        File file = new File("C:/tmp/test.txt");
        IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
        Iterator iterator = null;
        VerifyingFile verifyingFile = new VerifyingFile(true);
        Assert.that(incompleteFileManager.getEntry(file) == null);
        Assert.that(incompleteFileManager.getBlockSize(file) == 0);
        verifyingFile.addInterval(new Interval(0, 10));
        incompleteFileManager.addEntry(file, verifyingFile);
        Assert.that(incompleteFileManager.getBlockSize(file) == 11);
        iterator = incompleteFileManager.getEntry(file).getBlocks();
        Assert.that(iterator.next().equals(new Interval(0, 10)));
        Assert.that(!iterator.hasNext());
        SettingsManager.instance().setIncompletePurgeTime(26);
        FakeTimedFile fakeTimedFile = new FakeTimedFile(25);
        FakeTimedFile fakeTimedFile2 = new FakeTimedFile(27);
        Assert.that(!IncompleteFileManager.isOld(fakeTimedFile));
        Assert.that(IncompleteFileManager.isOld(fakeTimedFile2));
    }

    static class FakeTimedFile
    extends File {
        private long days;

        FakeTimedFile(int n) {
            super("whatever.txt");
            this.days = n;
        }

        public long lastModified() {
            return System.currentTimeMillis() - this.days * 24L * 60L * 60L * 1000L;
        }
    }
}

