/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HeadRequester;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.InvalidPathException;
import com.limegroup.gnutella.downloader.MiniRemoteFileDesc;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RemoteFileDesc2;
import com.limegroup.gnutella.downloader.RemoteFileDescGrouper;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.StringTokenizer;

public class ManagedDownloader
implements Downloader,
Serializable {
    static final long serialVersionUID = 2772570805975885257L;
    private Object stealLock;
    private DownloadManager manager;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager;
    private ActivityCallback callback;
    private RemoteFileDesc[] allFiles;
    private static final int TRIES = 300;
    private static final int PUSH_TRIES = 2;
    private static final int NORMAL_CONNECT_TIME = 4000;
    private static final int PUSH_CONNECT_TIME = 10000;
    private static final int PUSH_INVALIDATE_TIME = 300;
    private static final int MIN_SPLIT_SIZE = 100000;
    private static final int CHUNK_SIZE = 100000;
    private static final float MIN_ACCEPTABLE_SPEED = SettingsManager.instance().getMaxDownstreamBytesPerSec() < 8 ? 0.1f : 0.5f;
    private static final int OVERLAP_BYTES = 10;
    static int TIME_BETWEEN_REQUERIES = 300000;
    private static final int REQUERY_ATTEMPTS = 60;
    private static final int MATCHER_BUF_SIZE = 120;
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private RemoteFileDescGrouper buckets;
    private int bucketNumber;
    private Thread dloaderManagerThread;
    private boolean stopped;
    private List dloaders;
    private List threads;
    private List needed;
    private List busy;
    private List files;
    private volatile int queuedCount;
    private AlternateLocationCollection totalAlternateLocations;
    private VerifyingFile commonOutFile;
    private Map miniRFDToLock;
    private Map threadLockToSocket;
    private int state;
    private long stateTime;
    private int retriesWaiting;
    private File incompleteFile;
    private File completeFile;
    private String queuePosition;
    private String currentLocation;
    private volatile int corruptFileBytes;
    private volatile File corruptFile;
    private RequeryLock reqLock = new RequeryLock();
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private int corruptState;
    private Object corruptStateLock;
    private static final BandwidthTrackerImpl BANDWIDTH_TRACKER_IMPL = new BandwidthTrackerImpl();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private static final List TRIVIAL_WORDS = new ArrayList(3);
    private boolean initDone;
    private final long SIXTY_KB = 60000L;
    private final boolean debugOn = false;
    private final boolean log = false;
    PrintWriter writer;

    public ManagedDownloader(RemoteFileDesc[] remoteFileDescArray, IncompleteFileManager incompleteFileManager) {
        TRIVIAL_WORDS.add("the");
        TRIVIAL_WORDS.add("an");
        TRIVIAL_WORDS.add("a");
        this.initDone = false;
        this.SIXTY_KB = 60000L;
        this.debugOn = false;
        this.log = false;
        this.writer = null;
        this.allFiles = remoteFileDescArray;
        this.incompleteFileManager = incompleteFileManager;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.allFiles);
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            objectOutputStream.writeObject(this.incompleteFileManager);
        }
        objectOutputStream.writeObject(BANDWIDTH_TRACKER_IMPL);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.allFiles = (RemoteFileDesc[])objectInputStream.readObject();
        this.incompleteFileManager = (IncompleteFileManager)objectInputStream.readObject();
        objectInputStream.readObject();
        this.reqLock = new RequeryLock();
    }

    public void initialize(DownloadManager downloadManager, FileManager fileManager, ActivityCallback activityCallback) {
        this.manager = downloadManager;
        this.fileManager = fileManager;
        this.callback = activityCallback;
        this.dloaders = new LinkedList();
        this.threads = new ArrayList();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stealLock = new Object();
        this.stopped = false;
        this.setState(0);
        this.miniRFDToLock = Collections.synchronizedMap(new HashMap());
        this.threadLockToSocket = Collections.synchronizedMap(new HashMap());
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.dloaderManagerThread = new Thread(){

            public void run() {
                try {
                    ManagedDownloader.this.tryAllDownloads();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    ManagedDownloader.this.manager.internalError(throwable);
                }
            }
        };
        this.dloaderManagerThread.setDaemon(true);
        this.dloaderManagerThread.start();
    }

    protected void initializeIncompleteFile(File file) {
        if (this.incompleteFile != null) {
            return;
        }
        this.incompleteFile = file;
        this.commonOutFile = this.incompleteFileManager.getEntry(file);
    }

    public boolean conflicts(RemoteFileDesc remoteFileDesc) {
        File file = this.incompleteFileManager.getFile(remoteFileDesc);
        return this.conflicts(file);
    }

    public boolean conflicts(File file) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            int n = 0;
            while (n < this.allFiles.length) {
                RemoteFileDesc remoteFileDesc = this.allFiles[n];
                File file2 = this.incompleteFileManager.getFile(remoteFileDesc);
                if (file2.equals(file)) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        return false;
    }

    protected synchronized QueryRequest newRequery() throws CantResumeException {
        if (this.allFiles.length < 0) {
            throw new CantResumeException("");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(true), SettingsManager.instance().getTTL(), 0, this.extractQueryString(), null, true, null, this.extractUrns());
    }

    private final Set extractUrns() {
        HashSet hashSet = new HashSet(2);
        int n = 0;
        while (n < this.allFiles.length && hashSet.size() < 2) {
            URN uRN = this.allFiles[n].getSHA1Urn();
            if (uRN != null) {
                hashSet.add(uRN);
            }
            ++n;
        }
        return hashSet;
    }

    private final String extractQueryString() {
        Assert.that(this.allFiles.length > 0, "Precondition violated");
        Set set = ManagedDownloader.keywords(this.allFiles[0].getFileName());
        int n = 1;
        while (n < this.allFiles.length) {
            set.retainAll(ManagedDownloader.keywords(this.allFiles[n].getFileName()));
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static final Set keywords(String string) {
        string = ManagedDownloader.ripExtension(string);
        HashSet hashSet = new HashSet();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -._+/*()\\");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            try {
                Double d = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (TRIVIAL_WORDS.contains(string2)) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    private static String ripExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        Object object;
        if (!this.initDone) {
            object = matcher;
            synchronized (object) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            this.initDone = true;
        }
        if (remoteFileDesc.getQuality() < 1) {
            return false;
        }
        object = remoteFileDesc.getSHA1Urn();
        String string = remoteFileDesc.getFileName();
        long l = remoteFileDesc.getSize();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            int n = 0;
            while (n < this.allFiles.length) {
                RemoteFileDesc remoteFileDesc2 = this.allFiles[n];
                URN uRN = remoteFileDesc2.getSHA1Urn();
                if (object != null && uRN != null) {
                    boolean bl = ((URN)object).equals(uRN);
                    return bl;
                }
                String string2 = remoteFileDesc2.getFileName();
                long l2 = remoteFileDesc2.getSize();
                if (this.sizeClose(l, l2) && this.namesClose(string, string2)) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        return false;
    }

    private final boolean sizeClose(long l, long l2) {
        boolean bl = false;
        if (l == l2) {
            bl = true;
        } else {
            long l3 = Math.abs(l - l2);
            if (l3 <= 60000L) {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean namesClose(String string, String string2) {
        boolean bl = false;
        int n = Math.round(Math.min(0.1f * (float)ManagedDownloader.ripExtension(string).length(), 0.1f * (float)ManagedDownloader.ripExtension(string2).length()));
        n = Math.min(n, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            bl = matcher.matches(matcher.process(string), matcher.process(string2), n);
        }
        this.debug("MD.namesClose(): one = " + string);
        this.debug("MD.namesClose(): two = " + string2);
        this.debug("MD.namesClose(): retVal = " + bl);
        return bl;
    }

    public synchronized boolean addDownload(RemoteFileDesc remoteFileDesc) {
        if (!this.allowAddition(remoteFileDesc)) {
            return false;
        }
        int n = 0;
        while (n < this.allFiles.length) {
            if (remoteFileDesc.equals(this.allFiles[n])) {
                return true;
            }
            ++n;
        }
        if (this.buckets != null) {
            this.buckets.add(remoteFileDesc);
        }
        RemoteFileDesc[] remoteFileDescArray = new RemoteFileDesc[this.allFiles.length + 1];
        System.arraycopy(this.allFiles, 0, remoteFileDescArray, 0, this.allFiles.length);
        remoteFileDescArray[remoteFileDescArray.length - 1] = remoteFileDesc;
        this.allFiles = remoteFileDescArray;
        if (this.state == 3 || this.state == 8) {
            this.reqLock.release();
        } else {
            this.notify();
        }
        return true;
    }

    public boolean acceptDownload(String string, Socket socket, int n, byte[] byArray) throws IOException {
        MiniRemoteFileDesc miniRemoteFileDesc = new MiniRemoteFileDesc(string, n, byArray);
        Object object = this.miniRFDToLock.get(miniRemoteFileDesc);
        if (object == null) {
            return false;
        }
        this.threadLockToSocket.put(object, socket);
        Object object2 = object;
        synchronized (object2) {
            object.notify();
        }
        return true;
    }

    public synchronized void stop() {
        this.stopped = true;
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            ((HTTPDownloader)iterator.next()).stop();
        }
        Iterator iterator2 = this.threads.iterator();
        while (iterator2.hasNext()) {
            ((Thread)iterator2.next()).interrupt();
        }
        if (this.dloaderManagerThread != null) {
            this.dloaderManagerThread.interrupt();
        }
    }

    public boolean resume() throws AlreadyDownloadingException {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.state != 3 && this.state != 6 && this.state != 5 && this.state != 8) {
                boolean bl = false;
                return bl;
            }
        }
        String string = this.manager.conflicts(this.allFiles, this);
        if (string != null) {
            throw new AlreadyDownloadingException(string);
        }
        ManagedDownloader managedDownloader2 = this;
        synchronized (managedDownloader2) {
            if (this.state == 6 || this.state == 5) {
                this.initialize(this.manager, this.fileManager, this.callback);
            } else if (this.state == 3) {
                if (this.dloaderManagerThread != null) {
                    this.dloaderManagerThread.interrupt();
                }
            } else if (this.state == 8) {
                this.reqLock.release();
            }
            boolean bl = true;
            return bl;
        }
    }

    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 9) {
            return this.corruptFile;
        }
        if (this.state != 4) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            int n = this.amountForPreview();
            if (n <= 0) {
                return null;
            }
            if (CommonUtils.copy(this.incompleteFile, n, file) <= 0) {
                return null;
            }
            return file;
        }
        return this.completeFile;
    }

    private synchronized int amountForPreview() {
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            Iterator iterator = this.commonOutFile.getBlocks();
            while (iterator.hasNext()) {
                Interval interval = (Interval)iterator.next();
                if (interval.low != 0) continue;
                int n = interval.high;
                return n;
            }
        }
        return 0;
    }

    private void tryAllDownloads() {
        int n = 0;
        long l = System.currentTimeMillis() + (long)TIME_BETWEEN_REQUERIES;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
        }
        while (true) {
            try {
                while (true) {
                    boolean bl;
                    block27: {
                        this.setState(0);
                        this.queuePosition = "";
                        this.queuedCount = 0;
                        this.manager.waitForSlot(this);
                        bl = false;
                        this.bucketNumber = 0;
                        try {
                            Iterator iterator = this.buckets.buckets();
                            while (iterator.hasNext()) {
                                this.cleanup();
                                this.files = (List)iterator.next();
                                if (this.checkHosts()) {
                                    this.setState(6);
                                    return;
                                }
                                if (this.files.size() > 0) {
                                    int n2 = this.tryAllDownloads2();
                                    if (n2 == 4) {
                                        this.setState(4);
                                        this.manager.remove(this, true);
                                        return;
                                    }
                                    if (n2 == 7) {
                                        this.setState(7);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (n2 == 9) {
                                        this.setState(9);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (n2 == 3) {
                                        bl = true;
                                    } else {
                                        Assert.that(n2 == 6, "Bad status from tad2: " + n2);
                                    }
                                }
                                ++this.bucketNumber;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.stopped) break block27;
                            this.manager.internalError(interruptedException);
                        }
                    }
                    this.manager.yieldSlot(this);
                    if (this.stopped) {
                        this.setState(5);
                        this.manager.remove(this, false);
                        return;
                    }
                    long l2 = System.currentTimeMillis();
                    if (l2 >= l && n < 60) {
                        try {
                            if (this.manager.sendQuery(this, this.newRequery())) {
                                ++n;
                            }
                        }
                        catch (CantResumeException cantResumeException) {
                            // empty catch block
                        }
                        l = l2 + (long)TIME_BETWEEN_REQUERIES;
                    }
                    if (bl) {
                        ManagedDownloader managedDownloader2 = this;
                        synchronized (managedDownloader2) {
                            this.retriesWaiting = 0;
                            Iterator iterator = this.buckets.buckets();
                            while (iterator.hasNext()) {
                                List list = (List)iterator.next();
                                this.retriesWaiting += list.size();
                            }
                        }
                        long l3 = this.calculateWaitTime();
                        this.setState(3, l3);
                        this.reqLock.lock(l3);
                        continue;
                    }
                    if (n > 60) break;
                    long l4 = l - System.currentTimeMillis();
                    if (l4 <= 0L) continue;
                    this.setState(8, l4);
                    this.reqLock.lock(l4);
                }
                this.setState(6);
                this.manager.remove(this, false);
                return;
            }
            catch (InterruptedException interruptedException) {
                if (!this.stopped) continue;
                this.setState(5);
                this.manager.remove(this, false);
                return;
            }
            break;
        }
    }

    private long calculateWaitTime() {
        return 60000L;
    }

    private int tryAllDownloads2() throws InterruptedException {
        FileDesc fileDesc;
        Object object;
        Object object2;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.files.size() == 0) {
                int n = 6;
                return n;
            }
        }
        RemoteFileDesc remoteFileDesc = null;
        ManagedDownloader managedDownloader2 = this;
        synchronized (managedDownloader2) {
            remoteFileDesc = (RemoteFileDesc)this.files.get(0);
        }
        int n = remoteFileDesc.getSize();
        String string = remoteFileDesc.getFileName();
        this.incompleteFile = this.incompleteFileManager.getFile(remoteFileDesc);
        try {
            File file = SettingsManager.instance().getSaveDirectory();
            this.completeFile = new File(file, string);
            object2 = file.getCanonicalPath();
            String string2 = new File(this.completeFile.getParent()).getCanonicalPath();
            if (!((String)object2).equals(string2)) {
                throw new InvalidPathException();
            }
        }
        catch (IOException iOException) {
            return 7;
        }
        this.totalAlternateLocations = new AlternateLocationCollection();
        ManagedDownloader managedDownloader3 = this;
        synchronized (managedDownloader3) {
            Iterator iterator = this.files.iterator();
            while (iterator.hasNext()) {
                object2 = (RemoteFileDesc)iterator.next();
                if (((RemoteFileDesc)object2).getSHA1Urn() == null) continue;
                try {
                    this.totalAlternateLocations.addAlternateLocation(AlternateLocation.createAlternateLocation((RemoteFileDesc)object2));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        int n2 = -1;
        try {
            n2 = this.tryAllDownloads3();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.commonOutFile.close();
        if (this.corruptState != 0) {
            object = this.corruptStateLock;
            synchronized (object) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (this.corruptState == 3) {
                // empty if block
            }
        }
        if (n2 == -1) {
            throw new InterruptedException();
        }
        if (n2 != 4) {
            return n2;
        }
        object = this.buckets.getURNForBucket(this.bucketNumber);
        URN uRN = null;
        try {
            this.setState(11);
            uRN = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object != null) {
            Object object3 = this.corruptStateLock;
            synchronized (object3) {
                if (!((URN)object).equals(uRN)) {
                    this.setState(9);
                    this.promptAboutCorruptDownload();
                    this.debug("hash verification problem, fileHash=" + uRN + ", bucketHash=" + object);
                }
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
        }
        this.setState(12);
        this.completeFile.delete();
        if (!this.incompleteFile.renameTo(this.completeFile) && !CommonUtils.copy(this.incompleteFile, this.completeFile)) {
            return 7;
        }
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (this.fileExists(this.completeFile)) {
            this.fileManager.removeFileIfShared(this.completeFile);
        }
        boolean bl = this.fileManager.addFileIfShared(this.completeFile, this.getXMLDocuments());
        if (this.totalAlternateLocations != null && bl && (fileDesc = this.fileManager.getFileDescMatching(this.completeFile)) != null) {
            fileDesc.addAlternateLocationCollection(this.totalAlternateLocations);
            this.callback.handleSharedFileUpdate(this.completeFile);
            HeadRequester headRequester = new HeadRequester(this.files, uRN, fileDesc, this.totalAlternateLocations);
            Thread thread = new Thread(headRequester);
            thread.setDaemon(true);
            thread.start();
        }
        return 4;
    }

    private boolean fileExists(File file) {
        boolean bl = false;
        try {
            File file2 = SettingsManager.instance().getSaveDirectory();
            String string = file.getName();
            File file3 = new File(file2, string);
            if (file3.exists()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private void cleanupCorrupt(File file, String string) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(file);
        boolean bl = false;
        int n = 0;
        while (n < 10 && !bl) {
            this.corruptFile = new File(file.getParent(), "CORRUPT-" + n + "-" + string);
            if (!this.corruptFile.exists()) {
                bl = file.renameTo(this.corruptFile);
            }
            ++n;
        }
        if (!bl) {
            file.delete();
            this.corruptFile = null;
        }
    }

    private int tryAllDownloads3() throws InterruptedException {
        Object object;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.needed = new ArrayList();
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)this.files.get(0);
            File file = this.incompleteFileManager.getFile(remoteFileDesc);
            object = this.incompleteFileManager;
            synchronized (object) {
                this.commonOutFile = this.incompleteFileManager.getEntry(file);
            }
            if (this.commonOutFile == null) {
                this.debug("creating a verifying file");
                this.commonOutFile = new VerifyingFile(true);
                this.incompleteFileManager.addEntry(file, this.commonOutFile);
            }
            try {
                this.commonOutFile.open(file, this);
            }
            catch (IOException iOException) {
                int n = 7;
                return n;
            }
            Iterator iterator = this.commonOutFile.getFreeBlocks(remoteFileDesc.getSize());
            while (iterator.hasNext()) {
                this.needed.add((Interval)iterator.next());
            }
        }
        this.busy = new LinkedList();
        int n = -1;
        int n2 = -1;
        Assert.that(this.threads.size() == 0);
        while (true) {
            Serializable serializable;
            Thread thread;
            object = this.stealLock;
            synchronized (object) {
                ManagedDownloader managedDownloader2 = this;
                synchronized (managedDownloader2) {
                    if (this.stopped) {
                        this.debug("MANAGER: terminating because of stop");
                        throw new InterruptedException();
                    }
                    if (this.dloaders.size() == 0 && this.needed.size() == 0) {
                        int n3 = this.threads.size();
                        while (n3 > 0) {
                            thread = (Thread)this.threads.get(n3 - 1);
                            thread.interrupt();
                            --n3;
                        }
                        this.debug("MANAGER: terminating because of completion");
                        int n4 = 4;
                        return n4;
                    }
                    if (this.threads.size() == 0 && this.files.size() == 0) {
                        if (this.busy.size() > 0) {
                            this.debug("MANAGER: terminating with busy");
                            this.files.addAll(this.busy);
                            int n5 = 3;
                            return n5;
                        }
                        this.debug("MANAGER: terminating w/o hope");
                        int n6 = 6;
                        return n6;
                    }
                    n = this.files.size();
                    n2 = this.getNumAllowedDownloads();
                }
            }
            int n7 = 0;
            while (n7 < n2 && n7 < n) {
                serializable = this.removeBest(this.files);
                thread = new Thread((RemoteFileDesc)serializable){
                    private final /* synthetic */ RemoteFileDesc val$rfd;
                    {
                        this.val$rfd = remoteFileDesc;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        ManagedDownloader managedDownloader;
                        boolean bl = false;
                        try {
                            try {
                                bl = ManagedDownloader.this.connectAndDownload(this.val$rfd);
                            }
                            catch (Throwable throwable) {
                                ManagedDownloader.this.manager.internalError(throwable);
                                Object var4_3 = null;
                                ManagedDownloader managedDownloader3 = ManagedDownloader.this;
                                synchronized (managedDownloader3) {
                                    ManagedDownloader.this.threads.remove(this);
                                    if (!bl) return;
                                    ManagedDownloader.this.notifyAll();
                                    return;
                                }
                            }
                            Object var4_2 = null;
                            managedDownloader = ManagedDownloader.this;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            ManagedDownloader managedDownloader2 = ManagedDownloader.this;
                            synchronized (managedDownloader2) {
                                ManagedDownloader.this.threads.remove(this);
                                if (!bl) throw throwable;
                                ManagedDownloader.this.notifyAll();
                                throw throwable;
                            }
                        }
                        synchronized (managedDownloader) {
                            ManagedDownloader.this.threads.remove(this);
                            if (!bl) return;
                            ManagedDownloader.this.notifyAll();
                            return;
                        }
                    }
                };
                thread.start();
                ManagedDownloader managedDownloader3 = this;
                synchronized (managedDownloader3) {
                    this.threads.add(thread);
                }
                ++n7;
            }
            serializable = this;
            synchronized (serializable) {
                try {
                    this.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean connectAndDownload(RemoteFileDesc remoteFileDesc) {
        HTTPDownloader hTTPDownloader = null;
        hTTPDownloader = this.establishConnection(remoteFileDesc);
        if (hTTPDownloader == null) {
            return true;
        }
        boolean bl = true;
        while (bl) {
            Object object;
            int n;
            boolean bl2 = false;
            boolean bl3 = bl = !remoteFileDesc.getUrns().isEmpty();
            while ((n = this.assignAndRequest(hTTPDownloader, (int[])(object = new int[]{-1}), bl)) == 1) {
                if (!bl2) {
                    ManagedDownloader managedDownloader = this;
                    synchronized (managedDownloader) {
                        ++this.queuedCount;
                    }
                    bl2 = true;
                }
                try {
                    if (object[0] <= 0) continue;
                    Thread.sleep(object[0]);
                }
                catch (InterruptedException interruptedException) {
                    this.debug("worker: interrupted while asleep in queue" + hTTPDownloader);
                    ManagedDownloader managedDownloader = this;
                    synchronized (managedDownloader) {
                        --this.queuedCount;
                    }
                    hTTPDownloader.stop();
                    return true;
                }
            }
            if (bl2) {
                object = this;
                synchronized (object) {
                    --this.queuedCount;
                }
            }
            Assert.that(n == 0 || n == 2 || n == 3, "invalid return from assignAndRequest " + n);
            if (n == 0) {
                return true;
            }
            if (n == 3) {
                return false;
            }
            this.doDownload(hTTPDownloader, bl);
        }
        return true;
    }

    private HTTPDownloader establishConnection(RemoteFileDesc remoteFileDesc) {
        HTTPDownloader hTTPDownloader;
        if (remoteFileDesc == null) {
            return null;
        }
        if (this.stopped) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.files.add(remoteFileDesc);
            }
            return null;
        }
        File file = this.incompleteFileManager.getFile(remoteFileDesc);
        boolean bl = ManagedDownloader.needsPush(remoteFileDesc);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.currentLocation = remoteFileDesc.getHost();
            if (this.dloaders.size() == 0 && this.getState() != 4 && this.getState() != 5 && this.getState() != 6 && this.getState() != 7 && this.getState() != 9 && this.queuedCount == 0) {
                this.setState(1, bl ? 10000L : 4000L);
            }
        }
        this.debug("WORKER: attempting connect to " + remoteFileDesc.getHost() + ":" + remoteFileDesc.getPort());
        if (!bl) {
            hTTPDownloader = new HTTPDownloader(remoteFileDesc, file, this.totalAlternateLocations);
            try {
                hTTPDownloader.connectTCP(4000);
                return hTTPDownloader;
            }
            catch (CantConnectException cantConnectException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = new Object();
        MiniRemoteFileDesc miniRemoteFileDesc = new MiniRemoteFileDesc(remoteFileDesc.getFileName(), remoteFileDesc.getIndex(), remoteFileDesc.getClientGUID());
        this.miniRFDToLock.put(miniRemoteFileDesc, object);
        Object object2 = object;
        synchronized (object2) {
            this.manager.sendPush(remoteFileDesc);
            try {
                object.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                HTTPDownloader hTTPDownloader2 = null;
                return hTTPDownloader2;
            }
        }
        Socket socket = (Socket)this.threadLockToSocket.remove(object);
        if (socket == null) {
            return null;
        }
        this.miniRFDToLock.remove(miniRemoteFileDesc);
        hTTPDownloader = new HTTPDownloader(socket, remoteFileDesc, file, this.totalAlternateLocations);
        try {
            hTTPDownloader.connectTCP(0);
        }
        catch (IOException iOException) {
            return null;
        }
        return hTTPDownloader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int assignAndRequest(HTTPDownloader hTTPDownloader, int[] nArray, boolean bl) {
        Object object = this.stealLock;
        // MONITORENTER : object
        boolean bl2 = true;
        try {
            try {
                if (this.needed.size() > 0) {
                    this.assignWhite(hTTPDownloader, bl);
                } else {
                    bl2 = false;
                    this.assignGrey(hTTPDownloader, bl);
                }
                bl2 = false;
            }
            catch (NoSuchElementException noSuchElementException) {
                Assert.that(!bl2, "updateNeeded not false in assignAndRequest");
                this.debug("nsex thrown in assingAndRequest " + hTTPDownloader);
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.files.add(hTTPDownloader.getRemoteFileDesc());
                // MONITOREXIT : managedDownloader
                int n = 3;
                Object var16_7 = null;
                ManagedDownloader managedDownloader4 = this;
                // MONITORENTER : managedDownloader4
                this.addAlternateLocations(hTTPDownloader.getAlternateLocations(), hTTPDownloader.getRemoteFileDesc());
                // MONITOREXIT : managedDownloader4
                if (bl2) {
                    this.updateNeeded(hTTPDownloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (TryAgainLaterException tryAgainLaterException) {
                this.debug("talx thrown in assignAndRequest" + hTTPDownloader);
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.busy.add(hTTPDownloader.getRemoteFileDesc());
                // MONITOREXIT : managedDownloader
                int n = 0;
                Object var16_8 = null;
                ManagedDownloader managedDownloader6 = this;
                // MONITORENTER : managedDownloader6
                this.addAlternateLocations(hTTPDownloader.getAlternateLocations(), hTTPDownloader.getRemoteFileDesc());
                // MONITOREXIT : managedDownloader6
                if (bl2) {
                    this.updateNeeded(hTTPDownloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.debug("fnfx thrown in assignAndRequest " + hTTPDownloader);
                int n = 0;
                Object var16_9 = null;
                ManagedDownloader managedDownloader7 = this;
                // MONITORENTER : managedDownloader7
                this.addAlternateLocations(hTTPDownloader.getAlternateLocations(), hTTPDownloader.getRemoteFileDesc());
                // MONITOREXIT : managedDownloader7
                if (bl2) {
                    this.updateNeeded(hTTPDownloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (NotSharingException notSharingException) {
                this.debug("nsx thrown in assignAndRequest " + hTTPDownloader);
                int n = 0;
                Object var16_10 = null;
                ManagedDownloader managedDownloader8 = this;
                // MONITORENTER : managedDownloader8
                this.addAlternateLocations(hTTPDownloader.getAlternateLocations(), hTTPDownloader.getRemoteFileDesc());
                // MONITOREXIT : managedDownloader8
                if (bl2) {
                    this.updateNeeded(hTTPDownloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (QueuedException queuedException) {
                this.debug("queuedEx thrown in AssignAndRequest sleeping.." + hTTPDownloader);
                nArray[0] = queuedException.getMinPollTime() * 1000 + 1000;
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                if (this.dloaders.size() == 0) {
                    this.setState(10);
                }
                int n = this.queuePosition.equals("") ? Integer.MAX_VALUE : Integer.parseInt(this.queuePosition);
                int n2 = queuedException.getQueuePosition();
                this.queuePosition = n < n2 ? "" + n : "" + n2;
                // MONITOREXIT : managedDownloader
                n = 1;
                Object var16_11 = null;
                ManagedDownloader managedDownloader10 = this;
                // MONITORENTER : managedDownloader10
                this.addAlternateLocations(hTTPDownloader.getAlternateLocations(), hTTPDownloader.getRemoteFileDesc());
                // MONITOREXIT : managedDownloader10
                if (bl2) {
                    this.updateNeeded(hTTPDownloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (IOException iOException) {
                this.debug("iox thrown in assignAndRequest " + hTTPDownloader);
                int n = 0;
                Object var16_12 = null;
                ManagedDownloader managedDownloader11 = this;
                // MONITORENTER : managedDownloader11
                this.addAlternateLocations(hTTPDownloader.getAlternateLocations(), hTTPDownloader.getRemoteFileDesc());
                // MONITOREXIT : managedDownloader11
                if (bl2) {
                    this.updateNeeded(hTTPDownloader);
                }
                // MONITOREXIT : object
                return n;
            }
            Object var16_6 = null;
            ManagedDownloader managedDownloader = this;
            // MONITORENTER : managedDownloader
            this.addAlternateLocations(hTTPDownloader.getAlternateLocations(), hTTPDownloader.getRemoteFileDesc());
            // MONITOREXIT : managedDownloader
            if (bl2) {
                this.updateNeeded(hTTPDownloader);
            }
        }
        catch (Throwable throwable) {
            Object var16_13 = null;
            ManagedDownloader managedDownloader2 = this;
            // MONITORENTER : managedDownloader2
            this.addAlternateLocations(hTTPDownloader.getAlternateLocations(), hTTPDownloader.getRemoteFileDesc());
            // MONITOREXIT : managedDownloader2
            if (!bl2) throw throwable;
            this.updateNeeded(hTTPDownloader);
            throw throwable;
        }
        ManagedDownloader managedDownloader = this;
        // MONITORENTER : managedDownloader
        this.setState(2);
        // MONITOREXIT : managedDownloader
        if (this.stopped) {
            this.debug("Stopped in assignAndRequest");
            this.updateNeeded(hTTPDownloader);
            ManagedDownloader managedDownloader2 = this;
            // MONITORENTER : managedDownloader2
            this.files.add(hTTPDownloader.getRemoteFileDesc());
            // MONITOREXIT : managedDownloader2
            int n = 0;
            // MONITOREXIT : object
            return n;
        }
        ManagedDownloader managedDownloader3 = this;
        // MONITORENTER : managedDownloader3
        this.dloaders.add(hTTPDownloader);
        this.chatList.addHost(hTTPDownloader);
        this.browseList.addHost(hTTPDownloader);
        // MONITOREXIT : managedDownloader3
        int n = 2;
        // MONITOREXIT : object
        return n;
    }

    private void addAlternateLocations(AlternateLocationCollection alternateLocationCollection, RemoteFileDesc remoteFileDesc) {
        if (alternateLocationCollection == null || !alternateLocationCollection.hasAlternateLocations()) {
            return;
        }
        AlternateLocationCollection alternateLocationCollection2 = null;
        AlternateLocationCollection alternateLocationCollection3 = this.totalAlternateLocations;
        synchronized (alternateLocationCollection3) {
            alternateLocationCollection2 = this.totalAlternateLocations.diffAlternateLocationCollection(alternateLocationCollection);
            this.totalAlternateLocations.addAlternateLocationCollection(alternateLocationCollection);
        }
        Iterator iterator = alternateLocationCollection2.values().iterator();
        while (iterator.hasNext()) {
            AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
            RemoteFileDesc remoteFileDesc2 = alternateLocation.createRemoteFileDesc(remoteFileDesc.getSize(), remoteFileDesc.getUrns());
            if (remoteFileDesc2 == null) continue;
            this.addDownload(remoteFileDesc2);
        }
    }

    private void assignWhite(HTTPDownloader hTTPDownloader, boolean bl) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException {
        Interval interval = null;
        if (!bl) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                interval = (Interval)this.needed.remove(0);
            }
        }
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Interval interval2 = (Interval)this.needed.remove(0);
            if (interval2.high - interval2.low + 1 > 100000) {
                int n = interval2.low + 100000 - 1;
                interval = new Interval(interval2.low, n);
                interval2 = new Interval(n + 1, interval2.high);
                this.needed.add(0, interval2);
            } else {
                interval = interval2;
            }
        }
        hTTPDownloader.connectHTTP(this.getOverlapOffset(interval.low), interval.high + 1, true);
        hTTPDownloader.stopAt(interval.high + 1);
        this.debug("WORKER: picking white " + interval + " to " + hTTPDownloader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignGrey(HTTPDownloader hTTPDownloader, boolean bl) throws NoSuchElementException, IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException {
        HTTPDownloader hTTPDownloader2 = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Iterator iterator = this.dloaders.iterator();
            while (iterator.hasNext()) {
                HTTPDownloader hTTPDownloader3 = (HTTPDownloader)iterator.next();
                if (hTTPDownloader2 != null && hTTPDownloader3.getAmountToRead() <= hTTPDownloader2.getAmountToRead()) continue;
                hTTPDownloader2 = hTTPDownloader3;
            }
        }
        if (hTTPDownloader2 == null) {
            throw new NoSuchElementException();
        }
        int n = hTTPDownloader2.getAmountRead();
        int n2 = hTTPDownloader2.getAmountToRead() - n;
        if (bl && n2 < 100000 || !bl && n2 < 100000) {
            float f = -1.0f;
            try {
                f = hTTPDownloader2.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                throw new NoSuchElementException();
            }
            if (!(f < MIN_ACCEPTABLE_SPEED)) throw new NoSuchElementException();
            int n3 = hTTPDownloader2.getInitialReadingPoint() + n;
            int n4 = hTTPDownloader2.getInitialReadingPoint() + hTTPDownloader2.getAmountToRead();
            hTTPDownloader.connectHTTP(this.getOverlapOffset(n3), n4, false);
            hTTPDownloader.stopAt(n4);
            this.debug("WORKER: picking stolen grey " + n3 + "-" + n4 + " from " + hTTPDownloader2 + " to " + hTTPDownloader);
            hTTPDownloader2.stopAt(n3);
            hTTPDownloader2.stop();
            return;
        }
        int n5 = bl ? hTTPDownloader2.getInitialReadingPoint() + hTTPDownloader2.getAmountToRead() - 100000 + 1 : hTTPDownloader2.getInitialReadingPoint() + n + n2 / 2;
        int n6 = hTTPDownloader2.getInitialReadingPoint() + hTTPDownloader2.getAmountToRead();
        hTTPDownloader.connectHTTP(this.getOverlapOffset(n5), n6, true);
        hTTPDownloader.stopAt(n6);
        hTTPDownloader2.stopAt(n5);
        this.debug("WORKER: assigning split grey " + n5 + "-" + n6 + " from " + hTTPDownloader2 + " to " + hTTPDownloader);
    }

    private int getOverlapOffset(int n) {
        return Math.max(0, n - 10);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDownload(HTTPDownloader hTTPDownloader, boolean bl) {
        ManagedDownloader managedDownloader;
        RemoteFileDesc remoteFileDesc;
        this.debug("WORKER: about to start downloading " + hTTPDownloader);
        boolean bl2 = false;
        try {
            try {
                hTTPDownloader.doDownload(this.commonOutFile, bl);
            }
            catch (IOException iOException) {
                bl2 = true;
                this.chatList.removeHost(hTTPDownloader);
                this.browseList.removeHost(hTTPDownloader);
                Object var6_5 = null;
                int n = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
                this.debug("    WORKER: terminating from " + hTTPDownloader + " at " + n + " error? " + bl2);
                RemoteFileDesc remoteFileDesc3 = hTTPDownloader.getRemoteFileDesc();
                ManagedDownloader managedDownloader3 = this;
                synchronized (managedDownloader3) {
                    if (bl2) {
                        this.updateNeeded(hTTPDownloader);
                    }
                    this.dloaders.remove(hTTPDownloader);
                    if (!bl2 && !bl) {
                        this.files.add(remoteFileDesc3);
                    }
                    int n3 = hTTPDownloader.getInitialReadingPoint();
                    return;
                }
            }
            Object var6_4 = null;
            int n = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
            this.debug("    WORKER: terminating from " + hTTPDownloader + " at " + n + " error? " + bl2);
            remoteFileDesc = hTTPDownloader.getRemoteFileDesc();
            managedDownloader = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            int n = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
            this.debug("    WORKER: terminating from " + hTTPDownloader + " at " + n + " error? " + bl2);
            RemoteFileDesc remoteFileDesc2 = hTTPDownloader.getRemoteFileDesc();
            ManagedDownloader managedDownloader2 = this;
            synchronized (managedDownloader2) {
                if (bl2) {
                    this.updateNeeded(hTTPDownloader);
                }
                this.dloaders.remove(hTTPDownloader);
                if (!bl2 && !bl) {
                    this.files.add(remoteFileDesc2);
                }
                int n2 = hTTPDownloader.getInitialReadingPoint();
                throw throwable;
            }
        }
        synchronized (managedDownloader) {
            if (bl2) {
                this.updateNeeded(hTTPDownloader);
            }
            this.dloaders.remove(hTTPDownloader);
            if (!bl2 && !bl) {
                this.files.add(remoteFileDesc);
            }
            int n = hTTPDownloader.getInitialReadingPoint();
            return;
        }
    }

    private synchronized void updateNeeded(HTTPDownloader hTTPDownloader) {
        int n = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
        int n2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountToRead() - 1;
        if (n2 - n > 0) {
            Interval interval = new Interval(n, n2);
            this.debug("Updating needed. Adding interval " + interval + " from " + hTTPDownloader);
            this.needed.add(interval);
        }
    }

    private synchronized int getNumAllowedDownloads() {
        int n = this.threads.size();
        int n2 = SettingsManager.instance().getConnectionSpeed();
        if (n2 <= 56) {
            return Math.max(2 - n, 0);
        }
        if (n2 <= 1000) {
            return Math.max(6 - n, 0);
        }
        return Math.max(8 - n, 0);
    }

    private synchronized RemoteFileDesc removeBest(List list) {
        Iterator iterator = list.iterator();
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc2 = (RemoteFileDesc)iterator.next();
            if (remoteFileDesc2.getSHA1Urn() != null && remoteFileDesc.getSHA1Urn() == null) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getSHA1Urn() == null != (remoteFileDesc.getSHA1Urn() == null)) continue;
            if (remoteFileDesc2.getQuality() > remoteFileDesc.getQuality()) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getQuality() != remoteFileDesc.getQuality() || remoteFileDesc2.getSpeed() <= remoteFileDesc.getSpeed()) continue;
            remoteFileDesc = remoteFileDesc2;
        }
        list.remove(remoteFileDesc);
        return remoteFileDesc;
    }

    private static boolean needsPush(RemoteFileDesc remoteFileDesc) {
        int n;
        String string = remoteFileDesc.getHost();
        if (new Endpoint(string, n = remoteFileDesc.getPort()).isPrivateAddress()) {
            return true;
        }
        if (remoteFileDesc instanceof RemoteFileDesc2) {
            return ((RemoteFileDesc2)remoteFileDesc).isUnreachable();
        }
        return false;
    }

    void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            if (this.corruptState == 0) {
                this.corruptState = 1;
                this.callback.promptAboutCorruptDownload(this);
            }
        }
    }

    public void discardCorruptDownload(boolean bl) {
        if (bl) {
            this.corruptState = 2;
            this.stop();
        } else {
            this.corruptState = 3;
        }
        Object object = this.corruptStateLock;
        synchronized (object) {
            this.corruptStateLock.notify();
        }
    }

    private synchronized LimeXMLDocument[] getXMLDocuments() {
        LimeXMLDocument[] limeXMLDocumentArray = null;
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.allFiles.length) {
            LimeXMLDocument limeXMLDocument;
            if (this.allFiles[n] != null && (limeXMLDocument = this.allFiles[n].getXMLDoc()) != null) {
                arrayList.add(limeXMLDocument);
            }
            ++n;
        }
        limeXMLDocumentArray = arrayList.size() > 0 ? (LimeXMLDocument[])arrayList.toArray(new LimeXMLDocument[0]) : null;
        return limeXMLDocumentArray;
    }

    private void cleanup() {
        this.miniRFDToLock.clear();
        this.threadLockToSocket.clear();
        if (this.needed != null) {
            this.needed.clear();
        }
        this.busy = null;
        this.files = null;
    }

    private void setState(int n) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = n;
            this.stateTime = Long.MAX_VALUE;
        }
    }

    private void setState(int n, long l) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = n;
            this.stateTime = System.currentTimeMillis() + l;
        }
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: {
                long l = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(l, 0L) / 1000;
            }
            case 8: {
                long l = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(l, 0L) / 1000;
            }
        }
        return Integer.MAX_VALUE;
    }

    public synchronized String getFileName() {
        if (this.dloaders.size() == 0) {
            return this.allFiles[0].getFileName();
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getFileName();
    }

    public synchronized int getContentLength() {
        if (this.dloaders.size() == 0) {
            return this.allFiles[0].getSize();
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getSize();
    }

    public synchronized int getAmountRead() {
        if (this.state == 9) {
            return this.corruptFileBytes;
        }
        if (this.state == 11) {
            if (this.incompleteFile == null) {
                return 0;
            }
            return URN.getHashingProgress(this.incompleteFile);
        }
        if (this.commonOutFile == null) {
            return 0;
        }
        return this.commonOutFile.getBlockSize();
    }

    public String getAddress() {
        return this.currentLocation;
    }

    public synchronized Iterator getHosts() {
        return this.getHosts(false);
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    public synchronized String getQueuePosition() {
        if (this.getState() != 10) {
            return "";
        }
        return this.queuePosition;
    }

    private final Iterator getHosts(boolean bl) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            HTTPDownloader hTTPDownloader = (HTTPDownloader)iterator.next();
            if (!(bl ? hTTPDownloader.chatEnabled() : true)) continue;
            linkedList.add(new Endpoint(hTTPDownloader.getInetAddress().getHostAddress(), hTTPDownloader.getPort()));
        }
        return linkedList.iterator();
    }

    public synchronized int getRetriesWaiting() {
        return this.retriesWaiting;
    }

    public synchronized void measureBandwidth() {
        float f = 0.0f;
        boolean bl = false;
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            bl = true;
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            bandwidthTracker.measureBandwidth();
            f += bandwidthTracker.getAverageBandwidth();
        }
        if (bl) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private boolean checkHosts() {
        byte[] byArray = new byte[]{65, 80, 80, 95, 84, 73, 84, 76, 69};
        String string = this.callback.getHostValue(new String(byArray));
        if (string == null) {
            return false;
        }
        return (string = string.substring(0, 8)).hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    private final void debug(String string) {
    }

    private final void debug(Exception exception) {
    }

    static void unitTest() {
        TreeSet treeSet = new TreeSet();
        TreeSet treeSet2 = new TreeSet();
        try {
            treeSet.add(URN.createSHA1Urn("urn:sha1:GLSTHIPQGSSZTS5FJUPAKPZWUGYQYPFB"));
            treeSet2.add(URN.createSHA1Urn("urn:sha1:GLSTHIPQGSSZTS5FJUPAKPZWUGYQYPFB"));
        }
        catch (IOException iOException) {
            Assert.that(false, "Couldn't make urn");
        }
        RemoteFileDesc remoteFileDesc = new RemoteFileDesc("1.2.3.4", 6346, 0L, "some file.txt", 1010, new byte[16], 1000, false, 3, false, null, null);
        RemoteFileDesc remoteFileDesc2 = new RemoteFileDesc("1.2.3.6", 6346, 0L, "some file.txt", 1010, new byte[16], 3000, false, 0, false, null, null);
        RemoteFileDesc remoteFileDesc3 = new RemoteFileDesc("1.2.3.6", 6346, 0L, "some file.txt", 1010, new byte[16], 3001, false, 0, false, null, null);
        RemoteFileDesc remoteFileDesc4 = new RemoteFileDesc("1.2.3.7", 6346, 0L, "some file.txt", 1010, new byte[16], 56, false, 0, false, null, treeSet);
        RemoteFileDesc remoteFileDesc5 = new RemoteFileDesc("1.2.3.7", 6346, 0L, "some file.txt", 1010, new byte[16], 57, false, 0, false, null, treeSet2);
        LinkedList linkedList = new LinkedList();
        linkedList.add(remoteFileDesc2);
        linkedList.add(remoteFileDesc4);
        linkedList.add(remoteFileDesc);
        linkedList.add(remoteFileDesc3);
        linkedList.add(remoteFileDesc5);
        ManagedDownloader managedDownloader = new ManagedDownloader();
        Assert.that(managedDownloader.removeBest(linkedList) == remoteFileDesc5);
        Assert.that(managedDownloader.removeBest(linkedList) == remoteFileDesc4);
        Assert.that(managedDownloader.removeBest(linkedList) == remoteFileDesc);
        Assert.that(linkedList.size() == 2);
        Assert.that(linkedList.contains(remoteFileDesc2));
        Assert.that(linkedList.contains(remoteFileDesc3));
        Assert.that(managedDownloader.removeBest(linkedList) == remoteFileDesc3);
        Assert.that(linkedList.size() == 1);
        Assert.that(linkedList.contains(remoteFileDesc2));
        Assert.that(managedDownloader.removeBest(linkedList) == remoteFileDesc2);
        Assert.that(linkedList.size() == 0);
    }

    private ManagedDownloader() {
        TRIVIAL_WORDS.add("the");
        TRIVIAL_WORDS.add("an");
        TRIVIAL_WORDS.add("a");
        this.initDone = false;
        this.SIXTY_KB = 60000L;
        this.debugOn = false;
        this.log = false;
        this.writer = null;
    }

    protected ManagedDownloader(RemoteFileDesc[] remoteFileDescArray) {
        TRIVIAL_WORDS.add("the");
        TRIVIAL_WORDS.add("an");
        TRIVIAL_WORDS.add("a");
        this.initDone = false;
        this.SIXTY_KB = 60000L;
        this.debugOn = false;
        this.log = false;
        this.writer = null;
        this.allFiles = remoteFileDescArray;
    }

    private class RequeryLock {
        private boolean shouldWait = true;

        private RequeryLock() {
        }

        public synchronized void release() {
            this.shouldWait = false;
            this.notifyAll();
        }

        public synchronized void lock(long l) throws InterruptedException {
            try {
                if (this.shouldWait) {
                    this.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                this.shouldWait = true;
                throw interruptedException;
            }
            this.shouldWait = true;
        }
    }
}

