/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.RemoteFileDesc2;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.UnsupportedOperationException;
import java.io.File;
import java.io.Serializable;

class RemoteFileDescGrouper
implements Serializable {
    private List buckets = new ArrayList();
    private List incompletes = new ArrayList();
    private URN[] sha1s = new URN[0];
    private IncompleteFileManager incompleteFileManager;
    private static final int DECENT_QUALITY = 2;
    static boolean DEBUG = false;

    RemoteFileDescGrouper(RemoteFileDesc[] remoteFileDescArray, IncompleteFileManager incompleteFileManager) {
        Object object;
        this.incompleteFileManager = incompleteFileManager;
        int n = 0;
        while (n < remoteFileDescArray.length) {
            this.add(remoteFileDescArray[n]);
            ++n;
        }
        this.repOk();
        Object[] objectArray = new FileTuple[this.buckets.size()];
        int n2 = 0;
        while (n2 < this.buckets.size()) {
            File file = (File)this.incompletes.get(n2);
            object = (List)this.buckets.get(n2);
            int n3 = ((RemoteFileDesc)object.get(0)).getSize() - incompleteFileManager.getBlockSize(file);
            int n4 = 1;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                RemoteFileDesc2 remoteFileDesc2 = (RemoteFileDesc2)iterator.next();
                if (remoteFileDesc2.getQuality() < 2) continue;
                n4 += RemoteFileDescGrouper.normalize(remoteFileDesc2.getSpeed());
            }
            float f = (float)n3 / (float)n4;
            objectArray[n2] = new FileTuple((List)object, file, this.sha1s[n2], f);
            ++n2;
        }
        Arrays.sort(objectArray);
        int n5 = 0;
        while (n5 < objectArray.length) {
            object = objectArray[n5];
            this.buckets.set(n5, ((FileTuple)object).bucket);
            this.incompletes.set(n5, ((FileTuple)object).incompleteFile);
            this.sha1s[n5] = ((FileTuple)object).sha1;
            ++n5;
        }
        this.repOk();
    }

    private static int normalize(int n) {
        if (n < 56) {
            return 3;
        }
        if (n < 350) {
            return 30;
        }
        if (n < 1000) {
            return 40;
        }
        return 50;
    }

    synchronized boolean add(RemoteFileDesc remoteFileDesc) {
        Serializable serializable;
        this.repOk();
        RemoteFileDesc2 remoteFileDesc2 = new RemoteFileDesc2(remoteFileDesc, false);
        File file = this.incompleteFileManager.getFile(remoteFileDesc2);
        int n = this.buckets.size();
        Assert.that(this.incompletes.size() == n, "Length of buckets and incompletes different: " + n + "!=" + this.incompletes.size());
        int n2 = 0;
        while (n2 < n) {
            serializable = (File)this.incompletes.get(n2);
            if (((File)serializable).equals(file) && RemoteFileDescGrouper.hashEquals(remoteFileDesc2.getSHA1Urn(), this.sha1s[n2])) {
                if (this.sha1s[n2] == null && remoteFileDesc2.getSHA1Urn() != null) {
                    this.sha1s[n2] = remoteFileDesc2.getSHA1Urn();
                }
                List list = (List)this.buckets.get(n2);
                list.add(remoteFileDesc2);
                this.repOk();
                return true;
            }
            ++n2;
        }
        serializable = new ArrayList();
        serializable.add(remoteFileDesc2);
        this.buckets.add(serializable);
        this.incompletes.add(file);
        int n3 = this.incompletes.size();
        URN[] uRNArray = new URN[n3];
        System.arraycopy(this.sha1s, 0, uRNArray, 0, this.sha1s.length);
        uRNArray[n3 - 1] = remoteFileDesc.getSHA1Urn();
        this.sha1s = uRNArray;
        this.repOk();
        return false;
    }

    synchronized URN getURNForBucket(int n) {
        if (n < 0 || n >= this.buckets.size()) {
            throw new IllegalArgumentException();
        }
        return this.sha1s[n];
    }

    private static boolean hashEquals(URN uRN, URN uRN2) {
        if (uRN == null || uRN2 == null) {
            return true;
        }
        return uRN.equals(uRN2);
    }

    Iterator buckets() {
        return new BucketIterator();
    }

    protected void repOk() {
        Object object;
        if (!DEBUG) {
            return;
        }
        Assert.that(this.buckets.size() == this.incompletes.size());
        Assert.that(this.buckets.size() == this.sha1s.length);
        int n = 0;
        while (n < this.buckets.size()) {
            List list = (List)this.buckets.get(n);
            object = (File)this.incompletes.get(n);
            int n2 = 0;
            while (n2 < list.size()) {
                File file = this.incompleteFileManager.getFile((RemoteFileDesc)list.get(n2));
                Assert.that(((File)object).equals(file));
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this.buckets.size()) {
            object = (List)this.buckets.get(n3);
            URN uRN = this.sha1s[n3];
            boolean bl = false;
            int n4 = 0;
            while (n4 < object.size()) {
                URN uRN2 = ((RemoteFileDesc)object.get(n4)).getSHA1Urn();
                if (uRN2 != null) {
                    Assert.that(uRN != null);
                    Assert.that(uRN.equals(uRN2));
                    bl = true;
                }
                ++n4;
            }
            ++n3;
        }
    }

    private class BucketIterator
    implements Iterator {
        int i = 0;

        private BucketIterator() {
        }

        public boolean hasNext() {
            RemoteFileDescGrouper remoteFileDescGrouper = RemoteFileDescGrouper.this;
            synchronized (remoteFileDescGrouper) {
                boolean bl = this.i < RemoteFileDescGrouper.this.buckets.size();
                return bl;
            }
        }

        public Object next() {
            RemoteFileDescGrouper remoteFileDescGrouper = RemoteFileDescGrouper.this;
            synchronized (remoteFileDescGrouper) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = RemoteFileDescGrouper.this.buckets.get(this.i++);
                return object;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FileTuple
    implements Comparable {
        List bucket;
        File incompleteFile;
        URN sha1;
        float time;

        public FileTuple(List list, File file, URN uRN, float f) {
            this.bucket = list;
            this.incompleteFile = file;
            this.sha1 = uRN;
            this.time = f;
        }

        public int compareTo(Object object) {
            float f = this.time - ((FileTuple)object).time;
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

