/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.sun.java.util.collections.HashSet;
import java.io.File;
import java.io.Serializable;

public class ResumeDownloader
extends ManagedDownloader
implements Serializable {
    static final long serialVersionUID = -4535935715006098724L;
    private final File _incompleteFile;
    private final String _name;
    private final int _size;
    private final URN _hash;

    public ResumeDownloader(IncompleteFileManager incompleteFileManager, File file, String string, int n) {
        super(new RemoteFileDesc[0], incompleteFileManager);
        this._incompleteFile = file;
        this._name = string;
        this._size = n;
        this._hash = incompleteFileManager.getCompletedHash(file);
    }

    public void initialize(DownloadManager downloadManager, FileManager fileManager, ActivityCallback activityCallback) {
        this.initializeIncompleteFile(this._incompleteFile);
        super.initialize(downloadManager, fileManager, activityCallback);
    }

    public boolean conflicts(File file) {
        return file.equals(this._incompleteFile);
    }

    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        return IncompleteFileManager.same(this._name, this._size, this._hash, remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getSHA1Urn());
    }

    public synchronized String getFileName() {
        return this._name;
    }

    public synchronized int getContentLength() {
        return this._size;
    }

    public QueryRequest newRequery() {
        HashSet hashSet = null;
        if (this._hash != null) {
            hashSet = new HashSet(1);
            hashSet.add(this._hash);
        }
        return new QueryRequest(QueryRequest.newQueryGUID(true), 7, 0, this.getFileName(), null, true, null, hashSet);
    }
}

