/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.util.IntervalSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class VerifyingFile {
    private RandomAccessFile fos;
    private boolean checkOverlap;
    private ManagedDownloader managedDownloader;
    private IntervalSet writtenBlocks;

    public VerifyingFile(boolean bl) {
        this.checkOverlap = bl;
        this.writtenBlocks = new IntervalSet();
    }

    public void open(File file, ManagedDownloader managedDownloader) throws IOException {
        this.managedDownloader = managedDownloader;
        this.fos = new RandomAccessFile(file, "rw");
    }

    public synchronized void addInterval(Interval interval) {
        this.writtenBlocks.add(interval);
    }

    public synchronized void writeBlock(long l, int n, byte[] byArray) throws IOException {
        if (this.fos == null) {
            throw new IOException();
        }
        boolean bl = false;
        List list = null;
        Interval interval = null;
        if (this.checkOverlap && (list = this.writtenBlocks.getOverlapIntervals(interval = new Interval((int)l, (int)l + n - 1))).size() > 0) {
            bl = true;
        }
        if (bl) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Interval interval2 = (Interval)iterator.next();
                int n2 = interval2.high - interval2.low + 1;
                byte[] byArray2 = new byte[n2];
                this.fos.seek(interval2.low);
                this.fos.readFully(byArray2, 0, n2);
                int n3 = this.findInitialPoint(interval2, l, n);
                int n4 = 0;
                while (n4 < n2) {
                    if (byArray[n3] != byArray2[n4] && this.managedDownloader != null) {
                        this.managedDownloader.promptAboutCorruptDownload();
                    }
                    ++n4;
                    ++n3;
                }
            }
        }
        this.fos.seek(l);
        this.fos.write(byArray, 0, n);
        if (interval == null) {
            this.writtenBlocks.add(new Interval((int)l, (int)l + n - 1));
        } else {
            this.writtenBlocks.add(interval);
        }
    }

    public synchronized Iterator getBlocks() {
        return this.writtenBlocks.getAllIntervals();
    }

    public synchronized List getBlocksAsList() {
        return this.writtenBlocks.getAllIntervalsAsList();
    }

    public synchronized Iterator getFreeBlocks(int n) {
        return this.writtenBlocks.getNeededIntervals(n);
    }

    public synchronized int getBlockSize() {
        return this.writtenBlocks.getSize();
    }

    public void close() {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int findInitialPoint(Interval interval, long l, long l2) {
        if ((long)interval.low <= l) {
            return 0;
        }
        return interval.low - (int)l;
    }
}

