/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import java.util.StringTokenizer;

class IP {
    private long addr;
    private long mask;
    private static final long DEFAULT_MASK = 0xFFFFFFFFL;
    private static final short IP_V = 4;

    IP(String string) {
        this(IP.stringToIP(string));
    }

    IP(String[] stringArray) {
        this(IP.stringToIP(stringArray));
    }

    IP(long l, long l2) {
        this.addr = l & l2;
        this.mask = l2;
    }

    IP(long l) {
        this.addr = l;
        this.mask = 0xFFFFFFFFL;
    }

    IP(IP iP) {
        this.addr = iP.addr & iP.mask;
        this.mask = iP.mask;
    }

    private static IP stringToIP(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (stringArray.length != 2 && stringArray.length != 1) {
            throw new IllegalArgumentException();
        }
        if (stringArray.length == 1) {
            return new IP(IP.stringToLong(stringArray[0].replace('*', '0')), IP.parseForWildChars(stringArray[0]));
        }
        return new IP(IP.stringToLong(stringArray[0].replace('*', '0')), IP.stringToLong(stringArray[1]) & IP.parseForWildChars(stringArray[0]));
    }

    private static IP stringToIP(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new IllegalArgumentException();
        }
        return new IP(IP.stringToLong(stringArray[0]), IP.stringToLong(stringArray[1]));
    }

    private static long stringToLong(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException();
        }
        long l = 0L;
        int n = 0;
        while (n < 4) {
            try {
                l <<= 8;
                l += (long)Short.parseShort(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException();
            }
            ++n;
        }
        return l;
    }

    private static long parseForWildChars(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException();
        }
        long l = 0L;
        int n = 0;
        while (n < 4) {
            l <<= 8;
            if (!stringTokenizer.nextToken().equalsIgnoreCase("*")) {
                l += 255L;
            }
            ++n;
        }
        return l;
    }

    long getAddr() {
        return this.addr;
    }

    long getMask() {
        return this.mask;
    }

    public long getMaskedAddr() {
        return this.mask & this.addr;
    }

    public long getIMaskedAddr() {
        return this.mask & (this.addr ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
    }

    public boolean contains(IP iP) {
        return (iP.addr & this.mask) == (this.addr & this.mask);
    }

    public boolean equals(Object object) {
        if (object instanceof IP) {
            IP iP = (IP)object;
            return this.addr == iP.addr && this.mask == iP.mask;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.addr ^ this.mask);
    }
}

