/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.SpamFilter;
import com.limegroup.gnutella.filters.IPList;

public final class IPFilter
extends SpamFilter {
    private final IPList badHosts = new IPList();
    private final IPList goodHosts = new IPList();

    public IPFilter() {
        String[] stringArray = SettingsManager.instance().getBannedIps();
        int n = 0;
        while (n < stringArray.length) {
            this.badHosts.add(stringArray[n]);
            ++n;
        }
        stringArray = SettingsManager.instance().getAllowedIps();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.goodHosts.add(stringArray[n2]);
            ++n2;
        }
    }

    public boolean allow(String string) {
        return this.goodHosts.contains(string) || !this.badHosts.contains(string);
    }

    public boolean allow(Message message) {
        String string;
        if (message instanceof PingReply) {
            PingReply pingReply = (PingReply)message;
            string = pingReply.getIP();
        } else if (message instanceof QueryReply) {
            QueryReply queryReply = (QueryReply)message;
            string = queryReply.getIP();
        } else if (message instanceof PushRequest) {
            PushRequest pushRequest = (PushRequest)message;
            string = IPFilter.ip2string(pushRequest.getIP());
        } else {
            return true;
        }
        return this.allow(string);
    }

    private static String ip2string(byte[] byArray) {
        return new Endpoint(byArray, 0).getHostname();
    }
}

