/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.ScrollingTextPane;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

final class AboutWindow {
    private final JDialog DIALOG = new JDialog();
    private final BoxPanel MAIN_PANEL = new BoxPanel(1);
    private final Dimension DIALOG_DIMENSION = new Dimension(450, 400);
    private final ScrollingTextPane SCROLLING_PANE = new ScrollingTextPane(GUIMediator.getStringResource("ABOUT_FILE_NAME"));
    private final JCheckBox SCROLL_CHECK_BOX = new JCheckBox(GUIMediator.getStringResource("ABOUT_SCROLL_CHECK_BOX_LABEL"));

    AboutWindow() {
        this.DIALOG.setModal(true);
        this.DIALOG.setResizable(false);
        this.DIALOG.setTitle(GUIMediator.getStringResource("ABOUT_TITLE"));
        this.SCROLLING_PANE.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL uRL = hyperlinkEvent.getURL();
                if (uRL == null) {
                    return;
                }
                try {
                    GUIMediator.openURL(uRL.toExternalForm());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.SCROLL_CHECK_BOX.setSelected(true);
        this.SCROLL_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                    AboutWindow.this.SCROLLING_PANE.startScroll();
                } else {
                    AboutWindow.this.SCROLLING_PANE.stopScroll();
                }
            }
        });
        BoxPanel boxPanel = new BoxPanel(1);
        Border border = BorderFactory.createEmptyBorder(6, 6, 6, 6);
        boxPanel.setBorder(border);
        boxPanel.add(GUIMediator.getVerticalSeparator());
        LogoPanel logoPanel = new LogoPanel();
        logoPanel.setSearching(true);
        boxPanel.add(logoPanel);
        boxPanel.add(Box.createVerticalStrut(17));
        String string = GUIMediator.getStringResource("ABOUT_LABEL_START");
        String string2 = CommonUtils.getLimeWireVersion();
        String string3 = GUIMediator.getStringResource("ABOUT_LABEL_ADDRESS");
        String[] stringArray = new String[]{string + " " + string2, string3};
        MultiLineLabel multiLineLabel = new MultiLineLabel(stringArray);
        multiLineLabel.setFont(new Font("Sans Serif", 0, 11));
        multiLineLabel.setForeground(Color.black);
        Dimension dimension = new Dimension(this.DIALOG_DIMENSION.width - 12, 40);
        multiLineLabel.setPreferredSize(dimension);
        multiLineLabel.setMaximumSize(dimension);
        BoxPanel boxPanel2 = new BoxPanel(0);
        boxPanel2.add(Box.createRigidArea(new Dimension(this.DIALOG_DIMENSION.width / 2 - ((Component)multiLineLabel).getFontMetrics(multiLineLabel.getFont()).stringWidth(string3) / 2, 0)));
        boxPanel2.add(multiLineLabel);
        boxPanel.add(boxPanel2);
        boxPanel.add(this.SCROLLING_PANE);
        ((Component)this.DIALOG).setSize(this.DIALOG_DIMENSION);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)AboutWindow.this.DIALOG).setVisible(false);
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }
        };
        String[] stringArray2 = new String[]{"ABOUT_BUTTON_LABEL"};
        String[] stringArray3 = new String[]{"ABOUT_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{actionListener};
        JButton jButton = new JButton(GUIMediator.getStringResource("ABOUT_BUTTON_LABEL"));
        jButton.setToolTipText(GUIMediator.getStringResource("ABOUT_BUTTON_TIP"));
        jButton.addActionListener(actionListener);
        BoxPanel boxPanel3 = new BoxPanel(0);
        boxPanel3.add(Box.createHorizontalGlue());
        boxPanel3.add(this.SCROLL_CHECK_BOX);
        boxPanel3.add(GUIMediator.getHorizontalSeparator());
        boxPanel3.add(jButton);
        boxPanel3.add(Box.createHorizontalGlue());
        Container container = this.DIALOG.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(boxPanel);
        container.add(GUIMediator.getVerticalSeparator());
        container.add(boxPanel3);
        container.add(Box.createVerticalStrut(6));
    }

    void showDialog() {
        GUIMediator.instance();
        if (GUIMediator.getAppVisible()) {
            this.DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            ((Component)this.DIALOG).setLocation(GUIMediator.getScreenCenterPoint(this.DIALOG));
        }
        if (this.SCROLL_CHECK_BOX.isSelected()) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                        AboutWindow.this.SCROLLING_PANE.startScroll();
                    }
                }
            };
            Timer timer = new Timer(10000, actionListener);
            timer.setRepeats(false);
            timer.start();
        }
        ((Component)this.DIALOG).setVisible(true);
    }
}

