/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.util.Buffer;
import javax.swing.AbstractListModel;

public class BufferListModel
extends AbstractListModel {
    private Buffer buffer;

    public BufferListModel(int n) {
        this.buffer = new Buffer(n);
    }

    public Object getElementAt(int n) {
        return this.buffer.get(n);
    }

    public int getSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getSize();
    }

    public void changeSize(int n) {
        if (n == 0) {
            int n2 = 0;
            if (this.buffer != null) {
                n2 = this.buffer.getSize();
            }
            this.buffer = null;
            this.fireContentsChanged(this, 0, n2);
            return;
        }
        Buffer buffer = new Buffer(n);
        int n3 = 0;
        while (this.buffer != null && n3 < Math.min(this.buffer.getSize(), n)) {
            buffer.addFirst(this.buffer.get(n3));
            ++n3;
        }
        this.buffer = buffer;
    }

    public void removeAllElements() {
        if (this.buffer == null) {
            return;
        }
        this.buffer.clear();
        this.fireContentsChanged(this, 0, this.buffer.getCapacity());
    }

    public void addFirst(Object object) {
        if (this.buffer == null) {
            return;
        }
        this.buffer.addFirst(object);
        this.fireContentsChanged(this, 0, this.buffer.getSize());
    }
}

