/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class ButtonRow
extends JPanel {
    private JButton[] _buttons;
    private final int BUTTON_SEP = 6;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int TOP_GLUE = 10;
    public static final int BOTTOM_GLUE = 11;
    public static final int LEFT_GLUE = 12;
    public static final int RIGHT_GLUE = 13;
    public static final int NO_GLUE = 14;

    public ButtonRow(String[] stringArray, String[] stringArray2, ActionListener[] actionListenerArray) {
        this(stringArray, stringArray2, actionListenerArray, 0, 14);
    }

    public ButtonRow(String[] stringArray, String[] stringArray2, ActionListener[] actionListenerArray, int n, int n2) {
        Object object;
        if (stringArray.length != stringArray2.length || stringArray.length != actionListenerArray.length || stringArray2.length != actionListenerArray.length) {
            throw new IllegalArgumentException("invalid ButtonRow constructor: array lengths must be equal");
        }
        BoxLayout boxLayout = new BoxLayout(this, n);
        this.setLayout(boxLayout);
        int n3 = stringArray.length;
        int n4 = n3 - 1;
        this._buttons = new JButton[n3];
        Component[] componentArray = new Component[n4];
        int n5 = 0;
        while (n5 < n3) {
            object = GUIMediator.getStringResource(stringArray[n5]);
            this._buttons[n5] = new JButton((String)object);
            if (stringArray2[n5] != null) {
                String string = GUIMediator.getStringResource(stringArray2[n5]);
                this._buttons[n5].setToolTipText(string);
            }
            ++n5;
        }
        this.setListeners(actionListenerArray);
        n5 = 0;
        if (n == 0) {
            object = new Dimension(6, 0);
            while (n5 < n4) {
                componentArray[n5] = Box.createRigidArea((Dimension)object);
                ++n5;
            }
        } else {
            object = new Dimension(0, 6);
            while (n5 < n4) {
                componentArray[n5] = Box.createRigidArea((Dimension)object);
                ++n5;
            }
        }
        n5 = 0;
        if (n2 == 10 && n == 1) {
            this.add(Box.createVerticalGlue());
        } else if (n2 == 12 && n == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (n2 == 14 && n == 0) {
            this.add(Box.createHorizontalGlue());
        }
        while (n5 < n3) {
            this.add(this._buttons[n5]);
            if (n5 < n4) {
                this.add(componentArray[n5]);
            }
            ++n5;
        }
        if (n2 == 11 && n == 1) {
            this.add(Box.createVerticalGlue());
        } else if (n2 == 13 && n == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (n2 == 14 && n == 0) {
            this.add(Box.createHorizontalGlue());
        }
    }

    private void setListeners(ActionListener[] actionListenerArray) {
        int n = 0;
        int n2 = actionListenerArray.length;
        int n3 = this._buttons.length;
        if (n2 <= n3) {
            while (n < n3) {
                this._buttons[n].addActionListener(actionListenerArray[n]);
                ++n;
            }
        }
    }

    public JButton getButtonAtIndex(int n) {
        if (n > this._buttons.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._buttons[n];
    }

    public void setButtonEnabled(int n, boolean bl) {
        if (n > this._buttons.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._buttons[n].setEnabled(bl);
    }

    public void setButtonsEnabled(boolean bl) {
        int n = 0;
        while (n < this._buttons.length) {
            this._buttons[n].setEnabled(bl);
            ++n;
        }
    }
}

