/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.awt.Dimension;
import java.awt.Point;

final class Finalizer {
    private static final List FINALIZERS = new ArrayList();
    private static boolean _wasConnected;
    private static boolean _shutdownImminent;
    private static boolean _uploadsComplete;
    private static boolean _downloadsComplete;

    private Finalizer() {
    }

    static boolean isShutdownImminent() {
        return _shutdownImminent;
    }

    static void shutdown() {
        try {
            Object object;
            SettingsManager settingsManager = SettingsManager.instance();
            NotifyUserProxy.instance().removeNotify();
            if (GUIMediator.getAppVisible()) {
                object = GUIMediator.getAppSize();
                if (((Dimension)object).height > 100 && ((Dimension)object).width > 100) {
                    Point point = GUIMediator.getAppLocation();
                    settingsManager.setAppWidth(((Dimension)object).width);
                    settingsManager.setAppHeight(((Dimension)object).height);
                    settingsManager.setWindowX(point.x);
                    settingsManager.setWindowY(point.y);
                    settingsManager.setRunOnce(true);
                }
            }
            if ((object = GUIMediator.instance().getRouter()) != null) {
                RouterService.shutdown();
            } else {
                settingsManager.writeProperties();
            }
            int n = 0;
            while (n < FINALIZERS.size()) {
                ((FinalizeListener)FINALIZERS.get(n)).doFinalize();
                ++n;
            }
            System.exit(0);
        }
        catch (Exception exception) {
            GUIMediator.showInternalError(exception);
            System.exit(0);
        }
    }

    static void shutdownAfterTransfers() {
        if (Finalizer.isShutdownImminent()) {
            return;
        }
        _shutdownImminent = true;
        RouterService routerService = GUIMediator.instance().getRouter();
        _wasConnected = RouterService.isConnected();
        RouterService.setIsShuttingDown(true);
        if (_wasConnected) {
            RouterService.disconnect();
        }
        if (Finalizer.transfersComplete()) {
            GUIMediator.shutdown();
        }
    }

    public static void cancelShutdown() {
        _shutdownImminent = false;
        _uploadsComplete = false;
        _downloadsComplete = false;
        RouterService routerService = GUIMediator.instance().getRouter();
        if (_wasConnected) {
            RouterService.connect();
        }
        RouterService.setIsShuttingDown(false);
    }

    static void setDownloadsComplete() {
        _downloadsComplete = true;
        Finalizer.checkForShutdown();
    }

    static void setUploadsComplete() {
        _uploadsComplete = true;
        Finalizer.checkForShutdown();
    }

    private static boolean transfersComplete() {
        RouterService routerService = GUIMediator.instance().getRouter();
        if (routerService == null) {
            return true;
        }
        if (RouterService.getNumDownloads() == 0) {
            _downloadsComplete = true;
        }
        if (RouterService.getNumUploads() == 0) {
            _uploadsComplete = true;
        }
        return _uploadsComplete & _downloadsComplete;
    }

    private static void checkForShutdown() {
        if (_shutdownImminent && _uploadsComplete && _downloadsComplete) {
            GUIMediator.shutdown();
        }
    }

    static void addFinalizeListener(FinalizeListener finalizeListener) {
        FINALIZERS.add(finalizeListener);
    }
}

